/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class AlignAction
extends UndoableAction {
    private static final long serialVersionUID = 4982051206522858526L;
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    private List<Fig> figs;
    private int direction;
    private Map<Fig, Rectangle> boundsByFig;

    public AlignAction(int n2) {
        super(Localizer.localize("GefBase", "Align" + AlignAction.wordFor(n2)));
        this.direction = n2;
    }

    public AlignAction(int n2, List<Fig> list) {
        super(Localizer.localize("GefBase", "Align" + AlignAction.wordFor(n2)));
        this.direction = n2;
        this.figs = list;
    }

    private static String wordFor(int n2) {
        switch (n2) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Lefts";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "HorizontalCenters";
            }
            case 6: {
                return "VerticalCenters";
            }
            case 7: {
                return "ToGrid";
            }
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        int n2;
        super.actionPerformed((ActionEvent)serializable);
        serializable = new ArrayList();
        Editor editor = Globals.curEditor();
        if (this.figs == null) {
            SelectionManager selectionManager = editor.getSelectionManager();
            if (selectionManager.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            serializable.addAll(selectionManager.getSelectedFigs());
        } else {
            serializable.addAll(this.figs);
        }
        int n3 = serializable.size();
        if (n3 == 0) {
            return;
        }
        Rectangle rectangle = ((Fig)serializable.get(0)).getBounds();
        for (n2 = 1; n2 < n3; ++n2) {
            rectangle.add(((Fig)serializable.get(n2)).getBounds());
        }
        this.boundsByFig = new HashMap<Fig, Rectangle>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            Fig fig = (Fig)serializable.get(n2);
            this.boundsByFig.put(fig, fig.getBounds());
            fig.align(rectangle, this.direction, editor);
            fig.endTrans();
        }
    }
}

