/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.graph.MutableGraphSupport;

public class CmdNudge
extends Cmd {
    private static final long serialVersionUID = 258695407526065145L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int _direction;
    private int _magnitude;

    public CmdNudge(int n2) {
        this(n2, 1);
    }

    public CmdNudge(int n2, int n3) {
        super("Nudge" + CmdNudge.wordFor(n2));
        this._direction = n2;
        this._magnitude = n3;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        SelectionManager selectionManager = Globals.curEditor().getSelectionManager();
        if (selectionManager.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (this._direction) {
            case 1: {
                n2 = 0 - this._magnitude;
                break;
            }
            case 2: {
                n2 = this._magnitude;
                break;
            }
            case 3: {
                n3 = 0 - this._magnitude;
                break;
            }
            case 4: {
                n3 = this._magnitude;
            }
        }
        selectionManager.translate(n2, n3);
        MutableGraphSupport.enableSaveAction();
        selectionManager.endTrans();
    }

    @Override
    public void undoIt() {
        System.out.println("Cannot undo CmdNudge, yet.");
    }
}

