/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdSave
extends Cmd
implements FilenameFilter {
    private static final long serialVersionUID = -548213442545482573L;

    public CmdSave() {
        super("Save");
    }

    public CmdSave(String string) {
        this();
        this.setArg("filterPattern", string);
    }

    @Override
    public void doIt() {
        try {
            Editor editor = Globals.curEditor();
            Object object = new FileDialog(editor.findFrame(), "Save Diagram", 1);
            ((FileDialog)object).setFilenameFilter(this);
            ((FileDialog)object).setDirectory(Globals.getLastDirectory());
            ((Dialog)object).setVisible(true);
            String string = ((FileDialog)object).getFile();
            object = ((FileDialog)object).getDirectory();
            Globals.setLastDirectory((String)object);
            if (string != null) {
                Globals.showStatus("Writing " + (String)object + string + "...");
                FileOutputStream fileOutputStream = new FileOutputStream((String)object + string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                editor.preSave();
                objectOutputStream.writeObject(editor.getLayerManager().getContents());
                editor.postSave();
                Globals.showStatus("Wrote " + (String)object + string);
                fileOutputStream.close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
            return;
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }
}

