/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;

public class CmdScroll
extends Cmd {
    private static final long serialVersionUID = -7306747105045822502L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int _direction;
    private int _magnitude;

    public CmdScroll(int n2) {
        super("Scroll" + CmdScroll.wordFor(n2));
        this._direction = n2;
        this._magnitude = 16;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        int n2 = 0;
        int n3 = 0;
        switch (this._direction) {
            case 1: {
                n2 = this._magnitude;
                break;
            }
            case 2: {
                n2 = 0 - this._magnitude;
                break;
            }
            case 3: {
                n3 = this._magnitude;
                break;
            }
            case 4: {
                n3 = 0 - this._magnitude;
            }
        }
        System.out.println("Scrolling by " + n2 + ", " + n3);
    }

    @Override
    public void undoIt() {
        System.out.println("Cannot undo CmdScroll, yet.");
    }
}

