/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModePlace;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.undo.UndoableAction;

public class CreateNodeAction
extends UndoableAction
implements GraphFactory {
    private static final long serialVersionUID = 7466949364922746851L;
    public static Class DEFAULT_NODE_CLASS = NetNode.class;
    private static Log LOG = LogFactory.getLog(CreateNodeAction.class);
    private Hashtable args;
    protected String resource;

    public CreateNodeAction(Hashtable hashtable, String string, String string2) {
        super(string2);
        this.args = hashtable;
        this.resource = string;
    }

    public CreateNodeAction(Hashtable hashtable, String string) {
        this(hashtable, "GefBase", string);
    }

    public CreateNodeAction(Class clazz, String string, String string2) {
        this(new Hashtable(), string, string2);
        this.setArg("className", clazz);
    }

    public CreateNodeAction(Object object, String string, ImageIcon imageIcon) {
        super(string, imageIcon);
        this.setArg("className", object);
    }

    public CreateNodeAction(Class clazz, String string) {
        this(new Hashtable(), string);
        this.setArg("className", clazz);
    }

    public CreateNodeAction(Class clazz, boolean bl2, String string, String string2) {
        this(clazz, string, string2);
        this.setArg("shouldBeSticky", bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public CreateNodeAction(Class clazz, boolean bl2, String string) {
        this(clazz, string);
        this.setArg("shouldBeSticky", bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        super.actionPerformed((ActionEvent)object);
        object = Globals.curEditor().getGraphModel();
        if (!(object instanceof MutableGraphModel)) {
            return;
        }
        this.setArg("graphModel", object);
        object = null;
        Object object2 = this.getValue("Name");
        if (object2 != null) {
            object = "Click to place " + object2.toString();
        }
        object = this.createMode((String)object);
        object2 = this.getArg("shouldBeSticky");
        Globals.mode((Mode)object, object2 == Boolean.TRUE);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mode set to ModePlace with sticky mode " + object2));
        }
    }

    protected Mode createMode(String string) {
        return new ModePlace(this, string);
    }

    @Override
    public GraphModel makeGraphModel() {
        return null;
    }

    @Override
    public Object makeEdge() {
        return null;
    }

    @Override
    public Object makeNode() {
        Object object;
        if (this.getArg("className", DEFAULT_NODE_CLASS) instanceof Action) {
            ((ActionListener)null).actionPerformed(null);
            object = ((Action)null).getValue("node");
        } else {
            Class clazz = (Class)this.getArg("className", DEFAULT_NODE_CLASS);
            try {
                object = clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.error((Object)("Unable to instantiate node " + clazz.getName()));
                return null;
            }
            catch (InstantiationException instantiationException) {
                LOG.error((Object)("Failed to instantiate node " + clazz.getName()));
                return null;
            }
        }
        LOG.debug((Object)("New node created " + object));
        if (object instanceof GraphNodeHooks) {
            LOG.debug((Object)"Initializing GraphNodeHooks");
            ((GraphNodeHooks)object).initialize(this.args);
        }
        return object;
    }

    public Object getActiveGraphModel() {
        return this.getArg("graphModel");
    }

    protected void setArg(String string, Object object) {
        if (this.args == null) {
            this.args = new Hashtable();
        }
        this.args.put(string, object);
    }

    protected Object getArg(String string) {
        if (this.args == null) {
            return null;
        }
        return this.args.get(string);
    }

    protected Object getArg(String string, Object object) {
        if (this.args == null) {
            return object;
        }
        if ((string = this.args.get(string)) == null) {
            return object;
        }
        return string;
    }
}

