/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class DistributeAction
extends UndoableAction {
    private static final long serialVersionUID = 3630014084522093432L;
    public static final int H_SPACING = 0;
    public static final int H_CENTERS = 1;
    public static final int H_PACK = 2;
    public static final int V_SPACING = 4;
    public static final int V_CENTERS = 5;
    public static final int V_PACK = 6;
    private int _request;
    private Rectangle _bbox = null;
    private List<Fig> figs;
    private Integer gap;

    public DistributeAction(int n2) {
        super(Localizer.localize("GefBase", "Distribute" + DistributeAction.wordFor(n2)));
        this._request = n2;
    }

    public DistributeAction(int n2, List<Fig> list) {
        this(n2);
        this.figs = list;
    }

    private static String wordFor(int n2) {
        switch (n2) {
            case 0: {
                return "HorizontalSpacing";
            }
            case 1: {
                return "HorizontalCenters";
            }
            case 2: {
                return "Leftward";
            }
            case 4: {
                return "VerticalSpacing";
            }
            case 5: {
                return "VerticalCenters";
            }
            case 6: {
                return "Upward";
            }
        }
        return "";
    }

    public void setBoundingBox(Rectangle rectangle) {
        this._bbox = rectangle;
    }

    public void setGap(Integer n2) {
        this.gap = n2;
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        int n2;
        super.actionPerformed((ActionEvent)serializable);
        serializable = new ArrayList();
        KeyListener keyListener = Globals.curEditor();
        int n3 = 8;
        if (this.gap != null) {
            n3 = this.gap;
        }
        if (this.figs == null) {
            if (((SelectionManager)(keyListener = ((Editor)keyListener).getSelectionManager())).getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            serializable.addAll(((SelectionManager)keyListener).getSelectedFigs());
        } else {
            serializable.addAll(this.figs);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = serializable.size();
        if (n8 == 0) {
            return;
        }
        Fig fig = (Fig)serializable.get(0);
        if (this._bbox == null) {
            this._bbox = fig.getBounds();
            n4 = this._bbox.x + this._bbox.width / 2;
            n5 = this._bbox.x + this._bbox.width / 2;
            n6 = this._bbox.y + this._bbox.height / 2;
            n7 = this._bbox.y + this._bbox.height / 2;
            for (n2 = 1; n2 < n8; ++n2) {
                Rectangle rectangle = ((Fig)serializable.get(n2)).getBounds();
                this._bbox.add(rectangle);
                n4 = Math.min(n4, rectangle.x + rectangle.width / 2);
                n5 = Math.max(n5, rectangle.x + rectangle.width / 2);
                n6 = Math.min(n6, rectangle.y + rectangle.height / 2);
                n7 = Math.max(n7, rectangle.y + rectangle.height / 2);
            }
        }
        n2 = 0;
        int n9 = 0;
        for (int i2 = 0; i2 < n8; ++i2) {
            fig = (Fig)serializable.get(i2);
            n2 += fig.getWidth();
            n9 += fig.getHeight();
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this._request) {
            case 0: {
                f4 = this._bbox.x;
                f2 = (this._bbox.width - n2) / Math.max(n8 - 1, 1);
                break;
            }
            case 1: {
                f4 = n4;
                f3 = (n5 - n4) / Math.max(n8 - 1, 1);
                break;
            }
            case 2: {
                f4 = this._bbox.x;
                f2 = n3;
                break;
            }
            case 4: {
                f5 = this._bbox.y;
                f2 = (this._bbox.height - n9) / Math.max(n8 - 1, 1);
                break;
            }
            case 5: {
                f5 = n6;
                f3 = (n7 - n6) / Math.max(n8 - 1, 1);
                break;
            }
            case 6: {
                f5 = this._bbox.y;
                f2 = n3;
            }
        }
        for (n4 = 0; n4 < n8; ++n4) {
            for (n3 = n4 + 1; n3 < n8; ++n3) {
                Fig fig2 = (Fig)serializable.get(n4);
                Fig fig3 = (Fig)serializable.get(n3);
                if (this._request == 0 || this._request == 1 || this._request == 2) {
                    if (fig2.getX() <= fig3.getX()) continue;
                    this.swap((List<Fig>)((Object)serializable), n4, n3);
                    continue;
                }
                if (fig2.getY() <= fig3.getY()) continue;
                this.swap((List<Fig>)((Object)serializable), n4, n3);
            }
        }
        for (n4 = 0; n4 < n8; ++n4) {
            fig = (Fig)serializable.get(n4);
            switch (this._request) {
                case 0: 
                case 2: {
                    fig.setLocation((int)f4, fig.getY());
                    f4 += (float)fig.getWidth() + f2;
                    break;
                }
                case 1: {
                    fig.setLocation((int)f4 - fig.getWidth() / 2, fig.getY());
                    f4 += f3;
                    break;
                }
                case 4: 
                case 6: {
                    fig.setLocation(fig.getX(), (int)f5);
                    f5 += (float)fig.getHeight() + f2;
                    break;
                }
                case 5: {
                    fig.setLocation(fig.getX(), (int)f5 - fig.getHeight() / 2);
                    f5 += f3;
                }
            }
            fig.endTrans();
        }
    }

    public void undoIt() {
    }

    protected void swap(List<Fig> list, int n2, int n3) {
        Fig fig = list.get(n2);
        list.add(n2, list.get(n3));
        list.add(n3, fig);
    }

    public Rectangle getBoundingBox() {
        return this._bbox;
    }
}

