/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Guide;
import org.tigris.gef.base.GuideGrid;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.base.LayerGrid;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.ModeFactory;
import org.tigris.gef.base.ModeManager;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.presentation.FigTextEditor;
import org.tigris.gef.presentation.TextEditor;

public class Editor
implements KeyListener,
MouseListener,
MouseMotionListener,
Serializable {
    private static final long serialVersionUID = 2324579872610012639L;
    public static final int GRIP_SIZE = 8;
    protected ModeManager _modeManager = new ModeManager(this);
    protected Object _document;
    protected SelectionManager _selectionManager = new SelectionManager(this);
    protected LayerManager _layerManager = new LayerManager(this);
    protected Guide _guide = new GuideGrid(8);
    private Fig _curFig = null;
    private Selection _curSel = null;
    private double _scale = 1.0;
    protected boolean _canSelectElements = true;
    private transient boolean _shouldPaint = true;
    private transient JComponent jComponent;
    private transient int _naturalComponentWidth;
    private transient int _naturalComponentHeight;
    private transient Component _peer_component = null;
    private RenderingHints _renderingHints = new RenderingHints(null);
    private transient JPopupMenu _popup = null;
    private static Log LOG = LogFactory.getLog(Editor.class);
    private FigTextEditor _activeTextEditor = null;
    protected static Rectangle _hitRect = new Rectangle(0, 0, 8, 8);

    public Editor(GraphModel graphModel, JComponent jComponent) {
        this(graphModel, jComponent, null);
    }

    public Editor(GraphModel graphModel) {
        this(graphModel, null, null);
    }

    public Editor() {
        this(null, null, null);
    }

    public Editor(Diagram diagram) {
        this(diagram.getGraphModel(), null, diagram.getLayer());
    }

    /*
     * WARNING - void declaration
     */
    public Editor(GraphModel object, JComponent object22, Layer layer) {
        void var3_5;
        this.jComponent = object22;
        this.defineLayers((GraphModel)((Object)object), (Layer)var3_5);
        for (ModeFactory modeFactory : Globals.getDefaultModeFactories()) {
            this.pushMode(modeFactory.createMode(this));
        }
        Globals.curEditor(this);
        this._renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this._renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    protected void defineLayers(GraphModel graphModel, Layer layer) {
        this._layerManager.addLayer(new LayerGrid());
        if (layer != null) {
            this._layerManager.addLayer(layer);
            return;
        }
        if (graphModel == null) {
            this._layerManager.addLayer(new LayerDiagram("Example"));
            return;
        }
        this._layerManager.addLayer(new LayerPerspective("untitled", graphModel));
    }

    public void preSave() {
        this._layerManager.preSave();
    }

    public void postSave() {
        this._layerManager.postSave();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this._popup = jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void postLoad() {
        this._layerManager.postLoad();
    }

    public boolean getGridHidden() {
        boolean bl2 = false;
        Layer layer = this._layerManager.findLayerNamed("Grid");
        if (layer != null) {
            bl2 = layer.getHidden();
        }
        return bl2;
    }

    public void setGridHidden(boolean bl2) {
        Layer layer = this._layerManager.findLayerNamed("Grid");
        if (layer != null) {
            layer.setHidden(bl2);
        }
    }

    public Object clone() {
        try {
            Editor editor = (Editor)this.getClass().newInstance();
            editor.getLayerManager().addLayer(this._layerManager.getActiveLayer());
            editor.document(this.document());
            return editor;
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error((Object)"IllegalAccessException in spawn");
        }
        catch (InstantiationException instantiationException) {
            LOG.error((Object)"InstantiationException in spawn");
        }
        return null;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public void pushMode(FigModifyingMode figModifyingMode) {
        this._modeManager.push(figModifyingMode);
        figModifyingMode.setEditor(this);
        Globals.showStatus(figModifyingMode.instructions());
    }

    public void finishMode() {
        this._modeManager.pop();
        this.pushMode((FigModifyingMode)Globals.mode());
        Globals.clearStatus();
    }

    public LayerManager getLayerManager() {
        return this._layerManager;
    }

    public double getScale() {
        return this._scale;
    }

    public void setScale(double d2) {
        this._scale = d2;
        this._layerManager.setScale(this._scale);
        this.jComponent.setPreferredSize(new Dimension((int)((double)this._naturalComponentWidth * this._scale), (int)((double)this._naturalComponentHeight * this._scale)));
        this.damageAll();
    }

    public boolean canSelectElements() {
        return this._canSelectElements;
    }

    public void setElementsSelectable(boolean bl2) {
        this._canSelectElements = bl2;
    }

    public GraphModel getGraphModel() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphModel();
        }
        return null;
    }

    public void setGraphModel(GraphModel graphModel) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphModel(graphModel);
        }
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphNodeRenderer();
        }
        return null;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphNodeRenderer(graphNodeRenderer);
        }
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphEdgeRenderer();
        }
        return null;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphEdgeRenderer(graphEdgeRenderer);
        }
    }

    public List<Fig> getFigs() {
        return this._layerManager.getContents();
    }

    public void add(Fig fig) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding fig " + fig));
        }
        this.getLayerManager().add(fig);
    }

    public void remove(Fig fig) {
        this.getLayerManager().remove(fig);
    }

    public final Fig hit(Point point) {
        _hitRect.setLocation(point.x - 4, point.y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int n2, int n3) {
        _hitRect.setLocation(n2 - 4, n3 - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int n2, int n3, int n4, int n5) {
        return this.hit(new Rectangle(n2, n3, n4, n5));
    }

    public Fig hit(Rectangle rectangle) {
        return this.getLayerManager().hit(rectangle);
    }

    protected void setUnderMouse(MouseEvent mouseEvent) {
        int n2;
        int n3 = mouseEvent.getX();
        Fig fig = this.hit(n3, n2 = mouseEvent.getY());
        if (fig != this._curFig) {
            if (this._curFig instanceof MouseListener) {
                ((MouseListener)((Object)this._curFig)).mouseExited(mouseEvent);
            }
            if (fig instanceof MouseListener) {
                ((MouseListener)((Object)fig)).mouseEntered(mouseEvent);
            }
        }
        this._curFig = fig;
        if (this._canSelectElements) {
            Selection selection = this._selectionManager.findSelectionAt(n3, n2);
            if (selection != this._curSel) {
                if (this._curSel != null) {
                    this._curSel.mouseExited(mouseEvent);
                }
                if (selection != null) {
                    selection.mouseEntered(mouseEvent);
                }
            }
            this._curSel = selection;
        }
    }

    public Object document() {
        return this._document;
    }

    public void document(Object object) {
        this._document = object;
    }

    public void snap(Point point) {
        if (this._guide != null) {
            this._guide.snap(point);
        }
    }

    public Guide getGuide() {
        return this._guide;
    }

    public void setGuide(Guide guide) {
        this._guide = guide;
    }

    public void damaged(Rectangle rectangle) {
        this.damaged(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void damaged(int n2, int n3, int n4, int n5) {
        this.getJComponent().repaint(0L, n2, n3, n4, n5);
    }

    public void damaged(Selection serializable) {
        serializable = serializable.getBounds();
        this.scaleRect((Rectangle)serializable);
        this.damaged((Rectangle)serializable);
    }

    public void damaged(Fig fig) {
        this.getJComponent().repaint();
    }

    public void scaleRect(Rectangle rectangle) {
        rectangle.x = (int)Math.floor((double)rectangle.x * this._scale);
        rectangle.y = (int)Math.floor((double)rectangle.y * this._scale);
        rectangle.width = (int)Math.floor((double)rectangle.width * this._scale) + 1;
        rectangle.height = (int)Math.floor((double)rectangle.height * this._scale) + 1;
    }

    public void damageAll() {
        if (this.jComponent != null) {
            Rectangle rectangle = this.jComponent.getVisibleRect();
            this.jComponent.revalidate();
            this.jComponent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.shouldPaint()) {
            return;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHints(this._renderingHints);
            graphics2D.scale(this._scale, this._scale);
        }
        this.getLayerManager().paint(graphics);
        if (this._canSelectElements) {
            this._selectionManager.paint(graphics);
            this._modeManager.paint(graphics);
        }
    }

    public void print(Graphics graphics) {
        this.getLayerManager().paint(graphics);
    }

    public void scrollToShow(int n2, int n3) {
    }

    public void scrollToShow(Fig cloneable) {
        cloneable = new Rectangle((int)((double)cloneable.getX() * this._scale), (int)((double)cloneable.getY() * this._scale), (int)((double)cloneable.getWidth() * this._scale), (int)((double)cloneable.getHeight() * this._scale));
        ((Rectangle)cloneable).grow((int)(50.0 * this._scale), (int)(50.0 * this._scale));
        JComponent jComponent = this.getJComponent();
        if (jComponent != null) {
            jComponent.scrollRectToVisible((Rectangle)cloneable);
        }
    }

    public SelectionManager getSelectionManager() {
        return this._selectionManager;
    }

    public Fig getCurrentFig() {
        return this._curFig;
    }

    public JComponent getJComponent() {
        return this.jComponent;
    }

    public void setJComponent(JComponent jComponent) {
        this.jComponent = jComponent;
        this._peer_component = null;
    }

    public void setCursor(Cursor cursor) {
        if (this.getJComponent() != null) {
            this.getJComponent().setCursor(cursor);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public Frame findFrame() {
        Container container;
        for (container = this.jComponent; container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    public Image createImage(int n2, int n3) {
        if (this.jComponent == null) {
            return null;
        }
        if (this._peer_component == null) {
            this._peer_component = this.jComponent;
            while (this._peer_component instanceof JComponent) {
                this._peer_component = this._peer_component.getParent();
            }
        }
        return this._peer_component.createImage(n2, n3);
    }

    public Color getBackground() {
        if (this.jComponent == null) {
            return Color.lightGray;
        }
        return this.jComponent.getBackground();
    }

    public void setActiveTextEditor(FigTextEditor figTextEditor) {
        FigTextEditor figTextEditor2 = this._activeTextEditor;
        this._activeTextEditor = figTextEditor;
        if (figTextEditor2 != null) {
            figTextEditor2.endEditing();
        }
    }

    public TextEditor getActiveTextEditor() {
        if (this._activeTextEditor != null) {
            return FigText.getActiveTextEditor();
        }
        return null;
    }

    public void drawingSizeChanged(Dimension dimension) {
        this._naturalComponentWidth = dimension.width;
        this._naturalComponentHeight = dimension.height;
        if (this.jComponent != null) {
            this.jComponent.setPreferredSize(new Dimension((int)((double)this._naturalComponentWidth * this._scale), (int)((double)this._naturalComponentHeight * this._scale)));
            this.jComponent.revalidate();
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._selectionManager.addGraphSelectionListener(graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._selectionManager.removeGraphSelectionListener(graphSelectionListener);
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this._modeManager.addModeChangeListener(modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this._modeManager.removeModeChangeListener(modeChangeListener);
    }

    public MouseEvent translateMouseEvent(MouseEvent mouseEvent) {
        double d2 = mouseEvent.getX();
        double d3 = mouseEvent.getY();
        mouseEvent.translatePoint((int)Math.round(d2 / this._scale - (double)mouseEvent.getX()), (int)Math.round(d3 / this._scale - (double)mouseEvent.getY()));
        return mouseEvent;
    }

    public MouseEvent retranslateMouseEvent(MouseEvent mouseEvent) {
        double d2 = mouseEvent.getX();
        double d3 = mouseEvent.getY();
        int n2 = (int)(d2 * this._scale - d2);
        int n3 = (int)(d3 * this._scale - d3);
        mouseEvent.translatePoint(n2, n3);
        return mouseEvent;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.mouseClicked(mouseEvent);
        }
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseClicked(mouseEvent);
        }
        if (this._canSelectElements) {
            this._modeManager.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but rejected as already consumed");
            }
            return;
        }
        this.translateMouseEvent(mouseEvent);
        TextEditor textEditor = FigText.getActiveTextEditor();
        if (textEditor != null) {
            textEditor.endEditing();
        }
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mousePressed(mouseEvent);
        }
        if (this._canSelectElements) {
            this._selectionManager.mousePressed(mouseEvent);
            this._modeManager.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseReleased(mouseEvent);
        }
        if (this._canSelectElements) {
            this._selectionManager.mouseReleased(mouseEvent);
            this._modeManager.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        Globals.curEditor(this);
        this.pushMode((FigModifyingMode)Globals.mode());
        this.setUnderMouse(mouseEvent);
        if (this._canSelectElements) {
            this._modeManager.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        this.setUnderMouse(mouseEvent);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        Globals.curEditor(this);
        this.setUnderMouse(mouseEvent);
        if (this._canSelectElements) {
            this._selectionManager.mouseDragged(mouseEvent);
            this._modeManager.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.translateMouseEvent(mouseEvent);
        Globals.curEditor(this);
        this.setUnderMouse(mouseEvent);
        if (this._curFig != null && Globals.getShowFigTips()) {
            String string = this._curFig.getTipString(mouseEvent);
            if (string != null && string.length() > 0 && !string.endsWith(" ")) {
                string = string + " ";
            }
            if (string != null && this.jComponent instanceof JComponent) {
                this.jComponent.setToolTipText(string);
            }
        } else {
            this.jComponent.setToolTipText(null);
        }
        if (this._canSelectElements) {
            this._selectionManager.mouseMoved(mouseEvent);
            this._modeManager.mouseMoved(mouseEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyTyped(keyEvent);
            this._modeManager.keyTyped(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyPressed(keyEvent);
            this._modeManager.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Globals.curEditor(this);
        if (this._canSelectElements) {
            this._selectionManager.keyReleased(keyEvent);
            this._modeManager.keyReleased(keyEvent);
        }
    }

    public void executeCmd(Cmd cmd, InputEvent inputEvent) {
        if (cmd == null) {
            return;
        }
        try {
            cmd.doIt();
            return;
        }
        catch (Throwable throwable) {
            LOG.debug((Object)("While executing " + cmd + " on event " + inputEvent + " the following error occured:"), throwable);
            return;
        }
    }

    public void removed(Fig fig) {
        this._selectionManager.deselect(fig);
        this.remove(fig);
    }

    public void setShouldPaint(boolean bl2) {
        this._shouldPaint = bl2;
    }

    public boolean shouldPaint() {
        return this._shouldPaint;
    }

    public Selection getCurrentSelection() {
        return this._curSel;
    }
}

