/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPainter;
import org.tigris.gef.util.EnumerationEmpty;
import org.tigris.gef.util.EnumerationPredicate;
import org.tigris.gef.util.PredFigInRect;
import org.tigris.gef.util.PredFigNodeInRect;

public abstract class Layer
implements Serializable {
    private String name = "aLayer";
    private String type = "aLayer";
    private boolean hidden = false;
    private boolean grayed = false;
    private boolean locked = false;
    private boolean alwaysOnTop = false;
    private double scale = 1.0;
    @Deprecated
    protected boolean _onMenu = false;
    private transient List<Editor> editors = new ArrayList<Editor>();

    public Layer() {
    }

    public Layer(String string) {
        this.name = string;
    }

    public Layer(String string, String string2) {
        this.name = string;
        this.type = string2;
    }

    public Object clone() {
        Layer layer;
        try {
            layer = (Layer)this.getClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        layer.name = this.name;
        layer.type = this.type;
        layer._onMenu = this._onMenu;
        layer.grayed = this.grayed;
        layer.setHidden(this.hidden);
        layer.setGrayed(this.grayed);
        layer.setScale(this.scale);
        layer.setLocked(this.locked);
        layer.setAlwaysOnTop(this.alwaysOnTop);
        return layer;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHidden(boolean bl2) {
        this.hidden = bl2;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setGrayed(boolean bl2) {
        this.grayed = bl2;
    }

    public boolean getGrayed() {
        return this.grayed;
    }

    public void setLocked(boolean bl2) {
        this.locked = bl2;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setAlwaysOnTop(boolean bl2) {
        this.alwaysOnTop = bl2;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setScale(double d2) {
        this.scale = d2;
    }

    public double getScale() {
        return this.scale;
    }

    public void setOnMenu(boolean bl2) {
        this._onMenu = bl2;
    }

    public boolean getOnMenu() {
        return this._onMenu;
    }

    public abstract List<Fig> getContents();

    public List<? extends Fig> getContents(Class<? extends Fig> clazz) {
        return Collections.emptyList();
    }

    public List<DiagramElement> getDiagramElements() {
        Object object = this.getContents();
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Fig fig = (Fig)object.next();
            arrayList.add(fig);
        }
        return arrayList;
    }

    public List<GraphEdge> getGraphEdges() {
        Object object = this.getContents();
        ArrayList<GraphEdge> arrayList = new ArrayList<GraphEdge>((object.size() << 3) / 10);
        object = object.iterator();
        while (object.hasNext()) {
            Fig fig = (Fig)object.next();
            if (!(fig instanceof GraphEdge)) continue;
            arrayList.add((GraphEdge)((Object)fig));
        }
        return arrayList;
    }

    public List<GraphNode> getGraphNodes() {
        Object object = this.getContents();
        ArrayList<GraphNode> arrayList = new ArrayList<GraphNode>((object.size() << 3) / 10);
        object = object.iterator();
        while (object.hasNext()) {
            Fig fig = (Fig)object.next();
            if (!(fig instanceof GraphNode)) continue;
            arrayList.add((GraphNode)((Object)fig));
        }
        return arrayList;
    }

    public List getContentsNoEdges() {
        List<Fig> list = this.getContents();
        int n2 = list.size();
        Vector<Fig> vector = new Vector<Fig>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = list.get(i2);
            if (fig instanceof FigEdge) continue;
            vector.add(fig);
        }
        return vector;
    }

    public List getContentsEdgesOnly() {
        List<Fig> list = this.getContents();
        int n2 = list.size();
        ArrayList<Fig> arrayList = new ArrayList<Fig>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = list.get(i2);
            if (!(fig instanceof FigEdge)) continue;
            arrayList.add(fig);
        }
        return arrayList;
    }

    public List<Editor> getEditors() {
        return Collections.unmodifiableList(new ArrayList<Editor>(this.editors));
    }

    public void add(Fig fig) {
    }

    public void remove(Fig fig) {
    }

    public void add(DiagramElement diagramElement) {
        this.add((Fig)diagramElement);
    }

    public void remove(DiagramElement diagramElement) {
        this.remove((Fig)diagramElement);
    }

    public void removeAll() {
    }

    public Enumeration elements() {
        return EnumerationEmpty.theInstance();
    }

    public Fig hit(Rectangle rectangle) {
        return null;
    }

    public Enumeration elementsIn(Rectangle rectangle) {
        return new EnumerationPredicate(this.elements(), new PredFigInRect(rectangle));
    }

    public Enumeration nodesIn(Rectangle rectangle) {
        return new EnumerationPredicate(this.elements(), new PredFigNodeInRect(rectangle));
    }

    public abstract Fig presentationFor(Object var1);

    public String getPerspectiveType() {
        return this.type;
    }

    public void setPerspectiveType(String string) {
        this.type = string;
    }

    public void sendToBack(Fig fig) {
    }

    public void bringForward(Fig fig) {
    }

    public void sendBackward(Fig fig) {
    }

    public void bringToFront(Fig fig) {
    }

    public void bringInFrontOf(Fig fig, Fig fig2) {
    }

    public void reorder(Fig fig, int n2) {
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, FigPainter figPainter) {
        if (this.hidden) {
            return;
        }
        if (!this.grayed) {
            this.paintContents(graphics, figPainter);
            return;
        }
        this.paintGrayContents(graphics);
    }

    public void paintContents(Graphics graphics, FigPainter figPainter) {
        this.paintContents(graphics);
    }

    public abstract void paintContents(Graphics var1);

    public void paintGrayContents(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        this.paintContents(graphics);
    }

    public Rectangle calcDrawingArea() {
        Enumeration enumeration = this.elements();
        if (!enumeration.hasMoreElements()) {
            return new Rectangle();
        }
        Fig fig = (Fig)enumeration.nextElement();
        Rectangle rectangle = new Rectangle(fig.getBounds());
        while (enumeration.hasMoreElements()) {
            fig = (Fig)enumeration.nextElement();
            rectangle.add(fig.getBounds());
        }
        rectangle.grow(4, 4);
        return rectangle;
    }

    public void damageAll() {
        if (this.editors == null) {
            return;
        }
        int n2 = this.editors.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.editors.get(i2).damageAll();
        }
    }

    public void deleted(Fig fig) {
        if (this.editors == null) {
            return;
        }
        int n2 = this.editors.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.editors.get(i2).removed(fig);
        }
    }

    public void refreshEditors() {
        if (this.editors == null) {
            return;
        }
        int n2 = this.editors.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.editors.get(i2).damageAll();
        }
    }

    public void addEditor(Editor editor) {
        if (this.editors == null) {
            this.editors = new ArrayList<Editor>();
        }
        this.editors.add(editor);
    }

    public void removeEditor(Editor editor) {
        if (this.editors == null) {
            return;
        }
        this.editors.remove(editor);
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public void postLoad() {
    }

    public void adjust() {
    }

    public void adjust(HashMap hashMap) {
    }
}

