/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPainter;

public class LayerManager
implements Serializable {
    private static final long serialVersionUID = -4133017459593099807L;
    private List<Layer> _layers = new ArrayList<Layer>();
    private Layer _activeLayer;
    private boolean _paintActiveOnly = false;
    private boolean _paintLayers = true;
    @Deprecated
    public Editor _editor = null;

    public LayerManager(Editor editor) {
        this._editor = editor;
    }

    public void addLayer(Layer layer, boolean bl2) {
        if (this.findLayerNamed(layer.getName()) == null) {
            this._editor.getModeManager().leaveAll();
            this._layers.add(layer);
            layer.addEditor(this._editor);
            if (bl2) {
                this.setActiveLayer(layer);
            }
        }
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, true);
    }

    public void removeAllLayers() {
        this._layers.clear();
        this._activeLayer = null;
    }

    public void replaceLayer(Layer layer, Layer layer2) {
        this._editor.getModeManager().leaveAll();
        layer.removeEditor(this._editor);
        int n2 = this._layers.indexOf(layer);
        this._layers.set(n2, layer2);
        layer2.addEditor(this._editor);
        if (this._activeLayer == layer) {
            this.setActiveLayer(layer2);
        }
    }

    public void replaceActiveLayer(Layer layer) {
        if (this._activeLayer == null) {
            this.addLayer(layer, true);
            return;
        }
        this.replaceLayer(this._activeLayer, layer);
    }

    public void removeLayer(Layer layer) {
        this._layers.remove(layer);
        layer.removeEditor(this._editor);
        if (this._activeLayer == layer) {
            if (this._layers.size() > 0) {
                this._activeLayer = this._layers.get(0);
                return;
            }
            this._activeLayer = null;
        }
    }

    public Layer findLayerNamed(String string) {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Layer layer = this._layers.get(i2);
            if (!string.equals(layer.getName())) continue;
            return layer;
        }
        return null;
    }

    public void setActiveLayer(Layer layer) {
        if (this._activeLayer != null && this._activeLayer.isAlwaysOnTop()) {
            return;
        }
        if (this._layers.contains(layer)) {
            this._activeLayer = layer;
            return;
        }
        System.out.println("That layer is not one of my layers");
    }

    public Layer getActiveLayer() {
        return this._activeLayer;
    }

    public List<Fig> getContents() {
        if (this._activeLayer == null) {
            return Collections.emptyList();
        }
        return this._activeLayer.getContents();
    }

    @Deprecated
    public List getContents(List list) {
        if (this._activeLayer == null) {
            return null;
        }
        return this._activeLayer.getContents();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, FigPainter figPainter) {
        if (!this._paintLayers) {
            return;
        }
        if (this._paintActiveOnly) {
            this._activeLayer.paint(graphics, figPainter);
            return;
        }
        Layer layer = this._activeLayer;
        boolean bl2 = layer.isAlwaysOnTop();
        layer.setAlwaysOnTop(false);
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Layer layer2 = this._layers.get(i2);
            this.setActiveLayer(layer2);
            layer2.paint(graphics, figPainter);
        }
        this.setActiveLayer(layer);
        layer.setAlwaysOnTop(bl2);
    }

    public void add(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.add(fig);
        }
    }

    public void remove(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.remove(fig);
        }
    }

    public void removeAll() {
        if (this._activeLayer != null) {
            this._activeLayer.removeAll();
        }
    }

    @Deprecated
    public Enumeration elements() {
        if (this._activeLayer == null) {
            return null;
        }
        return this._activeLayer.elements();
    }

    public Fig hit(Rectangle rectangle) {
        if (this._activeLayer == null) {
            return null;
        }
        return this._activeLayer.hit(rectangle);
    }

    public Fig presentationFor(Object object) {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this._layers.get(i2).presentationFor(object);
            if (fig == null) continue;
            return fig;
        }
        return null;
    }

    public void sendToBack(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.sendToBack(fig);
        }
    }

    public void bringForward(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.bringForward(fig);
        }
    }

    public void sendBackward(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.sendBackward(fig);
        }
    }

    public void bringToFront(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.bringToFront(fig);
        }
    }

    public void reorder(Fig fig, int n2) {
        if (this._activeLayer != null) {
            this._activeLayer.reorder(fig, n2);
        }
    }

    public void setEditor(Editor editor) {
        this._editor = editor;
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._layers.get(i2).addEditor(editor);
        }
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void preSave() {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._layers.get(i2).preSave();
        }
    }

    public void postSave() {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._layers.get(i2).postSave();
        }
    }

    public void postLoad() {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._layers.get(i2).postLoad();
        }
    }

    public void setPaintActiveOnly(boolean bl2) {
        this._paintActiveOnly = bl2;
    }

    public boolean getPaintActiveOnly() {
        return this._paintActiveOnly;
    }

    public void setPaintLayers(boolean bl2) {
        this._paintLayers = bl2;
    }

    public boolean getPaintLayers() {
        return this._paintLayers;
    }

    public void setScale(double d2) {
        int n2 = this._layers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._layers.get(i2).setScale(d2);
        }
    }
}

