/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class LayerPerspectiveMutable
extends LayerPerspective {
    private static final long serialVersionUID = 4692683431762315041L;
    private MutableGraphModel mutableGraphModel;

    public LayerPerspectiveMutable(String string, MutableGraphModel mutableGraphModel) {
        super(string, mutableGraphModel);
        this.mutableGraphModel = mutableGraphModel;
    }

    @Override
    public GraphModel getGraphModel() {
        return this.getMutableGraphModel();
    }

    @Override
    public void setGraphModel(GraphModel graphModel) {
        this.setMutableGraphModel((MutableGraphModel)graphModel);
    }

    public MutableGraphModel getMutableGraphModel() {
        return this.mutableGraphModel;
    }

    public void setMutableGraphModel(MutableGraphModel mutableGraphModel) {
        super.setGraphModel(mutableGraphModel);
        this.mutableGraphModel = mutableGraphModel;
    }

    @Override
    public void add(Fig fig) {
        Object object = fig.getOwner();
        if (fig instanceof FigNode && this.contains(fig) && this.mutableGraphModel.containsNode(object) && fig.getLayer() == this) {
            return;
        }
        super.add(fig);
    }

    @Override
    public void remove(Fig fig) {
        super.remove(fig);
        Object object = fig.getOwner();
        if (object != null) {
            if (fig instanceof FigEdge && this.mutableGraphModel.containsEdge(object)) {
                this.mutableGraphModel.removeEdge(object);
                return;
            }
            if (fig instanceof FigNode && this.mutableGraphModel.containsNode(object)) {
                this.mutableGraphModel.removeNode(object);
            }
        }
    }
}

