/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.MouseEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.base.ModeCreateEdge$CreateEdgeMemento;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

public class ModeCreateEdge
extends ModeCreate {
    private static final long serialVersionUID = -3551773848229016093L;
    private Object startPort;
    private Fig _startPortFig;
    private FigNode _sourceFigNode;
    private Object _newEdge;
    private static Log LOG = LogFactory.getLog(ModeCreateEdge.class);

    public ModeCreateEdge() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreateEdge");
        }
    }

    public ModeCreateEdge(Editor editor) {
        super(editor);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreateEdge for Editor");
        }
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeCreateEdgeInstructions");
    }

    @Override
    public Fig createNewItem(MouseEvent mouseEvent, int n2, int n3) {
        return new FigLine(n2, n3, 0, 0, Globals.getPrefs().getRubberbandColor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as already consumed");
            }
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Editor editor = Globals.curEditor();
        Fig fig = editor.hit(n2, n3);
        if (fig == null) {
            fig = editor.hit(n2 - 16, n3 - 16, 32, 32);
        }
        if (fig == null) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but nothing under - consumed");
            }
            return;
        }
        if (!(fig instanceof FigNode)) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but not a FigNode under - consumed");
            }
            return;
        }
        this._sourceFigNode = (FigNode)fig;
        this.startPort = this._sourceFigNode.deepHitPort(n2, n3);
        if (this.startPort == null) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but no port found - consumed");
            }
            return;
        }
        this._startPortFig = this._sourceFigNode.getPortFig(this.startPort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed start port set");
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        GraphModel graphModel;
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        if (this._sourceFigNode == null) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but no source found so consuming and leaving");
            }
            return;
        }
        UndoManager.getInstance().startChain();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Editor editor = Globals.curEditor();
        Fig fig = editor.hit(n2, n3);
        if (fig == null) {
            fig = editor.hit(n2 - 16, n3 - 16, 32, 32);
        }
        if (!((graphModel = editor.getGraphModel()) instanceof MutableGraphModel)) {
            fig = null;
        }
        if (fig instanceof FigNode) {
            graphModel = (MutableGraphModel)graphModel;
            Object object = ((FigNode)(fig = (FigNode)fig)).deepHitPort(n2, n3);
            if (object != null && graphModel.canConnect(this.startPort, object)) {
                Fig fig2 = ((FigNode)fig).getPortFig(object);
                Class clazz = (Class)this.getArg("edgeClass");
                this._newEdge = clazz != null ? graphModel.connect(this.startPort, object, clazz) : graphModel.connect(this.startPort, object);
                if (this._newEdge != null) {
                    editor.damageAll();
                    this._sourceFigNode.damage();
                    fig.damage();
                    this._newItem = null;
                    object = (FigEdge)editor.getLayerManager().getActiveLayer().presentationFor(this._newEdge);
                    ((FigEdge)object).setSourcePortFig(this._startPortFig);
                    ((FigEdge)object).setSourceFigNode(this._sourceFigNode);
                    ((FigEdge)object).setDestPortFig(fig2);
                    ((FigEdge)object).setDestFigNode((FigNode)fig);
                    this.endAttached((FigEdge)object);
                    if (object != null) {
                        editor.getSelectionManager().select((Fig)object);
                    }
                    this.done();
                    mouseEvent.consume();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"MouseReleased Edge created and event consumed");
                    }
                    return;
                }
            }
        }
        this._sourceFigNode.damage();
        editor.damageAll();
        this._newItem = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MouseReleased not on FigNode. Event consumed anyway.");
        }
        this.done();
        mouseEvent.consume();
    }

    protected Object getStartPort() {
        return this.startPort;
    }

    protected void endAttached(FigEdge figEdge) {
        UndoManager.getInstance().removeMementoLock(this);
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new ModeCreateEdge$CreateEdgeMemento(this, this.editor, this._newEdge, figEdge));
        }
        UndoManager.getInstance().addMementoLock(this);
    }
}

