/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.base.SelectionButtons;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.util.Localizer;

public class ModeCreateEdgeAndNode
extends ModeCreate {
    private static final Log LOG = LogFactory.getLog(ModeCreateEdgeAndNode.class);
    private Object startPort;
    private Fig startPortFig;
    private FigNode sourceFigNode;
    private Object newEdge;
    private boolean destToSource = false;
    private Handle handle = new Handle(-1);
    private FigNode fn;
    private FigEdge fe;
    private boolean postProcessEdge = false;
    static final long serialVersionUID = -427957543380196265L;

    public ModeCreateEdgeAndNode() {
    }

    public ModeCreateEdgeAndNode(Editor editor, Object object, Object object2, boolean bl2) {
        super(editor);
        this.setArg("edgeClass", object);
        this.setArg("nodeClass", object2);
        this.postProcessEdge = bl2;
        LOG.debug((Object)("postprocessing: " + this.postProcessEdge));
    }

    public ModeCreateEdgeAndNode(Editor editor, Object object, boolean bl2, SelectionButtons selectionButtons) {
        super(editor);
        this.setArg("edgeClass", object);
        this.setArg("nodeCreator", selectionButtons);
        this.postProcessEdge = bl2;
        LOG.debug((Object)("postprocessing: " + this.postProcessEdge));
    }

    public void setup(FigNode figNode, Object object, int n2, int n3, boolean bl2) {
        this.start();
        this.sourceFigNode = figNode;
        this.startPortFig = figNode.getPortFig(object);
        this.startPort = object;
        this._newItem = this.createNewItem(null, n2, n3);
        this.destToSource = bl2;
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeCreateEdgeAndNodeInstructions");
    }

    @Override
    public Fig createNewItem(MouseEvent serializable, int n2, int n3) {
        serializable = new FigPoly(n2, n3);
        ((Fig)serializable).setLineColor(Globals.getPrefs().getRubberbandColor());
        ((Fig)serializable).setFillColor(null);
        ((FigPoly)serializable).addPoint(n2, n3);
        return serializable;
    }

    @Override
    public void done() {
        super.done();
        if (this._newItem != null) {
            this.editor.damaged(this._newItem);
        }
        this._newItem = null;
        this.sourceFigNode = null;
        this.startPort = null;
        this.startPortFig = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this.sourceFigNode == null) {
            this.done();
            return;
        }
        boolean bl2 = false;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Editor editor = Globals.curEditor();
        Object object5 = editor.hit(n2, n3);
        if (object5 == null) {
            object5 = editor.hit(n2 - 16, n3 - 16, 32, 32);
        }
        if (!((object4 = editor.getGraphModel()) instanceof MutableGraphModel)) {
            object5 = null;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)object4;
        if (object5 == null) {
            LOG.debug((Object)"make new node");
            object3 = (SelectionButtons)this.getArg("nodeCreator");
            if (object3 != null) {
                object2 = ((SelectionButtons)object3).getNewNode(0);
            } else {
                object = (Class)this.getArg("nodeClass");
                try {
                    object2 = ((Class)object).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.error((Object)illegalAccessException);
                    return;
                }
                catch (InstantiationException instantiationException) {
                    LOG.error((Object)instantiationException);
                    return;
                }
            }
            if (object2 instanceof GraphNodeHooks) {
                ((GraphNodeHooks)object2).initialize(this._args);
            }
            if (mutableGraphModel.canAddNode(object2)) {
                object = this.editor.getGraphNodeRenderer();
                object5 = this.editor.getLayerManager().getActiveLayer();
                this.fn = object.getFigNodeFor((GraphModel)object4, (Layer)object5, object2, null);
                this.editor.add(this.fn);
                mutableGraphModel.addNode(object2);
                object4 = null;
                object = this.fn.getBounds();
                for (Fig fig : ((Layer)object5).getContents()) {
                    if (!(fig instanceof FigNode) || fig.equals(this.fn) || (object5 = fig.getTrapRect()) == null || !((Rectangle)object5).contains(((Rectangle)object).x, ((Rectangle)object).y) || !((Rectangle)object5).contains(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height)) continue;
                    object4 = fig;
                }
                this.fn.setEnclosingFig((Fig)object4);
                if (object2 instanceof GraphNodeHooks) {
                    ((GraphNodeHooks)object2).postPlacement(this.editor);
                }
                this.editor.getSelectionManager().select(this.fn);
                bl2 = true;
                object5 = this.fn;
                ((Fig)object5).setLocation(n2 - ((Fig)object5).getWidth() / 2, n3 - ((Fig)object5).getHeight() / 2);
            }
        }
        if (object5 instanceof FigNode) {
            object2 = (FigNode)object5;
            object3 = ((FigNode)object2).deepHitPort(n2, n3);
            if (object3 == null && (object = ((FigNode)object2).getPortFigs().iterator()).hasNext()) {
                object3 = ((Fig)object.next()).getOwner();
            }
            object = (FigPoly)this._newItem;
            this.editor.damaged((Fig)object);
            ((FigPoly)object).setComplete(true);
            if (object3 != null && object3 != this.startPort) {
                object5 = ((FigNode)object2).getPortFig(object3);
                object4 = this.getArg("edgeClass");
                if (this.destToSource) {
                    object = this.startPort;
                    this.startPort = object3;
                    object3 = object;
                    Object object6 = object2;
                    object2 = this.sourceFigNode;
                    this.sourceFigNode = object6;
                    object6 = this.startPortFig;
                    this.startPortFig = object5;
                    object5 = object6;
                }
                this.newEdge = object4 != null ? mutableGraphModel.connect(this.startPort, object3, (Class)object4) : mutableGraphModel.connect(this.startPort, object3);
                if (this.newEdge != null) {
                    if (this.postProcessEdge) {
                        LOG.debug((Object)"postprocess edge.");
                        this.postProcessEdge();
                    }
                    editor.damaged(this._newItem);
                    this.sourceFigNode.damage();
                    ((Fig)object2).damage();
                    object = editor.getLayerManager();
                    this.fe = (FigEdge)((LayerManager)object).getActiveLayer().presentationFor(this.newEdge);
                    this.fe.setFig(this._newItem);
                    this.fe.setSourcePortFig(this.startPortFig);
                    this.fe.setSourceFigNode(this.sourceFigNode);
                    this.fe.setDestPortFig((Fig)object5);
                    this.fe.setDestFigNode((FigNode)object2);
                    this.fe.setSourcePortFig(this.startPortFig);
                    this.fe.setSourceFigNode(this.sourceFigNode);
                    this.fe.setDestPortFig((Fig)object5);
                    this.fe.setDestFigNode((FigNode)object2);
                    if (this.fe != null && !bl2) {
                        editor.getSelectionManager().select(this.fe);
                    }
                    this.done();
                    this._newItem = null;
                    if (this.fe instanceof MouseListener) {
                        ((MouseListener)((Object)this.fe)).mouseReleased(mouseEvent);
                    }
                    if (this.sourceFigNode != null) {
                        this.sourceFigNode.updateEdges();
                    }
                    if (object2 != null) {
                        ((FigNode)object2).updateEdges();
                    }
                    return;
                }
                LOG.warn((Object)"connection return null");
            } else {
                LOG.warn((Object)"in dest node but no port");
            }
        }
        this.sourceFigNode.damage();
        editor.damaged(this._newItem);
        this._newItem = null;
        this.done();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._newItem == null) {
            mouseEvent.consume();
            return;
        }
        FigPoly figPoly = (FigPoly)this._newItem;
        this.editor.damaged(this._newItem);
        Point point = new Point(n2, n3);
        this.editor.snap(point);
        this.handle.index = figPoly.getNumPoints() - 1;
        figPoly.moveVertex(this.handle, point.x, point.y, true);
        this.editor.damaged(this._newItem);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            this.done();
            keyEvent.consume();
        }
    }

    protected void postProcessEdge() {
        this.postProcessEdge(this.newEdge);
    }

    protected void postProcessEdge(Object object) {
    }
}

