/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.util.Localizer;

public class ModeCreateFigPoly
extends ModeCreate {
    private static final long serialVersionUID = 2839607058696197299L;
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeCreateFigPolyInstructions");
    }

    @Override
    public Fig createNewItem(MouseEvent serializable, int n2, int n3) {
        serializable = new FigPoly(n2, n3);
        ((FigPoly)serializable).addPoint(n2, n3);
        this._startX = this._lastX = n2;
        this._startY = this._lastY = n3;
        this._npoints = 2;
        return serializable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._npoints == 0) {
            super.mousePressed(mouseEvent);
        }
        if (!this.nearLast(n2, n3)) {
            this.editor.damageAll();
            Point point = new Point(n2, n3);
            this.editor.snap(point);
            ((FigPoly)this._newItem).addPoint(point.x, point.y);
            ++this._npoints;
            this.editor.damageAll();
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._npoints > 2 && this.nearLast(n2, n3)) {
            FigPoly figPoly = (FigPoly)this._newItem;
            this.editor.damageAll();
            this._handle.index = figPoly.getNumPoints() - 1;
            figPoly.moveVertex(this._handle, this._startX, this._startY, true);
            this._npoints = 0;
            this.editor.damageAll();
            this.editor.add(figPoly);
            this.editor.getSelectionManager().select(figPoly);
            this._newItem = null;
            this.done();
            mouseEvent.consume();
            return;
        }
        this._lastX = n2;
        this._lastY = n3;
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._npoints == 0) {
            mouseEvent.consume();
            return;
        }
        FigPoly figPoly = (FigPoly)this._newItem;
        this.editor.damageAll();
        Point point = new Point(n2, n3);
        this.editor.snap(point);
        this._handle.index = figPoly.getNumPoints() - 1;
        figPoly.moveVertex(this._handle, point.x, point.y, true);
        this.editor.damageAll();
        mouseEvent.consume();
    }

    protected boolean nearLast(int n2, int n3) {
        return n2 > this._lastX - 8 && n2 < this._lastX + 8 && n3 > this._lastY - 8 && n3 < this._lastY + 8;
    }
}

