/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class SaveAction
extends AbstractAction
implements FilenameFilter {
    private static final long serialVersionUID = -7423650789224426733L;

    public SaveAction() {
        super("Save");
    }

    public SaveAction(String string) {
        this(string, false);
    }

    public SaveAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public SaveAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SaveAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        try {
            serializable = Globals.curEditor();
            Object object = new FileDialog(((Editor)serializable).findFrame(), "Save Diagram", 1);
            ((FileDialog)object).setFilenameFilter(this);
            ((FileDialog)object).setDirectory(Globals.getLastDirectory());
            ((Dialog)object).setVisible(true);
            String string = ((FileDialog)object).getFile();
            object = ((FileDialog)object).getDirectory();
            Globals.setLastDirectory((String)object);
            if (string != null) {
                Globals.showStatus("Writing " + (String)object + string + "...");
                FileOutputStream fileOutputStream = new FileOutputStream((String)object + string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                ((Editor)serializable).preSave();
                objectOutputStream.writeObject(serializable);
                ((Editor)serializable).postSave();
                Globals.showStatus("Wrote " + (String)object + string);
                fileOutputStream.close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
            return;
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    public boolean accept(File file, String string) {
        return true;
    }
}

