/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.SaveGraphicsAction;
import org.tigris.gef.base.TransFilter;
import org.tigris.gef.util.Localizer;

public class SaveGIFAction
extends SaveGraphicsAction {
    private static final long serialVersionUID = 2390013810162720448L;
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    public SaveGIFAction(String string) {
        this(string, false);
    }

    public SaveGIFAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public SaveGIFAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SaveGIFAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    protected void saveGraphics(OutputStream outputStream, Editor object, Rectangle rectangle) {
        Image image = ((Editor)object).createImage(rectangle.width * this.scale, rectangle.height * this.scale);
        Graphics graphics = image.getGraphics();
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).scale(this.scale, this.scale);
        }
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(0, 0, rectangle.width * this.scale, rectangle.height * this.scale);
        graphics.translate(-rectangle.x, -rectangle.y);
        ((Editor)object).print(graphics);
        try {
            object = new FilteredImageSource(image.getSource(), new TransFilter(0xEFEFEF));
            new GifEncoder((ImageProducer)object, outputStream).encode();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        graphics.dispose();
    }
}

