/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.SaveGraphicsAction;
import org.tigris.gef.util.Localizer;

public class SavePNGAction
extends SaveGraphicsAction {
    private static final long serialVersionUID = 162553935201931332L;
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    public SavePNGAction(String string) {
        this(string, false);
    }

    public SavePNGAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public SavePNGAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SavePNGAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    protected void saveGraphics(OutputStream outputStream, Editor editor, Rectangle rectangle) {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width * this.scale, rectangle.height * this.scale, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.scale(this.scale, this.scale);
        graphics2D.setColor(new Color(0xEFEFEF, true));
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.fillRect(0, 0, rectangle.width * this.scale, rectangle.height * this.scale);
        graphics2D.setComposite(composite);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        editor.print(graphics2D);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        graphics2D.dispose();
    }
}

