/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class SelectNearAction
extends UndoableAction {
    private static final long serialVersionUID = -7302592306721995290L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int direction;
    private int magnitude;

    public SelectNearAction(int n2) {
        this(n2, 1);
    }

    public SelectNearAction(int n2, int n3) {
        super("SelectNear" + SelectNearAction.wordFor(n2));
        this.direction = n2;
        this.magnitude = n3;
    }

    private static String wordFor(int n2) {
        switch (n2) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    public SelectNearAction(String string, int n2) {
        this(string, n2, 1, false);
    }

    public SelectNearAction(String string, int n2, int n3) {
        this(string, n2, n3, false);
    }

    public SelectNearAction(String string, Icon icon, int n2) {
        this(string, icon, n2, 1, false);
    }

    public SelectNearAction(String string, Icon icon, int n2, int n3) {
        this(string, icon, n2, n3, false);
    }

    public SelectNearAction(String string, int n2, boolean bl2) {
        this(string, n2, 1, false);
    }

    public SelectNearAction(String string, int n2, int n3, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
        this.direction = n2;
        this.magnitude = n3;
    }

    public SelectNearAction(String string, Icon icon, int n2, boolean bl2) {
        this(string, icon, n2, 1, false);
    }

    public SelectNearAction(String string, Icon icon, int n2, int n3, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
        this.direction = n2;
        this.magnitude = n3;
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        super.actionPerformed((ActionEvent)serializable);
        serializable = Globals.curEditor().getSelectionManager();
        if (((SelectionManager)serializable).getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (this.direction) {
            case 1: {
                n2 = 0 - this.magnitude;
                break;
            }
            case 2: {
                n2 = this.magnitude;
                break;
            }
            case 3: {
                n3 = 0 - this.magnitude;
                break;
            }
            case 4: {
                n3 = this.magnitude;
            }
        }
        ((SelectionManager)serializable).translate(n2, n3);
        ((SelectionManager)serializable).endTrans();
    }
}

