/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.util.Localizer;

public class SelectNextAction
extends AbstractAction {
    private static final long serialVersionUID = 1725046263612956528L;
    private String direction;
    public static final String DIR = "Direction";
    public static final String DIR_NEXT = "Next";
    public static final String DIR_PREV = "Previous";

    public SelectNextAction() {
        this(null, true);
    }

    public SelectNextAction(String string) {
        this(string, true);
    }

    public SelectNextAction(String string, boolean bl2) {
        this(string, bl2 ? DIR_NEXT : DIR_PREV, false);
    }

    public SelectNextAction(String string, String string2) {
        this(string, string2, false);
    }

    public SelectNextAction(String string, Icon icon) {
        this(string, icon, DIR_NEXT);
    }

    public SelectNextAction(String string, Icon icon, boolean bl2) {
        this(string, icon, bl2 ? DIR_NEXT : DIR_PREV, false);
    }

    public SelectNextAction(String string, Icon icon, String string2) {
        this(string, icon, string2, false);
    }

    public SelectNextAction(String string, String string2, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SelectNextAction(String string, Icon icon, String string2, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        Fig fig = null;
        int n2 = 1;
        if (DIR_PREV.equals(this.direction)) {
            n2 = -1;
        }
        Editor editor = Globals.curEditor();
        serializable = editor.getSelectionManager();
        List<Fig> list = editor.getLayerManager().getContents();
        int n3 = list.size();
        int n4 = n3 + 1;
        if (((SelectionManager)serializable).size() == 0) {
            n4 = 0;
        } else if (((SelectionManager)serializable).size() == 1) {
            serializable = ((Selection)((SelectionManager)serializable).selections().firstElement()).getContent();
            n4 = (list.indexOf(serializable) + n2 + n3) % n3;
        }
        if (n3 > n4) {
            fig = list.get(n4);
        }
        if (fig != null) {
            editor.getSelectionManager().select(fig);
        }
    }
}

