/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionLowerRight;
import org.tigris.gef.base.SelectionManager$DragMemento;
import org.tigris.gef.base.SelectionManager$SelectionMemento;
import org.tigris.gef.base.SelectionMove;
import org.tigris.gef.base.SelectionNoop;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.event.GraphSelectionEvent;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.VetoableChangeEventSource;

public class SelectionManager
implements KeyListener,
MouseListener,
MouseMotionListener,
Serializable {
    private static final long serialVersionUID = 3232261288542010603L;
    private List<Selection> selections = new ArrayList<Selection>();
    private Editor editor;
    private EventListenerList _listeners = new EventListenerList();
    private SelectionManager$DragMemento dragMemento;
    private Fig _dragTopMostFig;
    private Fig _dragLeftMostFig;
    private Collection<FigNode> _draggingNodes;
    private List<FigEdge> _draggingMovingEdges;
    private List<FigEdge> _draggingNonMovingEdges;
    private List<Fig> _draggingOthers;

    public SelectionManager(Editor editor) {
        this.editor = editor;
    }

    protected void addSelection(Selection selection) {
        this.selections.add(selection);
    }

    protected void addFig(Fig fig) {
        if (fig.isSelectable()) {
            this.selections.add(SelectionManager.makeSelectionFor(fig));
        }
    }

    @Deprecated
    protected void addAllFigs(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.addFig((Fig)object.next());
        }
    }

    protected void addFigs(Collection<? extends DiagramElement> object) {
        object = object.iterator();
        while (object.hasNext()) {
            DiagramElement diagramElement = (DiagramElement)object.next();
            this.addFig((Fig)diagramElement);
        }
    }

    protected void removeAllElements() {
        this.selections.clear();
    }

    protected void removeSelection(Selection selection) {
        if (selection != null) {
            this.selections.remove(selection);
        }
    }

    protected void removeFig(Fig eventListener) {
        if ((eventListener = this.findSelectionFor((Fig)eventListener)) != null) {
            this.selections.remove(eventListener);
        }
    }

    protected void allDamaged() {
        Rectangle rectangle = this.getBounds();
        this.editor.scaleRect(rectangle);
        this.editor.damaged(rectangle);
    }

    public void select(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.allDamaged();
        this.removeAllElements();
        this.addFig(fig);
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void addToSelection(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.addFig(fig);
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselect(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        if (this.containsFig(fig)) {
            this.removeFig(fig);
            this.editor.damageAll();
            this.fireSelectionChanged();
        }
    }

    public void toggle(Fig fig) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.editor.damageAll();
        if (this.containsFig(fig)) {
            this.removeFig(fig);
        } else {
            this.addFig(fig);
        }
        this.editor.damageAll();
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        if (this.getSelections().size() > 0) {
            if (UndoManager.getInstance().isGenerateMementos()) {
                UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
            }
            Rectangle rectangle = this.getBounds();
            this.removeAllElements();
            this.editor.damaged(rectangle);
            this.fireSelectionChanged();
        }
    }

    @Deprecated
    public void select(Collection collection) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.allDamaged();
        this.removeAllElements();
        this.addAllFigs(collection);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void selectFigs(Collection<? extends DiagramElement> collection) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.allDamaged();
        this.removeAllElements();
        this.addFigs(collection);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void toggle(Vector object) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new SelectionManager$SelectionMemento(this));
        }
        this.allDamaged();
        object = ((Vector)((Vector)object).clone()).elements();
        while (object.hasMoreElements()) {
            Fig fig = (Fig)object.nextElement();
            if (this.containsFig(fig)) {
                this.removeFig(fig);
                continue;
            }
            this.addFig(fig);
        }
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public Selection findSelectionFor(Fig fig) {
        for (Selection selection : new ArrayList<Selection>(this.getSelections())) {
            if (!selection.contains(fig)) continue;
            return selection;
        }
        return null;
    }

    public Selection findSelectionAt(int n2, int n3) {
        for (Selection selection : new ArrayList<Selection>(this.getSelections())) {
            if (!selection.contains(n2, n3)) continue;
            return selection;
        }
        return null;
    }

    public boolean contains(Selection selection) {
        return this.selections.contains(selection);
    }

    public boolean containsFig(Fig fig) {
        return this.findSelectionFor(fig) != null;
    }

    public boolean getLocked() {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getLocked()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.selections.size();
    }

    @Deprecated
    public Vector selections() {
        return new Vector<Selection>(this.selections);
    }

    public List<Selection> getSelections() {
        return Collections.unmodifiableList(new ArrayList<Selection>(this.selections));
    }

    public Vector<Fig> getFigs() {
        Vector<Fig> vector = new Vector<Fig>(this.selections.size());
        int n2 = this.selections.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            vector.addElement(this.selections.get(i2).getContent());
        }
        return vector;
    }

    public List<Fig> getSelectedFigs() {
        ArrayList<Fig> arrayList = new ArrayList<Fig>(this.selections.size());
        int n2 = this.selections.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.selections.get(i2).getContent());
        }
        return arrayList;
    }

    public List getDraggableFigs() {
        ArrayList<Fig> arrayList = new ArrayList<Fig>(this.getFigs());
        for (Fig fig : this.getFigs()) {
            if (!(fig instanceof FigNode)) continue;
            this.addDragDependents(arrayList, (FigNode)fig);
        }
        return arrayList;
    }

    public void endTrans() {
        int n2;
        int n3 = this.selections.size();
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; n2 < n3; ++n2) {
            Selection selection = this.selections.get(n2);
            this.addEnclosed(arrayList, selection.getContent());
        }
        n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Fig)arrayList.get(i2)).endTrans();
        }
    }

    public void paint(Graphics graphics) {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(graphics);
        }
    }

    public void damage() {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            iterator.next().damage();
        }
    }

    public boolean contains(int n2, int n3) {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(n2, n3)) continue;
            return true;
        }
        return false;
    }

    public boolean hit(Rectangle rectangle) {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hit(rectangle)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        if (this.selections.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.selections.get(0).getBounds();
        for (Selection selection : this.selections) {
            rectangle.add(selection.getBounds());
        }
        return rectangle;
    }

    public Rectangle getContentBounds() {
        Rectangle rectangle;
        Iterator<Selection> iterator = this.selections.iterator();
        if (iterator.hasNext()) {
            rectangle = iterator.next().getContentBounds();
        } else {
            return new Rectangle(0, 0, 0, 0);
        }
        while (iterator.hasNext()) {
            Selection selection = iterator.next();
            rectangle.add(selection.getContentBounds());
        }
        return rectangle;
    }

    public Point getLocation() {
        int n2 = this.selections.size();
        if (n2 <= 0) {
            return new Point(0, 0);
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point point;
            Point point2 = this.selections.get(i2).getLocation();
            if (point.getX() < (double)n3) {
                n3 = (int)point2.getX();
            }
            if (!(point2.getY() < (double)n4)) continue;
            n4 = (int)point2.getY();
        }
        return new Point(n3, n4);
    }

    public void reorder(int n2, Layer layer) {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            iterator.next().reorder(n2, layer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void translate(int n2, int n3) {
        void var10_20;
        int n4;
        int n5;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector<FigNode> vector4 = new Vector<FigNode>();
        this.selections.size();
        for (Selection selection : this.selections) {
            this.addEnclosed(vector, selection.getContent());
        }
        int n6 = vector.size();
        for (n5 = 0; n5 < n6; ++n5) {
            Fig fig = (Fig)vector.elementAt(n5);
            int n7 = fig.getX();
            int n8 = fig.getY();
            n2 = Math.max(-n7, n2);
            n3 = Math.max(-n8, n3);
        }
        for (n5 = 0; n5 < n6; ++n5) {
            Fig fig = (Fig)vector.elementAt(n5);
            if (!(fig instanceof FigNode)) {
                fig.translate(n2, n3);
                continue;
            }
            FigNode figNode2 = (FigNode)fig;
            vector4.addElement(figNode2);
            figNode2.superTranslate(n2, n3);
            for (Object e2 : figNode2.getFigEdges(null)) {
                if (vector2.contains(e2) && !vector3.contains(e2)) {
                    vector3.addElement(e2);
                    continue;
                }
                vector2.addElement(e2);
            }
        }
        n5 = vector3.size();
        for (n4 = 0; n4 < n5; ++n4) {
            ((FigEdge)vector3.elementAt(n4)).translateEdge(n2, n3);
        }
        n4 = vector4.size();
        boolean bl2 = false;
        while (var10_20 < n4) {
            ((FigNode)vector4.elementAt((int)var10_20)).updateEdges();
            ++var10_20;
        }
    }

    protected void addEnclosed(Collection collection, Fig cloneable) {
        if (!collection.contains(cloneable)) {
            collection.add(cloneable);
            cloneable = ((Fig)cloneable).getEnclosedFigs();
            if (cloneable != null) {
                int n2 = cloneable.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.addEnclosed(collection, (Fig)cloneable.get(i2));
                }
            }
        }
    }

    public void startDrag() {
        int n2;
        ArrayList arrayList = new ArrayList();
        this._draggingNodes = new HashSet<FigNode>();
        this._draggingMovingEdges = new ArrayList<FigEdge>();
        this._draggingNonMovingEdges = new ArrayList<FigEdge>();
        this._draggingOthers = new ArrayList<Fig>();
        int n3 = this.selections.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Selection selection = this.selections.get(n2);
            this.addEnclosed(arrayList, selection.getContent());
        }
        n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig2 = (Fig)arrayList.get(i2);
            if (fig2 instanceof FigEdge) {
                FigEdge figEdge = (FigEdge)fig2;
                this.checkDragEdge(figEdge, arrayList, this._draggingNonMovingEdges);
                continue;
            }
            if (!(fig2 instanceof FigNode)) {
                this._draggingOthers.add(fig2);
                continue;
            }
            FigNode figNode = (FigNode)fig2;
            this._draggingNodes.add(figNode);
            this.addDragDependents(this._draggingNodes, figNode);
            for (FigEdge figEdge : figNode.getFigEdges(null)) {
                this.checkDragEdge(figEdge, arrayList, this._draggingNonMovingEdges);
            }
        }
        for (Fig fig : this._draggingNodes.size() > 0 ? this._draggingNodes : this._draggingOthers) {
            if (this._dragLeftMostFig == null || fig.getX() < this._dragLeftMostFig.getX()) {
                this._dragLeftMostFig = fig;
            }
            if (this._dragTopMostFig != null && fig.getY() >= this._dragTopMostFig.getY()) continue;
            this._dragTopMostFig = fig;
        }
        if (UndoManager.getInstance().isGenerateMementos()) {
            this.dragMemento = new SelectionManager$DragMemento(this, this._draggingNodes, this._draggingOthers, this._draggingMovingEdges, this._draggingNonMovingEdges);
        }
        UndoManager.getInstance().addMementoLock(this);
    }

    private void addDragDependents(Collection collection, FigNode object) {
        if (((FigNode)((Object)object)).getDragDependencies() != null) {
            for (Fig e2 : ((FigNode)((Object)object)).getDragDependencies()) {
                if (collection.contains(e2)) continue;
                collection.add(e2);
            }
        }
    }

    private void checkDragEdge(FigEdge figEdge, List list, List list2) {
        FigNode figNode = figEdge.getDestFigNode();
        FigNode figNode2 = figEdge.getSourceFigNode();
        if (list.contains(figNode) && list.contains(figNode2)) {
            if (!this._draggingMovingEdges.contains(figEdge)) {
                this._draggingMovingEdges.add(figEdge);
                return;
            }
        } else if (!list2.contains(figEdge)) {
            list2.add(figEdge);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drag(int n2, int n3) {
        void var6_17;
        if (this._dragLeftMostFig == null || this._dragTopMostFig == null) {
            return;
        }
        Rectangle rectangle = this._dragLeftMostFig.getBounds();
        Rectangle rectangle2 = this._dragLeftMostFig.getBounds();
        n2 = Math.max(-this._dragLeftMostFig.getX(), n2);
        n3 = Math.max(-this._dragTopMostFig.getY(), n3);
        for (FigNode serializable2 : this._draggingNodes) {
            serializable2.getBounds(rectangle2);
            rectangle.add(rectangle2.x, rectangle2.y);
            rectangle.add(rectangle2.x + n2, rectangle2.y + n3);
            rectangle.add(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            rectangle.add(rectangle2.x + rectangle2.width + n2, rectangle2.y + rectangle2.height + n3);
            serializable2.superTranslate(n2, n3);
        }
        for (Fig fig : this._draggingOthers) {
            fig.getBounds(rectangle2);
            rectangle.add(rectangle2.x, rectangle2.y);
            rectangle.add(rectangle2.x + n2, rectangle2.y + n3);
            rectangle.add(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            rectangle.add(rectangle2.x + rectangle2.width + n2, rectangle2.y + rectangle2.height + n3);
            fig.translate(n2, n3);
            fig.translateAnnotations();
        }
        for (FigEdge figEdge : this._draggingMovingEdges) {
            figEdge.getBounds(rectangle2);
            rectangle.add(rectangle2.x, rectangle2.y);
            rectangle.add(rectangle2.x + n2, rectangle2.y + n3);
            rectangle.add(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            rectangle.add(rectangle2.x + rectangle2.width + n2, rectangle2.y + rectangle2.height + n3);
            figEdge.translateEdge(n2, n3);
            figEdge.translateAnnotations();
        }
        for (FigEdge figEdge : this._draggingNonMovingEdges) {
            figEdge.getBounds(rectangle2);
            rectangle.add(rectangle2);
            figEdge.computeRoute();
            figEdge.getBounds(rectangle2);
            rectangle.add(rectangle2);
            figEdge.translateAnnotations();
        }
        rectangle.x -= 24;
        rectangle.y -= 24;
        rectangle.width += 48;
        rectangle.height += 48;
        Layer layer = this._dragLeftMostFig.getLayer();
        if (layer == null && this._dragLeftMostFig.getOwner() instanceof Fig) {
            Layer layer2 = ((Fig)this._dragLeftMostFig.getOwner()).getLayer();
        }
        if (var6_17 != null) {
            List<Editor> list = var6_17.getEditors();
            n3 = list.size();
            rectangle2 = new Rectangle();
            for (int i2 = 0; i2 < n3; ++i2) {
                Editor editor = list.get(i2);
                double d2 = editor.getScale();
                rectangle2.x = (int)Math.floor((double)rectangle.x * d2);
                rectangle2.y = (int)Math.floor((double)rectangle.y * d2);
                rectangle2.width = (int)Math.floor((double)rectangle.width * d2) + 1;
                rectangle2.height = (int)Math.floor((double)rectangle.height * d2) + 1;
                editor.damaged(rectangle2);
            }
            return;
        }
        System.out.println("Selection manager: layer is null");
    }

    public void stopDrag() {
        UndoManager.getInstance().removeMementoLock(this);
        if (this.dragMemento != null) {
            UndoManager.getInstance().addMemento(this.dragMemento);
        }
        this.dragMemento = null;
        this.cleanup();
    }

    private void cleanup() {
        this._dragTopMostFig = null;
        this._dragLeftMostFig = null;
        this._draggingNodes = null;
        this._draggingMovingEdges = null;
        this._draggingNonMovingEdges = null;
        this._draggingOthers = null;
    }

    public Point getDragLocation() {
        return new Point(this._dragLeftMostFig.getX(), this._dragTopMostFig.getY());
    }

    public void hitHandle(Rectangle rectangle, Handle handle) {
        if (this.size() == 1) {
            this.selections.get(0).hitHandle(rectangle, handle);
            return;
        }
        handle.index = -1;
    }

    public void dragHandle(int n2, int n3, int n4, int n5, Handle handle) {
        if (this.size() != 1) {
            return;
        }
        this.selections.get(0).dragHandle(n2, n3, n4, n5, handle);
    }

    public void cleanUp() {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            iterator.next().getContent().cleanUp();
        }
    }

    public void removeFromGraph() {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext()) {
            ((Selection)iterator.next()).delete();
        }
    }

    public void dispose() {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext()) {
            Enumeration enumeration = ((Selection)iterator.next()).getContent().getOwner();
            if (!(enumeration instanceof VetoableChangeEventSource)) continue;
            enumeration = (Vector)((VetoableChangeEventSource)((Object)enumeration)).getVetoableChangeListeners().clone();
            ((Vector)((Object)enumeration)).elements();
            enumeration = ((Vector)((Object)enumeration)).elements();
            Object var3_3 = null;
            boolean bl2 = true;
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof Fig)) continue;
                if (bl2) {
                    var3_3 = e2;
                    bl2 = false;
                    continue;
                }
                ((Fig)e2).removeFromDiagram();
            }
            ((Fig)var3_3).deleteFromModel();
        }
    }

    public void deleteFromModel() {
        Iterator<Selection> iterator = this.getSelections().iterator();
        while (iterator.hasNext()) {
            iterator.next().getContent().deleteFromModel();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !keyEvent.isConsumed()) {
            ((Selection)iterator.next()).keyTyped(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !keyEvent.isConsumed()) {
            ((Selection)iterator.next()).keyReleased(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !keyEvent.isConsumed()) {
            ((Selection)iterator.next()).keyPressed(keyEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Iterator iterator = new ArrayList<Selection>(this.selections).iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((Selection)iterator.next()).mouseEntered(mouseEvent);
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._listeners.add(GraphSelectionListener.class, graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._listeners.remove(GraphSelectionListener.class, graphSelectionListener);
    }

    protected void fireSelectionChanged() {
        this.cleanup();
        Object[] objectArray = this._listeners.getListenerList();
        GraphSelectionEvent graphSelectionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != GraphSelectionListener.class) continue;
            if (graphSelectionEvent == null) {
                graphSelectionEvent = new GraphSelectionEvent(this.editor, this.getFigs());
            }
            ((GraphSelectionListener)objectArray[i2 + 1]).selectionChanged(graphSelectionEvent);
        }
        this.updatePropertySheet();
    }

    public void updatePropertySheet() {
    }

    public Class findCommonSuperClass() {
        Iterator<Selection> iterator = this.selections.iterator();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        Class<?> clazz = null;
        while (iterator.hasNext()) {
            int n3;
            Class<?> clazz2 = iterator.next().getContent().getClass();
            if (hashMap.containsKey(clazz2.getName())) {
                n3 = (Integer)hashMap.get(clazz2.getName());
                hashMap.put(clazz2.getName(), new Integer(++n3));
            } else {
                n3 = 1;
                hashMap.put(clazz2.getName(), new Integer(1));
            }
            if (n3 > n2) {
                n2 = n3;
                clazz = clazz2;
            }
            for (clazz2 = clazz2.getSuperclass(); clazz2 != null && !clazz2.equals(Fig.class); clazz2 = clazz2.getSuperclass()) {
                if (hashMap.containsKey(clazz2.getName())) {
                    n3 = (Integer)hashMap.get(clazz2.getName());
                    hashMap.put(clazz2.getName(), new Integer(++n3));
                } else {
                    n3 = 1;
                    hashMap.put(clazz2.getName(), new Integer(1));
                }
                if (n3 <= n2) continue;
                n2 = n3;
                clazz = clazz2;
            }
        }
        if (n2 == this.selections.size()) {
            return clazz;
        }
        return Fig.class;
    }

    public Object findFirstSelectionOfType(Class clazz) {
        Iterator<Selection> iterator = this.selections.iterator();
        while (iterator.hasNext()) {
            Fig fig = iterator.next().getContent();
            if (!fig.getClass().equals(clazz)) continue;
            return fig;
        }
        return null;
    }

    public static Selection makeSelectionFor(Fig fig) {
        Selection selection = fig.makeSelection();
        if (selection != null) {
            return selection;
        }
        if (fig.isReshapable()) {
            return new SelectionReshape(fig);
        }
        if (fig.isLowerRightResizable()) {
            return new SelectionLowerRight(fig);
        }
        if (fig.isResizable()) {
            return new SelectionResize(fig);
        }
        if (fig.isMovable()) {
            return new SelectionMove(fig);
        }
        return new SelectionNoop(fig);
    }

    static /* synthetic */ List access$000(SelectionManager selectionManager) {
        return selectionManager.selections;
    }

    static /* synthetic */ List access$002(SelectionManager selectionManager, List list) {
        selectionManager.selections = list;
        return selectionManager.selections;
    }

    static /* synthetic */ Editor access$100(SelectionManager selectionManager) {
        return selectionManager.editor;
    }
}

