/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class UseReshapeAction
extends UndoableAction {
    private static final long serialVersionUID = -4052325627767476140L;

    public UseReshapeAction(String string) {
        this(string, false);
    }

    public UseReshapeAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public UseReshapeAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public UseReshapeAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        super.actionPerformed((ActionEvent)serializable);
        serializable = Globals.curEditor();
        SelectionManager selectionManager = ((Editor)serializable).getSelectionManager();
        Enumeration enumeration = ((Vector)selectionManager.selections().clone()).elements();
        while (enumeration.hasMoreElements()) {
            Fig fig;
            Selection selection = (Selection)enumeration.nextElement();
            if (!(selection instanceof Selection) || selection instanceof SelectionReshape || !(fig = selection.getContent()).isReshapable()) continue;
            ((Editor)serializable).damaged(selection);
            selectionManager.removeSelection(selection);
            selection = new SelectionReshape(fig);
            selectionManager.addSelection(selection);
            ((Editor)serializable).damaged(selection);
        }
    }
}

