/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.graph.MutableGraphSupport;

public abstract class AdjacencyListGraphModel
extends MutableGraphSupport
implements Serializable {
    public static String UNLABELED = "Unlabeled";
    protected Vector _nodes = new Vector();
    protected Vector _edges = new Vector();

    public boolean OK() {
        if (this._nodes == null) {
            return false;
        }
        if (this._edges == null) {
            return false;
        }
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (this.containsPort(objectArray[0]) && this.containsPort(objectArray[1])) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getNodes() {
        return this._nodes;
    }

    @Override
    public List getEdges() {
        return this._edges;
    }

    @Override
    public abstract List getPorts(Object var1);

    @Override
    public abstract Object getOwner(Object var1);

    @Override
    public Object getSourcePort(Object object) {
        return ((Object[])object)[0];
    }

    @Override
    public Object getDestPort(Object object) {
        return ((Object[])object)[1];
    }

    @Override
    public List getInEdges(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != objectArray[1]) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }

    @Override
    public List getOutEdges(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != objectArray[0]) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }

    @Override
    public boolean canAddNode(Object object) {
        return true;
    }

    @Override
    public boolean canAddEdge(Object object) {
        return object instanceof Object[] && ((Object[])object).length == 3;
    }

    @Override
    public void addNode(Object object) {
        this._nodes.addElement(object);
    }

    @Override
    public void addEdge(Object object) {
        if (this.canAddEdge(object)) {
            this._edges.addElement(object);
        }
    }

    @Override
    public void removeNode(Object object) {
        this._nodes.removeElement(object);
    }

    @Override
    public void removeEdge(Object object) {
        this._edges.removeElement(object);
    }

    @Override
    public boolean canConnect(Object object, Object object2) {
        return true;
    }

    @Override
    public Object connect(Object object, Object object2) {
        return this.addLabeledEdge(object, object2, UNLABELED);
    }

    public Object getEdgeLabel(Object object) {
        return ((Object[])object)[2];
    }

    public Object addLabeledEdge(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray2[1] = object2;
        objectArray2[2] = object3;
        this.addEdge(objectArray2);
        return objectArray2;
    }

    public Vector getEdgesLabeled(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != this.getEdgeLabel(objectArray)) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }
}

