/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetList;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;

public class DefaultGraphModel
extends MutableGraphSupport
implements Serializable {
    private static final long serialVersionUID = 8098329898758384131L;
    private NetList netList;
    private static Log LOG = LogFactory.getLog(DefaultGraphModel.class);

    public DefaultGraphModel() {
        this.netList = new NetList();
    }

    public DefaultGraphModel(ConnectionConstrainer connectionConstrainer) {
        super(connectionConstrainer);
        this.netList = new NetList();
    }

    public DefaultGraphModel(NetList netList) {
        this.netList = netList;
    }

    @Override
    public List getNodes() {
        return this.netList.getNodes();
    }

    @Override
    public List getEdges() {
        return this.netList.getEdges();
    }

    @Override
    public List getPorts(Object object) {
        if (object instanceof NetNode) {
            return ((NetNode)object).getPorts();
        }
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getPorts();
        }
        return null;
    }

    public Collection getNodes(Collection collection) {
        return this.netList.getNodes(collection);
    }

    public Collection getEdges(Collection collection) {
        return this.netList.getEdges(collection);
    }

    public Collection getPorts(Collection collection, Object object) {
        if (object instanceof NetNode) {
            return ((NetNode)object).getPorts();
        }
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getPorts();
        }
        return null;
    }

    @Override
    public Object getOwner(Object object) {
        if (object instanceof NetPort) {
            return ((NetPort)object).getParent();
        }
        return null;
    }

    @Override
    public List getInEdges(Object object) {
        Vector<NetEdge> vector = new Vector<NetEdge>();
        Vector vector2 = ((NetPort)object).getEdges();
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            NetEdge netEdge = (NetEdge)vector2.elementAt(i2);
            if (netEdge.getDestPort() != object) continue;
            vector.add(netEdge);
        }
        return vector;
    }

    @Override
    public List getOutEdges(Object object) {
        Vector<NetEdge> vector = new Vector<NetEdge>();
        Vector vector2 = ((NetPort)object).getEdges();
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            NetEdge netEdge = (NetEdge)vector2.elementAt(i2);
            if (netEdge.getSourcePort() != object) continue;
            vector.add(netEdge);
        }
        return vector;
    }

    @Override
    public Object getSourcePort(Object object) {
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getSourcePort();
        }
        return null;
    }

    @Override
    public Object getDestPort(Object object) {
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getDestPort();
        }
        return null;
    }

    @Override
    public Object createNode(String string, Hashtable hashtable) {
        try {
            string = Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        if (string instanceof GraphNodeHooks) {
            ((GraphNodeHooks)((Object)string)).initialize(hashtable);
        }
        return string;
    }

    @Override
    public boolean canAddNode(Object object) {
        return object instanceof NetNode;
    }

    @Override
    public boolean canAddEdge(Object object) {
        return object instanceof NetEdge;
    }

    @Override
    public void removeNode(Object object) {
        NetNode netNode = (NetNode)object;
        this.netList.removeNode(netNode);
        LOG.debug((Object)"Removed node from graph model");
        super.removeNode(object);
    }

    @Override
    public boolean canDragNode(Object object) {
        return object instanceof NetNode;
    }

    @Override
    public void addNode(Object object) {
        NetNode netNode = (NetNode)object;
        this.netList.addNode(netNode);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added a node. There are now " + this.netList.getNodes(null).size() + " edges"));
        }
        super.addNode(object);
    }

    @Override
    public void addEdge(Object object) {
        object = (NetEdge)object;
        this.netList.addEdge((NetEdge)object);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added an edge. There are now " + this.netList.getEdges(null).size() + " edges"));
        }
        super.addEdge(object);
    }

    @Override
    public void addNodeRelatedEdges(Object object) {
    }

    @Override
    public void removeEdge(Object object) {
        LOG.debug((Object)"DefaultGraphModel::removeEdge");
        object = (NetEdge)object;
        this.netList.removeEdge((NetEdge)object);
        super.removeEdge(object);
    }

    @Override
    public void removeAllNodes() {
        LOG.debug((Object)"Removing all the nodes from the graph.");
        this.netList.removeAllNodes();
        super.removeAllNodes();
    }

    @Override
    public void removeAllEdges() {
        LOG.debug((Object)"Removing all the edges from the graph.");
        this.netList.removeAllEdges();
        super.removeAllEdges();
    }

    @Override
    public void removeAll() {
        this.netList.removeAllEdges();
        this.netList.removeAllNodes();
        super.removeAll();
    }

    @Override
    public void dragNode(Object object) {
        this.addNode(object);
    }

    @Override
    public boolean canConnect(Object object, Object object2) {
        if (object instanceof NetPort && object2 instanceof NetPort) {
            object = (NetPort)object;
            object2 = (NetPort)object2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking with ports to see if connection valid");
            }
            return ((NetPort)object).canConnectTo(this, object2) && ((NetPort)object2).canConnectTo(this, object);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"By default, cannot connect non-NetPort objects");
        }
        return false;
    }

    @Override
    public Object connect(Object object, Object object2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to connect " + object + " to " + object2));
        }
        if (!this.canConnect(object, object2)) {
            LOG.warn((Object)"Connection not allowed");
            return null;
        }
        if (object instanceof NetPort && object2 instanceof NetPort) {
            object = (NetPort)object;
            object2 = (NetPort)object2;
            NetEdge netEdge = ((NetPort)object).makeEdgeFor((NetPort)object2);
            return this.connectInternal((NetPort)object, (NetPort)object2, netEdge);
        }
        return null;
    }

    @Override
    public Object connect(Object object, Object object2, Object object3) {
        return this.connect(object, object2, (Class)object3);
    }

    @Override
    public Object connect(Object object, Object object2, Class serializable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to connect " + object + " to " + object2 + " with " + serializable));
        }
        if (!this.canConnect(object, object2, (Class)serializable)) {
            LOG.warn((Object)"Connection not allowed");
            return null;
        }
        if (object instanceof NetPort && object2 instanceof NetPort) {
            object = (NetPort)object;
            object2 = (NetPort)object2;
            try {
                serializable = (NetEdge)serializable.newInstance();
                return this.connectInternal((NetPort)object, (NetPort)object2, (NetEdge)serializable);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return null;
    }

    protected Object connectInternal(NetPort netPort, NetPort netPort2, NetEdge netEdge) {
        if (netEdge.connect(this, netPort, netPort2)) {
            this.addEdge(netEdge);
            return netEdge;
        }
        return null;
    }

    @Override
    public boolean canChangeConnectedNode(Object object, Object object2, Object object3) {
        return false;
    }

    @Override
    public void changeConnectedNode(Object object, Object object2, Object object3, boolean bl2) {
    }
}

