/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public abstract class NetEdge
extends NetPrimitive
implements Serializable,
GraphEdgeHooks {
    private static final Log LOG = LogFactory.getLog(NetEdge.class);
    protected NetPort _sourcePort;
    protected NetPort _destPort;
    protected Vector _ports;

    public void setSourcePort(NetPort netPort) {
        this._sourcePort = netPort;
    }

    public NetPort getSourcePort() {
        return this._sourcePort;
    }

    public void setDestPort(NetPort netPort) {
        this._destPort = netPort;
    }

    public NetPort getDestPort() {
        return this._destPort;
    }

    public NetPort otherEnd(NetPort netPort) {
        NetPort netPort2 = this.getSourcePort();
        if (netPort2 == netPort) {
            return this.getDestPort();
        }
        return netPort2;
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector vector) {
        this._ports = vector;
    }

    public boolean connect(GraphModel graphModel, Object object, Object object2) {
        NetPort netPort = (NetPort)object;
        NetPort netPort2 = (NetPort)object2;
        if (!netPort.canConnectTo(graphModel, object2)) {
            return false;
        }
        if (!netPort2.canConnectTo(graphModel, object)) {
            return false;
        }
        this.setSourcePort(netPort);
        this.setDestPort(netPort2);
        netPort.addEdge(this);
        netPort2.addEdge(this);
        netPort.postConnect(graphModel, object2);
        netPort2.postConnect(graphModel, object);
        return true;
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        if (this.getSourcePort() != null && this.getDestPort() != null) {
            this._sourcePort.removeEdge(this);
            this._destPort.removeEdge(this);
            DefaultGraphModel defaultGraphModel = (DefaultGraphModel)Globals.curEditor().getGraphModel();
            defaultGraphModel.removeEdge(this);
            this._sourcePort.postDisconnect(defaultGraphModel, this.getDestPort());
            this._destPort.postDisconnect(defaultGraphModel, this.getSourcePort());
            this.firePropertyChange("disposed", false, true);
        }
    }

    public FigEdge presentationFor(Layer layer) {
        Serializable serializable;
        if (layer != null && (serializable = (FigEdge)layer.presentationFor(this)) != null) {
            return serializable;
        }
        serializable = this._sourcePort.getParentNode();
        Serializable serializable2 = this._destPort.getParentNode();
        FigNode figNode = ((NetNode)serializable).presentationFor(layer);
        serializable2 = ((NetNode)serializable2).presentationFor(layer);
        Fig fig = figNode.getPortFig(this._sourcePort);
        Fig fig2 = ((FigNode)serializable2).getPortFig(this._destPort);
        serializable = this.makePresentation(layer);
        ((FigEdge)serializable).setSourcePortFig(fig);
        ((FigEdge)serializable).setDestPortFig(fig2);
        ((FigEdge)serializable).setSourceFigNode(figNode);
        ((FigEdge)serializable).setDestFigNode((FigNode)serializable2);
        ((FigEdge)serializable).setOwner(this);
        return serializable;
    }

    public abstract FigEdge makePresentation(Layer var1);
}

