/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.FigNode;

public abstract class NetNode
extends NetPrimitive
implements Serializable,
GraphNodeHooks {
    private List _ports;
    private static Log LOG = LogFactory.getLog(NetNode.class);

    public NetNode(NetNode netNode, List list) {
        this._ports = list;
    }

    public NetNode() {
        this(null, new ArrayList());
    }

    @Override
    public abstract void initialize(Hashtable var1);

    public Object getAttributes() {
        return null;
    }

    public NetPort getPort(int n2) {
        return (NetPort)this._ports.get(n2);
    }

    public List getPorts() {
        return this._ports;
    }

    public void setPorts(List list) {
        this._ports = list;
    }

    public void addPort(NetPort netPort) {
        this._ports.add(netPort);
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        Iterator iterator = this._ports.iterator();
        while (iterator.hasNext()) {
            ((NetPort)iterator.next()).deleteFromModel();
        }
        ((DefaultGraphModel)Globals.curEditor().getGraphModel()).removeNode(this);
        this.firePropertyChange("disposed", false, true);
    }

    public FigNode presentationFor(Layer layer) {
        FigNode figNode;
        if (layer != null && (figNode = (FigNode)layer.presentationFor(this)) != null) {
            return figNode;
        }
        return this.makePresentation(layer);
    }

    public abstract FigNode makePresentation(Layer var1);

    @Override
    public void postConnect(GraphModel graphModel, Object object, Object object2, Object object3) {
    }

    @Override
    public void postDisconnect(GraphModel graphModel, Object object, Object object2, Object object3) {
    }

    @Override
    public boolean canConnectTo(GraphModel graphModel, Object object, Object object2, Object object3) {
        return true;
    }

    @Override
    public void postPlacement(Editor editor) {
    }
}

