/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPrimitive;

public class NetPort
extends NetPrimitive
implements Serializable,
GraphPortHooks {
    private static final long serialVersionUID = -3506978147166333303L;
    public static String DEFAULT_EDGE_CLASS = "org.tigris.gef.graph.presentation.NetEdge";
    private Vector edges;
    private Object _parent;
    private static Log LOG = LogFactory.getLog(NetPort.class);

    public NetPort(Object object) {
        this._parent = object;
        this.edges = new Vector();
    }

    @Override
    public String getId() {
        return this.toString();
    }

    public NetNode getParentNode() {
        return (NetNode)this._parent;
    }

    public NetEdge getParentEdge() {
        return (NetEdge)this._parent;
    }

    public Object getParent() {
        return this._parent;
    }

    public Vector getEdges() {
        return this.edges;
    }

    public void addEdge(NetEdge netEdge) {
        this.edges.addElement(netEdge);
    }

    public void removeEdge(NetEdge netEdge) {
        this.edges.removeElement(netEdge);
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        int n2 = this.edges.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((NetEdge)this.edges.get(0)).deleteFromModel();
        }
        this.firePropertyChange("disposed", false, true);
    }

    @Override
    public void postConnect(GraphModel graphModel, Object object) {
        object = (NetPort)object;
        this.getParentNode().postConnect(graphModel, ((NetPort)object).getParentNode(), this, object);
    }

    @Override
    public void postDisconnect(GraphModel graphModel, Object object) {
        object = (NetPort)object;
        this.getParentNode().postDisconnect(graphModel, ((NetPort)object).getParentNode(), this, object);
    }

    protected Class defaultEdgeClass(NetPort netPort) {
        try {
            return Class.forName(DEFAULT_EDGE_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public NetEdge makeEdgeFor(NetPort serializable) {
        if ((serializable = this.defaultEdgeClass((NetPort)serializable)) == null) {
            LOG.error((Object)"defaultEdgeClass is null");
            return null;
        }
        try {
            serializable = (NetEdge)((Class)serializable).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error((Object)"Failed to create edge ", (Throwable)illegalAccessException);
            return null;
        }
        catch (InstantiationException instantiationException) {
            LOG.error((Object)"Failed to create edge ", (Throwable)instantiationException);
            return null;
        }
        LOG.debug((Object)("Made edge " + serializable.getClass().getName()));
        return serializable;
    }

    @Override
    public boolean canConnectTo(GraphModel graphModel, Object object) {
        NetNode netNode = this.getParentNode();
        NetNode netNode2 = ((NetPort)object).getParentNode();
        return netNode.canConnectTo(graphModel, netNode2, object, this);
    }
}

