/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.MacroRecord;
import org.tigris.gef.ocl.TemplateRecord;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateReader
extends DefaultHandler {
    private static final TemplateReader INSTANCE = new TemplateReader();
    private static final Log LOG = LogFactory.getLog(TemplateReader.class);
    private Hashtable _templates;
    private Vector _macros;
    private TemplateRecord _currentTemplate = null;
    private MacroRecord _currentMacro = null;
    private String filename;

    protected TemplateReader() {
    }

    public static TemplateReader getInstance() {
        return INSTANCE;
    }

    public Hashtable read(String string) {
        this.filename = string;
        try {
            Object object;
            Object object2;
            try {
                object2 = TemplateReader.class.getResourceAsStream(string);
            }
            catch (Exception exception) {
                object = string;
                if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                object2 = new FileInputStream((String)object);
            }
            this._templates = new Hashtable();
            this._macros = new Vector();
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(false);
            ((SAXParserFactory)object).setValidating(false);
            object = ((SAXParserFactory)object).newSAXParser();
            object2 = new InputSource((InputStream)object2);
            ((InputSource)object2).setSystemId(new URL("file", null, string).toString());
            ((SAXParser)object).parse((InputSource)object2, (DefaultHandler)this);
        }
        catch (Exception exception) {
            throw new ExpansionException(exception);
        }
        return this._templates;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
        this._currentTemplate = null;
        this._currentMacro = null;
    }

    @Override
    public void endDocument() {
        this._currentTemplate = null;
        this._currentMacro = null;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void startElement(String string, String string2, String object, Attributes attributes) {
        if (((String)object).equals("template")) {
            string = attributes.getValue("guard");
            string2 = attributes.getValue("class");
            LOG.debug((Object)("Start template guard=\"" + string + "\" class=\"" + string2 + "\""));
            try {
                object = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXException("Can't find the class " + string2 + " refered to in the file " + this.filename, classNotFoundException);
            }
            this._currentTemplate = new TemplateRecord((Class)object, string, null);
            this._currentMacro = null;
            return;
        }
        if (((String)object).equals("macro")) {
            string = attributes.getValue("name");
            this._currentMacro = new MacroRecord(string, null);
            this._currentTemplate = null;
            return;
        }
        this._currentMacro = null;
        this._currentTemplate = null;
        if (!((String)object).equals("TemplateSet")) {
            throw new SAXException("unknown tag: " + (String)object);
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this._currentMacro != null) {
            this._currentMacro.characters(cArray, n2, n3);
            return;
        }
        if (this._currentTemplate != null) {
            this._currentTemplate.characters(cArray, n2, n3);
        }
    }

    @Override
    public void endElement(String object, String vector, String string) {
        if (this._currentTemplate != null && string.equals("template")) {
            object = this._currentTemplate.getBody().trim();
            object = this.expandMacros((String)object);
            this._currentTemplate.setBody((String)object);
            object = this._currentTemplate.getKey();
            vector = (Vector)this._templates.get(object);
            if (vector == null) {
                vector = new Vector<TemplateRecord>();
            }
            vector.addElement(this._currentTemplate);
            this._templates.put(object, vector);
            this._currentTemplate = null;
            return;
        }
        if (this._currentMacro != null && string.equals("macro")) {
            object = this._currentMacro.getBody().trim();
            object = this.expandMacros((String)object);
            this._currentMacro.setBody((String)object);
            boolean bl2 = false;
            int n2 = this._currentMacro.getName().length();
            int n3 = this._macros.size();
            for (int i2 = 0; i2 < n3 && !bl2; ++i2) {
                if (((MacroRecord)this._macros.elementAt((int)i2)).name.length() >= n2) continue;
                this._macros.insertElementAt(this._currentMacro, i2);
                bl2 = true;
            }
            if (!bl2) {
                this._macros.addElement(this._currentMacro);
            }
            this._currentMacro = null;
        }
    }

    public String expandMacros(String object) {
        StringBuffer stringBuffer = new StringBuffer(((String)object).length() << 1);
        object = new StringTokenizer((String)object, "\n\r");
        while (((StringTokenizer)object).hasMoreElements()) {
            String string = ((StringTokenizer)object).nextToken();
            string = this.expandMacrosOnOneLine(string);
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String expandMacrosOnOneLine(String charSequence) {
        int n2 = this._macros.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = ((MacroRecord)this._macros.elementAt((int)i2)).name;
            int n3 = ((String)charSequence).indexOf(string);
            if (n3 == -1) continue;
            Object object = ((MacroRecord)this._macros.elementAt((int)i2)).body;
            String string2 = ((String)charSequence).substring(0, n3);
            string = ((String)charSequence).substring(n3 + string.length());
            charSequence = new StringBuffer(((String)object).length() + (string2.length() + string.length()) * 10);
            object = new StringTokenizer((String)object, "\n\r");
            while (((StringTokenizer)object).hasMoreElements()) {
                ((StringBuffer)charSequence).append(string2);
                ((StringBuffer)charSequence).append(((StringTokenizer)object).nextToken());
                ((StringBuffer)charSequence).append(string);
                if (!((StringTokenizer)object).hasMoreElements()) continue;
                ((StringBuffer)charSequence).append("\n");
            }
            return ((StringBuffer)charSequence).toString();
        }
        return charSequence;
    }
}

