/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;

public class PgmlUtility {
    public static String getColor(Color color) {
        String string = PgmlUtility.getColorName(color);
        if (string != null) {
            return string;
        }
        return color.getRed() + " " + color.getGreen() + " " + color.getBlue();
    }

    private static String getColorName(Color color) {
        String string = null;
        if (color.equals(Color.white)) {
            string = "white";
        } else if (color.equals(Color.black)) {
            string = "black";
        } else if (color.equals(Color.red)) {
            string = "red";
        } else if (color.equals(Color.green)) {
            string = "green";
        } else if (color.equals(Color.blue)) {
            string = "blue";
        }
        return string;
    }

    public static String getVisibility(Fig fig) {
        if (fig.isVisible()) {
            return null;
        }
        return "0";
    }

    public static int getDashed(Fig fig) {
        if (fig.getDashed()) {
            return 1;
        }
        return 0;
    }

    public static int getFilled(Fig fig) {
        if (fig.getFilled()) {
            return 1;
        }
        return 0;
    }

    public static List getContentsNoEdges(Layer object) {
        object = ((Layer)object).getContents();
        int n2 = object.size();
        ArrayList arrayList = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = object.get(i2);
            if (e2 instanceof FigEdge) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public static String getId(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A fig must be supplied");
        }
        if (fig.getGroup() != null) {
            String string = fig.getGroup().getId();
            if (fig.getGroup() instanceof FigGroup) {
                FigGroup figGroup = (FigGroup)fig.getGroup();
                return string + "." + figGroup.getFigs().indexOf(fig);
            }
            if (fig.getGroup() instanceof FigEdge) {
                FigEdge figEdge = (FigEdge)fig.getGroup();
                return string + "." + (figEdge.getPathItemFigs().indexOf(fig) + 1);
            }
            return string + ".0";
        }
        Layer layer = fig.getLayer();
        if (layer == null) {
            return "LAYER_NULL";
        }
        int n2 = layer.getContents().indexOf(fig);
        return "Fig" + n2;
    }
}

