/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;

public class AnnotationHelper {
    private static AnnotationHelper theInstance = null;

    private AnnotationHelper() {
    }

    public static AnnotationHelper instance() {
        if (theInstance == null) {
            theInstance = new AnnotationHelper();
        }
        return theInstance;
    }

    public static final int getNormOffset(Point point, Point point2, Point point3) {
        float f2 = (float)((double)((point3.x - point2.x) * (point.y - point2.y) - (point.x - point2.x) * (point3.y - point2.y)) / Math.sqrt((point3.x - point2.x) * (point3.x - point2.x) + (point3.y - point2.y) * (point3.y - point2.y)));
        return -1 * Math.round(f2);
    }

    public static final float getRatio(Point point, Point point2, Point point3) {
        int n2 = point3.x - point2.x;
        int n3 = point3.y - point2.y;
        int n4 = n2 * n2 + n3 * n3;
        return (float)(n2 * (point.x - point2.x) + n3 * (point.y - point2.y)) / (float)n4;
    }

    public static final Point getClosestPoint(Point point, FigEdge cloneable) {
        List<Point> list;
        try {
            list = ((FigPoly)cloneable.getFig()).getPointsList();
        }
        catch (Exception exception) {
            list = new ArrayList<Point>();
        }
        if (list.size() < 2) {
            list.add(cloneable.getSourcePortFig().getCenter());
            list.add(cloneable.getDestPortFig().getCenter());
        }
        cloneable = AnnotationHelper.getClosestPointOnEdge(point, list.get(0), list.get(1));
        int n2 = AnnotationHelper.sqr_distance(point, (Point)cloneable);
        for (int i2 = 1; i2 < list.size() - 1; ++i2) {
            Point point2 = list.get(i2);
            Point point3 = list.get(i2 + 1);
            if (AnnotationHelper.sqr_distance(point, point2 = AnnotationHelper.getClosestPointOnEdge(point, point2, point3)) >= n2) continue;
            cloneable = point2;
            n2 = AnnotationHelper.sqr_distance(point, (Point)cloneable);
        }
        return cloneable;
    }

    public static final Point getClosestPointOnEdge(Point point, Point point2, Point point3) {
        double d2;
        double d3 = point3.x - point2.x;
        double d4 = point3.y - point2.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = (d3 /= d5) * (double)(point.x - point2.x) + (d4 /= d5) * (double)(point.y - point2.y);
        if (d2 < 0.0) {
            return point2;
        }
        if (d6 > d5) {
            return point3;
        }
        return new Point(point2.x + (int)(d6 * d3), point2.y + (int)(d6 * d4));
    }

    public static final int sqr_distance(Point point, Point point2) {
        return (point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y);
    }

    public static Point getNormPointOnEdge(Point point, Point point2, Point point3) {
        point3 = new Point(point3.x - point2.x, point3.y - point2.y);
        float f2 = (float)((point.x - point2.x) * point3.x + (point.y - point2.y) * point3.y) / (float)(point3.x * point3.x + point3.y * point3.y);
        Point point4 = new Point();
        new Point().x = (int)((float)point.x + ((float)(point2.x - point.x) + f2 * (float)point3.x));
        point4.y = (int)((float)point.y + ((float)(point2.y - point.y) + f2 * (float)point3.y));
        return point4;
    }
}

