/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;

public class FigGroup
extends Fig {
    private static final long serialVersionUID = -6310938507588533546L;
    private List<Fig> figs;
    private int extraFrameSpace = 0;
    private Color textColor = Color.black;
    private Color textFillColor = Color.white;
    private boolean textFilled = false;
    private Font font = new Font("TimesRoman", 0, 10);
    private boolean suppressCalcBounds;

    public FigGroup() {
        this.figs = Collections.synchronizedList(new ArrayList());
    }

    public FigGroup(List<Fig> list) {
        this.figs = Collections.synchronizedList(list);
        this.calcBounds();
    }

    public void parseDynObjects(String string) {
    }

    public void addFig(Fig fig) {
        Fig fig2 = fig.getGroup();
        if (fig2 != this) {
            if (fig2 != null) {
                ((FigGroup)fig2).removeFig(fig);
            }
            this.figs.add(fig);
            fig.setGroup(this);
            this.calcBounds();
        }
    }

    public void addFigs(Collection<Fig> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.addFig((Fig)object.next());
        }
        this.calcBounds();
    }

    public void setFigs(Collection<Fig> collection) {
        this.figs.clear();
        this.addFigs(collection);
    }

    @Override
    public void calcBounds() {
        if (this.suppressCalcBounds) {
            return;
        }
        Rectangle rectangle = null;
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (!fig.isVisible()) continue;
            if (rectangle == null) {
                rectangle = fig.getBounds();
                continue;
            }
            rectangle.add(this.getSubFigBounds(fig));
        }
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height + this.extraFrameSpace;
    }

    protected Rectangle getSubFigBounds(Fig fig) {
        return fig.getBounds();
    }

    @Override
    public Object clone() {
        FigGroup figGroup = (FigGroup)super.clone();
        int n2 = this.figs.size();
        ArrayList<Fig> arrayList = new ArrayList<Fig>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = (Fig)this.figs.get(i2).clone();
            arrayList.add(fig);
            fig.setGroup(figGroup);
        }
        figGroup.figs = arrayList;
        return figGroup;
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this.hitFig(new Rectangle(n2, n3, 0, 0)) != null;
    }

    @Deprecated
    public Iterator iterator() {
        return this.figs.iterator();
    }

    public Fig getFigAt(int n2) {
        return this.figs.get(n2);
    }

    public int getFigCount() {
        return this.figs.size();
    }

    public int getFigPosn(Fig fig) {
        return this.figs.indexOf(fig);
    }

    public List<Fig> getFigs() {
        return Collections.unmodifiableList(this.figs);
    }

    public List<DiagramElement> getDiagramElements() {
        return Collections.unmodifiableList(new ArrayList<Fig>(this.figs));
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontFamily() {
        return this.font.getFamily();
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    @Override
    public String getPrivateData() {
        Fig fig = this.getEnclosingFig();
        if (fig != null) {
            return "enclosingFig=\"" + fig.getId() + "\"";
        }
        return "";
    }

    public int getExtraFrameSpace() {
        return this.extraFrameSpace;
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        return this.hitFig(rectangle) != null;
    }

    public Fig hitFig(Rectangle rectangle) {
        if (!this.isVisible()) {
            return null;
        }
        Fig fig = null;
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig2 = this.figs.get(i2);
            if (!fig2.hit(rectangle)) continue;
            fig = fig2;
        }
        return fig;
    }

    @Override
    public boolean isReshapable() {
        return false;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            for (Fig fig : this.getFigs()) {
                if (!fig.isVisible()) continue;
                fig.paint(graphics);
            }
        }
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<g id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("'");
        this.appendSvgStyle(stringBuffer);
        Iterator<Fig> iterator = this.getFigs().iterator();
        while (iterator.hasNext()) {
            iterator.next().appendSvg(stringBuffer);
        }
        stringBuffer.append("</g>");
    }

    public void removeAll() {
        Rectangle rectangle = this.getBounds();
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figs.get(i2).setGroup(null);
        }
        this.figs.clear();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void removeFig(Fig fig) {
        if (!this.figs.contains(fig)) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        this.figs.remove(fig);
        fig.setGroup(null);
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public Collection getDisplayedFigs(Collection arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Fig>();
        }
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (!fig.isVisible()) continue;
            arrayList.add(fig);
        }
        return arrayList;
    }

    @Override
    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        int n6 = this.figs.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            Fig fig = this.figs.get(i2);
            if (!fig.isVisible()) continue;
            int n7 = this._w == 0 ? 0 : fig.getWidth() * n4 / this._w;
            int n8 = this._h == 0 ? 0 : fig.getHeight() * n5 / this._h;
            int n9 = this._w == 0 ? n2 : n2 + (fig.getX() - this._x) * n4 / this._w;
            int n10 = this._h == 0 ? n3 : n3 + (fig.getY() - this._y) * n5 / this._h;
            fig.setBoundsImpl(n9, n10, n7, n8);
        }
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void setFigs(List<Fig> list) {
        Rectangle rectangle = this.getBounds();
        this.figs = new ArrayList<Fig>(list);
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    @Override
    public void setFillColor(Color color) {
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figs.get(i2).setFillColor(color);
        }
        super.setFillColor(color);
    }

    @Override
    public void setFilled(boolean bl2) {
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figs.get(i2).setFilled(bl2);
        }
        super.setFilled(bl2);
    }

    public void setFont(Font font) {
        this.firePropChange("font", this.font, font);
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (fig instanceof FigText) {
                ((FigText)fig).setFont(font);
                continue;
            }
            if (!(fig instanceof FigGroup)) continue;
            ((FigGroup)fig).setFont(font);
        }
        this.font = font;
    }

    public void setFontFamily(String object) {
        object = new Font((String)object, this.font.getStyle(), this.font.getSize());
        this.setFont((Font)object);
    }

    public void setFontSize(int n2) {
        Font font = new Font(this.font.getFamily(), this.font.getStyle(), n2);
        this.setFont(font);
    }

    @Override
    public void setLineColor(Color color) {
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figs.get(i2).setLineColor(color);
        }
        super.setLineColor(color);
    }

    @Override
    public void setLineWidth(int n2) {
        int n3 = this.figs.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.figs.get(i2).setLineWidth(n2);
        }
        super.setLineWidth(n2);
    }

    @Override
    public void setPrivateData(String object) {
        object = new StringTokenizer((String)object, "=\"' ");
        while (((StringTokenizer)object).hasMoreTokens()) {
            if (!((StringTokenizer)object).nextToken().equals("enclosingFig")) continue;
            Integer.parseInt(((StringTokenizer)object).nextToken());
        }
    }

    public void setTextColor(Color color) {
        this.firePropChange("textColor", this.textColor, color);
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (fig instanceof FigText) {
                ((FigText)fig).setTextColor(color);
                continue;
            }
            if (!(fig instanceof FigGroup)) continue;
            ((FigGroup)fig).setTextColor(color);
        }
        this.textColor = color;
    }

    public void setTextFillColor(Color color) {
        this.firePropChange("textFillColor", this.textFillColor, color);
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (fig instanceof FigText) {
                ((FigText)fig).setTextFillColor(color);
                continue;
            }
            if (!(fig instanceof FigGroup)) continue;
            ((FigGroup)fig).setTextFillColor(color);
        }
        this.textFillColor = color;
    }

    public void setTextFilled(boolean bl2) {
        this.firePropChange("textFilled", this.textFilled, bl2);
        int n2 = this.figs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.figs.get(i2);
            if (fig instanceof FigText) {
                ((FigText)fig).setTextFilled(bl2);
                continue;
            }
            if (!(fig instanceof FigGroup)) continue;
            ((FigGroup)fig).setTextFilled(bl2);
        }
        this.textFilled = bl2;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public boolean getTextFilled() {
        return this.textFilled;
    }

    public void setExtraFrameSpace(int n2) {
        this.extraFrameSpace = n2;
    }

    @Override
    protected void translateImpl(int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        int n4 = this.figs.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.figs.get(i2).translate(n2, n3);
        }
        this._x += n2;
        this._y += n3;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public Fig deepSelect(Rectangle rectangle) {
        return this;
    }
}

