/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;

public class FigLine
extends Fig {
    private static final long serialVersionUID = -6961837549764335095L;
    protected int _x1;
    protected int _y1;
    protected int _x2;
    protected int _y2;

    public FigLine(int n2, int n3, int n4, int n5, Color color) {
        this.setX1(n2);
        this.setY1(n3);
        this.setX2(n4);
        this.setY2(n5);
        this.setLineColor(color);
        this.calcBounds();
    }

    public FigLine(int n2, int n3, int n4, int n5) {
        this.setX1(n2);
        this.setY1(n3);
        this.setX2(n4);
        this.setY2(n5);
        this.calcBounds();
    }

    public FigLine() {
        this.setX1(0);
        this.setY1(0);
        this.setX2(0);
        this.setY2(10);
        this.calcBounds();
    }

    public final void setShape(Point point, Point point2) {
        this.setShape(point.x, point.y, point2.x, point2.y);
    }

    public void setShape(int n2, int n3, int n4, int n5) {
        this._x1 = n2;
        this._y1 = n3;
        this._x2 = n4;
        this._y2 = n5;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public int getX1() {
        return this._x1;
    }

    public int getY1() {
        return this._y1;
    }

    public int getX2() {
        return this._x2;
    }

    public int getY2() {
        return this._y2;
    }

    public void setX1(int n2) {
        this._x1 = n2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY1(int n2) {
        this._y1 = n2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setX2(int n2) {
        this._x2 = n2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY2(int n2) {
        this._y2 = n2;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isReshapable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    public void setPoints(Point[] pointArray) {
        if (pointArray.length != 2) {
            throw new IllegalArgumentException("FigLine must have exactly 2 points");
        }
        this._x1 = pointArray[0].x;
        this._y1 = pointArray[0].y;
        this._x2 = pointArray[1].x;
        this._y2 = pointArray[1].y;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point[] getPoints() {
        Point[] pointArray = new Point[2];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(this._x1, this._y1);
        pointArray2[1] = new Point(this._x2, this._y2);
        return pointArray2;
    }

    public void setPoints(int n2, int n3, int n4) {
        if (n2 == 0) {
            this._x1 = n3;
            this._y1 = n4;
        } else if (n2 == 1) {
            this._x2 = n3;
            this._y2 = n4;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public void setPoint(int n2, int n3, int n4) {
        if (n2 == 0) {
            this._x1 = n3;
            this._y1 = n4;
        } else if (n2 == 1) {
            this._x2 = n3;
            this._y2 = n4;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point getPoint(int n2) {
        if (n2 == 0) {
            return new Point(this._x1, this._y1);
        }
        if (n2 == 1) {
            return new Point(this._x2, this._y2);
        }
        throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
    }

    @Override
    public int getNumPoints() {
        return 2;
    }

    @Override
    public int[] getXs() {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = this._x1;
        nArray2[1] = this._x2;
        return nArray2;
    }

    @Override
    public int[] getYs() {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = this._y1;
        nArray2[1] = this._y2;
        return nArray2;
    }

    @Override
    public int getPerimeterLength() {
        int n2 = (this._x2 - this._x1) * (this._x2 - this._x1);
        int n3 = (this._y2 - this._y1) * (this._y2 - this._y1);
        return (int)Math.sqrt(n2 + n3);
    }

    @Override
    public void stuffPointAlongPerimeter(int n2, Point point) {
        int n3 = this.getPerimeterLength();
        if (n2 <= 0) {
            point.x = this._x1;
            point.y = this._y1;
            return;
        }
        if (n2 >= n3) {
            point.x = this._x2;
            point.y = this._y2;
            return;
        }
        point.x = this._x1 + (this._x2 - this._x1) * n2 / n3;
        point.y = this._y1 + (this._y2 - this._y1) * n2 / n3;
    }

    @Override
    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        this._x1 = this._w == 0 ? n2 : n2 + (this._x1 - this._x) * n4 / this._w;
        this._y1 = this._h == 0 ? n3 : n3 + (this._y1 - this._y) * n5 / this._h;
        this._x2 = this._w == 0 ? n2 : n2 + (this._x2 - this._x) * n4 / this._w;
        this._y2 = this._h == 0 ? n3 : n3 + (this._y2 - this._y) * n5 / this._h;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public Point connectionPoint(Point point) {
        return Geometry.ptClosestTo(this._x1, this._y1, this._x2, this._y2, point);
    }

    @Override
    protected void translateImpl(int n2, int n3) {
        this._x1 += n2;
        this._y1 += n3;
        this._x2 += n2;
        this._y2 += n3;
        this._x += n2;
        this._y += n3;
        this.firePropChange("bounds", null, null);
    }

    @Override
    public void calcBounds() {
        if (this._x1 < this._x2) {
            this._x = this._x1;
            this._w = this._x2 - this._x1;
        } else {
            this._x = this._x2;
            this._w = this._x1 - this._x2;
        }
        if (this._y1 < this._y2) {
            this._y = this._y1;
            this._h = this._y2 - this._y1;
            return;
        }
        this._y = this._y2;
        this._h = this._y1 - this._y2;
    }

    @Override
    public void paint(Graphics graphics) {
        int n2 = this.getLineWidth();
        Color color = this.getLineColor();
        boolean bl2 = this.getDashed();
        if (n2 <= 0) {
            return;
        }
        graphics.setColor(color);
        if (bl2) {
            this.drawDashedLine(graphics, n2, this._x1, this._y1, this._x2, this._y2, 0, this._dashes, this._dashPeriod);
            return;
        }
        if (graphics instanceof Graphics2D) {
            graphics = (Graphics2D)graphics;
            this.drawDashedLine(graphics, n2, this._x1, this._y1, this._x2, this._y2, 0, null, 1);
            return;
        }
        graphics.drawLine(this._x1, this._y1, this._x2, this._y2);
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<line id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("'");
        this.appendSvgStyle(stringBuffer);
        stringBuffer.append(" x1 = '").append(this.getX1()).append("' y1 = '").append(this.getY1()).append("' x2 = '").append(this.getX2()).append("' y2 = '").append(this.getY2()).append("' />");
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        return this.intersects(rectangle);
    }

    @Override
    public void createDrag(int n2, int n3, int n4, int n5, int n6, int n7) {
        this._x2 = n6;
        this._y2 = n7;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    @Override
    public boolean intersectsPerimeter(Rectangle rectangle) {
        return this.intersects(rectangle);
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersectsLine(this._x1, this._y1, this._x2, this._y2);
    }
}

