/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Connector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.ui.Highlightable;
import org.tigris.gef.undo.UndoManager;

public class FigNode
extends FigGroup
implements MouseListener,
GraphNode,
Highlightable {
    private static final long serialVersionUID = 5312194520189613781L;
    private static final Log LOG = LogFactory.getLog(FigNode.class);
    private static final LookupOp SHADOW_LOOKUP_OP;
    private static final ConvolveOp SHADOW_CONVOLVE_OP;
    private BufferedImage shadowImage;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private List<Connector> connectors = new ArrayList<Connector>();
    private boolean forceRepaint;
    protected static final int SHADOW_COLOR_VALUE = 32;
    protected static final int SHADOW_COLOR_ALPHA = 128;
    public static final double ang45 = 0.7853981633974483;
    public static final double ang135 = 2.356194490192345;
    public static final double ang225 = 3.9269908169872414;
    public static final double ang315 = 5.497787143782138;
    protected boolean _blinkPorts = false;
    protected boolean _highlight = false;
    private ArrayList<FigEdge> figEdges = new ArrayList();
    private int shadowSize = 0;

    public FigNode() {
    }

    public FigNode(Object object) {
        this.setOwner(object);
    }

    public FigNode(Object object, Collection collection) {
        this(object);
        this.setFigs(collection);
    }

    public boolean isDragConnectable() {
        return true;
    }

    @Override
    public Object clone() {
        FigNode figNode = (FigNode)super.clone();
        ((FigNode)super.clone()).figEdges = (ArrayList)this.figEdges.clone();
        return figNode;
    }

    public void setBlinkPorts(boolean bl2) {
        this._blinkPorts = bl2;
        this.hidePorts();
    }

    public boolean isBlinkPorts() {
        return this._blinkPorts;
    }

    public void addFigEdge(FigEdge figEdge) {
        this.figEdges.add(figEdge);
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
        Fig fig = (Fig)((Object)connector);
        Point point = new Point(fig.getX() + fig.getHalfWidth(), fig.getY() + fig.getHalfHeight());
        point = this.getClosestPoint(point);
        fig.setLocation(point.x - fig.getHalfWidth(), point.y - fig.getHalfHeight());
        connector.setGraphNode(this);
    }

    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    public void removeFigEdge(FigEdge figEdge) {
        this.figEdges.remove(figEdge);
    }

    public Collection<FigEdge> getFigEdges(Collection<FigEdge> collection) {
        if (collection == null) {
            return this.figEdges;
        }
        collection.addAll(this.figEdges);
        return collection;
    }

    public List<FigEdge> getFigEdges() {
        return (List)this.figEdges.clone();
    }

    @Override
    public List<GraphEdge> getGraphEdges() {
        return (List)this.figEdges.clone();
    }

    @Override
    public void setOwner(Object object) {
        Object object2 = this.getOwner();
        if (object2 instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object2).removePropertyChangeListener(this);
        } else if (object2 instanceof Highlightable) {
            ((Highlightable)object2).removePropertyChangeListener(this);
        }
        if (object instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object).addPropertyChangeListener(this);
        } else if (object instanceof Highlightable) {
            ((Highlightable)object).addPropertyChangeListener(this);
        }
        super.setOwner(object);
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        int n2 = this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this._filled) {
            return n2 > 0;
        }
        return n2 > 0 && n2 < 4;
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this._x <= n2 && n2 <= this._x + this._w && this._y <= n3 && n3 <= this._y + this._h;
    }

    @Override
    public void setEnclosingFig(Fig fig) {
        if (fig != null && fig != this.getEnclosingFig() && this.getLayer() != null) {
            int n2 = this.figEdges.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FigEdge figEdge = this.figEdges.get(i2);
                this.getLayer().bringInFrontOf(figEdge, fig);
            }
        }
        super.setEnclosingFig(fig);
    }

    @Override
    public void endTrans() {
        int n2 = this.figEdges.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figEdges.get(i2).endTrans();
        }
        super.endTrans();
    }

    @Override
    public void removeFromDiagram() {
        while (this.figEdges.size() > 0) {
            this.figEdges.get(this.figEdges.size() - 1).removeFromDiagram();
        }
        super.removeFromDiagram();
    }

    @Override
    public void deleteFromModel() {
        LOG.debug((Object)"Deleting FigNode from model");
        for (int i2 = this.figEdges.size() - 1; i2 >= 0; --i2) {
            this.figEdges.get(i2).deleteFromModel();
        }
        super.deleteFromModel();
    }

    public void dispose() {
        this.deleteFromModel();
    }

    public void bindPort(Object object, Fig fig) {
        Fig fig2 = this.getPortFig(object);
        if (fig2 != null) {
            fig2.setOwner(null);
        }
        fig.setOwner(object);
    }

    public void removePort(Fig fig) {
        if (fig.getOwner() != null) {
            fig.setOwner(null);
        }
    }

    public final Object hitPort(Point point) {
        return this.hitPort(point.x, point.y);
    }

    public Object hitPort(int n2, int n3) {
        Fig fig = this.hitFig(new Rectangle(n2, n3, 1, 1));
        if (fig != null) {
            return fig.getOwner();
        }
        return null;
    }

    public Object deepHitPort(int n2, int n3) {
        Object object;
        int n4 = this.getFigCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            Fig fig = this.getFigAt(i2);
            object = fig.getOwner();
            if (!fig.contains(n2, n3) || object == null) continue;
            return object;
        }
        Rectangle rectangle = new Rectangle(n2 - 16, n3 - 16, 32, 32);
        for (int i3 = 0; i3 < n4; ++i3) {
            object = this.getFigAt(i3);
            Object object2 = ((Fig)object).getOwner();
            if (!((Fig)object).hit(rectangle) || object2 == null) continue;
            return object2;
        }
        return null;
    }

    public Fig getPortFig(Object object) {
        int n2 = this.getFigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.getFigAt(i2);
            if (fig.getOwner() != object) continue;
            return fig;
        }
        return null;
    }

    public List getPortFigs() {
        ArrayList<Fig> arrayList = new ArrayList<Fig>();
        int n2 = this.getFigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.getFigAt(i2);
            if (!this.isPortFig(fig)) continue;
            arrayList.add(fig);
        }
        return arrayList;
    }

    private boolean isPortFig(Fig fig) {
        boolean bl2 = fig.getOwner() != null;
        if (bl2 && this.getOwner() instanceof GraphNodeHooks) {
            bl2 = fig.getOwner() instanceof GraphPortHooks;
        }
        return bl2;
    }

    public int getPortSector(Fig cloneable) {
        Rectangle rectangle = this.getBounds();
        cloneable = cloneable.getBounds();
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.y + rectangle.height / 2;
        int n4 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width / 2;
        int n5 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height / 2;
        n2 = n4 - n2;
        n5 -= n3;
        n3 = -1;
        if (Math.abs(n5 * rectangle.width) > Math.abs(rectangle.height * n2)) {
            if (n5 > 0) {
                n3 = 1;
            }
        } else {
            n3 = 2;
            if (n2 > 0) {
                n3 = -2;
            }
        }
        return n3;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.shadowSize > 0 && graphics instanceof Graphics2D) {
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = this.getX();
            int n5 = this.getY();
            if (n2 != this.cachedWidth || n3 != this.cachedHeight || this.forceRepaint) {
                this.forceRepaint = false;
                this.cachedWidth = n2;
                this.cachedHeight = n3;
                BufferedImage bufferedImage = new BufferedImage(n2 + 100, n3 + 100, 2);
                Graphics graphics2 = bufferedImage.getGraphics();
                graphics2.translate(50 - n4, 50 - n5);
                this.paintOnce(graphics2);
                this.shadowImage = SHADOW_CONVOLVE_OP.filter(SHADOW_LOOKUP_OP.filter(bufferedImage, null), null);
            }
            ((Graphics2D)graphics).drawImage(this.shadowImage, null, n4 + this.shadowSize - 50, n5 + this.shadowSize - 50);
        }
        this.paintOnce(graphics);
    }

    private void paintOnce(Graphics graphics) {
        super.paint(graphics);
        if (this._highlight) {
            Color color = Globals.getPrefs().getHighlightColor();
            this.drawRect(graphics, false, null, 3, color, this._x - 5, this._y - 5, this._w + 9, this._h + 8, false, this._dashes, this._dashPeriod);
        }
    }

    @Override
    public void setHighlight(boolean bl2) {
        this._highlight = bl2;
        this.damage();
    }

    @Override
    public boolean getHighlight() {
        return this._highlight;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("disposed") && object == this.getOwner()) {
            this.removeFromDiagram();
        }
        if (string.equals("highlight") && object == this.getOwner()) {
            this.setHighlight((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public void showPorts() {
        int n2 = this.getFigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.getFigAt(i2);
            if (fig.getOwner() == null) continue;
            fig.setLineWidth(1);
            fig.setFilled(true);
        }
        this.endTrans();
    }

    public void hidePorts() {
        int n2 = this.getFigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.getFigAt(i2);
            if (fig.getOwner() == null) continue;
            fig.setLineWidth(0);
            fig.setFilled(false);
        }
        this.endTrans();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._blinkPorts) {
            this.showPorts();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._blinkPorts) {
            this.hidePorts();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    protected void translateImpl(int n2, int n3) {
        super.translateImpl(n2, n3);
        this.updateEdges();
    }

    public void superTranslate(int n2, int n3) {
        super.translate(n2, n3);
    }

    @Override
    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        super.setBoundsImpl(n2, n3, n4, n5);
        this.updateEdges();
    }

    public void updateEdges() {
        if (!UndoManager.getInstance().isUndoInProgress()) {
            int n2 = this.figEdges.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.figEdges.get(i2).computeRoute();
            }
        }
    }

    @Override
    public void cleanUp() {
        int n2 = this.figEdges.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.figEdges.get(i2).cleanUp();
        }
    }

    public List<? extends Fig> getDragDependencies() {
        return null;
    }

    public List<Connector> getConnectors() {
        return this.connectors;
    }

    public void setShadowSize(int n2) {
        if (n2 == this.shadowSize) {
            return;
        }
        MutableGraphSupport.enableSaveAction();
        this.shadowSize = n2;
    }

    protected void setShadowSizeFriend(int n2) {
        if (n2 == this.shadowSize) {
            return;
        }
        this.shadowSize = n2;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void forceRepaintShadow() {
        this.forceRepaint = true;
    }

    @Override
    public Rectangle getNodeBounds() {
        return this.getBounds();
    }

    static {
        byte[][] byArray = new byte[4][256];
        for (int i2 = 1; i2 < 256; ++i2) {
            byArray[0][i2] = 32;
            byArray[1][i2] = 32;
            byArray[2][i2] = 32;
            byArray[3][i2] = -128;
        }
        float[] fArray = new float[9];
        for (int i3 = 0; i3 < 9; ++i3) {
            fArray[i3] = 0.083333336f;
        }
        SHADOW_LOOKUP_OP = new LookupOp(new ByteLookupTable(0, byArray), null);
        SHADOW_CONVOLVE_OP = new ConvolveOp(new Kernel(3, 3, fArray));
    }
}

