/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public class FigPoly
extends Fig {
    private static final float MITER_LIMIT = 10.0f;
    private static final long serialVersionUID = -4809619139509617929L;
    private static final double FUDGEFACTOR = 7.0;
    protected int _npoints = 0;
    protected int[] _xpoints = new int[4];
    protected int[] _ypoints = new int[4];
    protected boolean _rectilinear = false;
    public boolean _isComplete = false;
    protected boolean _isSelfLoop = false;
    protected int _fixedHandles = -1;
    private static Handle _TempHandle = new Handle(0);

    public FigPoly(Color color) {
        this.setLineColor(color);
    }

    public FigPoly(Color color, Color color2) {
        this.setLineColor(color);
        this.setFillColor(color2);
    }

    public FigPoly() {
    }

    public FigPoly(int n2, int n3) {
        this();
        this.addPoint(n2, n3);
    }

    @Override
    public Object clone() {
        FigPoly figPoly = (FigPoly)super.clone();
        ((FigPoly)super.clone())._xpoints = (int[])this._xpoints.clone();
        figPoly._ypoints = (int[])this._ypoints.clone();
        return figPoly;
    }

    public Polygon getPolygon() {
        return new Polygon(this._xpoints, this._ypoints, this._npoints);
    }

    public void setPolygon(Polygon polygon) {
        this._npoints = polygon.npoints;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        System.arraycopy(polygon.xpoints, 0, this._xpoints, 0, this._npoints);
        System.arraycopy(polygon.ypoints, 0, this._ypoints, 0, this._npoints);
        this.calcBounds();
    }

    public void setSelfLoop(boolean bl2) {
        this._isSelfLoop = bl2;
    }

    @Override
    public int getNumPoints() {
        return this._npoints;
    }

    public boolean getRectilinear() {
        return this._rectilinear;
    }

    public void setRectilinear(boolean bl2) {
        this._rectilinear = bl2;
    }

    public int getFixedHandles() {
        return this._fixedHandles;
    }

    public void setFixedHandles(int n2) {
        this._fixedHandles = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndPoints(Point point, Point point2) {
        while (this._npoints < 2) {
            this.addPoint(point);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigPoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, point.x, point.y, true);
            FigPoly._TempHandle.index = this._npoints - 1;
            this.moveVertex(_TempHandle, point2.x, point2.y, true);
            return;
        }
    }

    @Override
    protected void translateImpl(int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        int n4 = 0;
        while (n4 < this._npoints) {
            int n5 = n4;
            this._xpoints[n5] = this._xpoints[n5] + n2;
            int n6 = n4++;
            this._ypoints[n6] = this._ypoints[n6] + n3;
        }
        this._x += n2;
        this._y += n3;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    @Override
    public void addPoint(int n2, int n3) {
        this.growIfNeeded();
        this._xpoints[this._npoints] = n2;
        this._ypoints[this._npoints] = n3;
        ++this._npoints;
        Rectangle rectangle = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public final void addPoint(Point point) {
        this.addPoint(point.x, point.y);
    }

    protected boolean canMoveVertex(int n2, boolean bl2) {
        return n2 >= 0 && n2 < this._npoints && (bl2 || n2 >= this._fixedHandles && n2 < this._npoints - this._fixedHandles);
    }

    public void moveVertex(Handle object, int n2, int n3, boolean bl2) {
        int n4 = ((Handle)object).index;
        if (!this._rectilinear) {
            this._xpoints[n4] = n2;
            this._ypoints[n4] = n3;
        } else {
            if (bl2) {
                this._xpoints[n4] = n2;
                this._ypoints[n4] = n3;
            }
            if (n4 == this._fixedHandles) {
                this.prependTwoPoints();
                ((Handle)object).index += 2;
                n4 += 2;
            }
            if (n4 == this._npoints - this._fixedHandles - 1) {
                this.appendTwoPoints();
            }
            if (n4 % 2 == 0) {
                if (this.canMoveVertex(n4 - 1, bl2)) {
                    this._xpoints[n4 - 1] = n2;
                    this._xpoints[n4] = n2;
                }
                if (this.canMoveVertex(n4 + 1, bl2)) {
                    this._ypoints[n4 + 1] = n3;
                    this._ypoints[n4] = n3;
                }
            } else {
                if (this.canMoveVertex(n4 - 1, bl2)) {
                    this._ypoints[n4 - 1] = n3;
                    this._ypoints[n4] = n3;
                }
                if (this.canMoveVertex(n4 + 1, bl2)) {
                    this._xpoints[n4 + 1] = n2;
                    this._xpoints[n4] = n2;
                }
            }
        }
        object = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", object, this.getBounds());
    }

    protected void prependTwoPoints() {
        int[] nArray = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, nArray, 2, this._npoints);
        this._xpoints = nArray;
        nArray = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, nArray, 2, this._npoints);
        this._ypoints = nArray;
        this._xpoints[0] = this._xpoints[1] = this._xpoints[2];
        this._ypoints[0] = this._ypoints[1] = this._ypoints[2];
        this._npoints += 2;
    }

    protected void appendTwoPoints() {
        int[] nArray = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
        this._xpoints = nArray;
        nArray = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
        this._ypoints = nArray;
        this._xpoints[this._npoints + 1] = this._xpoints[this._npoints] = this._xpoints[this._npoints - 1];
        this._ypoints[this._npoints + 1] = this._ypoints[this._npoints] = this._ypoints[this._npoints - 1];
        this._npoints += 2;
    }

    @Override
    public void removePoint(int n2) {
        if (n2 < 0 || n2 >= this._npoints) {
            throw new IllegalArgumentException("Point not found in LayerDiagram");
        }
        if (this._npoints < 3) {
            return;
        }
        int[] nArray = new int[this._npoints];
        if (this._rectilinear && n2 != 0 && n2 != this._npoints - 1) {
            if (n2 % 2 == 0) {
                this._xpoints[n2] = this._xpoints[n2 + 1];
                this._ypoints[n2] = this._ypoints[n2 - 1];
            } else {
                this._xpoints[n2] = this._xpoints[n2 - 1];
                this._ypoints[n2] = this._ypoints[n2 + 1];
            }
        } else {
            System.arraycopy(this._xpoints, n2 + 1, nArray, 0, this._npoints - n2 - 1);
            System.arraycopy(nArray, 0, this._xpoints, n2, this._npoints - n2 - 1);
            System.arraycopy(this._ypoints, n2 + 1, nArray, 0, this._npoints - n2 - 1);
            System.arraycopy(nArray, 0, this._ypoints, n2, this._npoints - n2 - 1);
            --this._npoints;
        }
        Rectangle rectangle = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    @Override
    public void insertPoint(int n2, int n3, int n4) {
        this.growIfNeeded();
        int[] nArray = new int[this._npoints];
        System.arraycopy(this._xpoints, n2 + 1, nArray, 0, this._npoints - n2 - 1);
        this._xpoints[n2 + 1] = n3;
        System.arraycopy(nArray, 0, this._xpoints, n2 + 2, this._npoints - n2 - 1);
        System.arraycopy(this._ypoints, n2 + 1, nArray, 0, this._npoints - n2 - 1);
        this._ypoints[n2 + 1] = n4;
        System.arraycopy(nArray, 0, this._ypoints, n2 + 2, this._npoints - n2 - 1);
        ++this._npoints;
        this.calcBounds();
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] nArray = new int[this._npoints << 1];
            System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
            this._xpoints = nArray;
            nArray = new int[this._npoints << 1];
            System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
            this._ypoints = nArray;
        }
    }

    @Override
    public Point getPoint(int n2) {
        return new Point(this._xpoints[n2], this._ypoints[n2]);
    }

    public List<Point> getPointsList() {
        ArrayList<Point> arrayList = new ArrayList<Point>(this._npoints);
        for (int i2 = 0; i2 < this._npoints; ++i2) {
            arrayList.add(new Point(this._xpoints[i2], this._ypoints[i2]));
        }
        return arrayList;
    }

    @Override
    public Point[] getPoints() {
        Point[] pointArray = new Point[this.getPointsList().size()];
        for (int i2 = 0; i2 < this._npoints; ++i2) {
            pointArray[i2] = this.getPoint(i2);
        }
        return pointArray;
    }

    @Override
    public Point getFirstPoint() {
        return this.getPoint(0);
    }

    @Override
    public Point getLastPoint() {
        return this.getPoint(this._npoints - 1);
    }

    @Override
    public void setPoint(Handle handle, int n2, int n3) {
        this.moveVertex(handle, n2, n3, false);
    }

    @Override
    public void setPoints(Point[] pointArray) {
        this._npoints = pointArray.length;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        for (int i2 = 0; i2 < this._npoints; ++i2) {
            this._xpoints[i2] = pointArray[i2].x;
            this._ypoints[i2] = pointArray[i2].y;
        }
        this.calcBounds();
    }

    @Override
    public void cleanUp() {
        for (int i2 = 1; i2 < this._npoints - 1; ++i2) {
            double d2;
            Point point = new Point(this._xpoints[i2 - 1], this._ypoints[i2 - 1]);
            Point point2 = new Point(this._xpoints[i2], this._ypoints[i2]);
            Point point3 = new Point(this._xpoints[i2 + 1], this._ypoints[i2 + 1]);
            if (point.equals(point2) || point3.equals(point2)) {
                this.removePoint(i2);
                break;
            }
            double d3 = Geometry.segmentAngle(point, point2);
            if (!(Geometry.diffAngle(d3, d2 = Geometry.segmentAngle(point2, point3)) < 7.0)) continue;
            this.removePoint(i2);
        }
        this.calcBounds();
    }

    @Override
    public Point getClosestPoint(Point point) {
        return Geometry.ptClosestTo(this._xpoints, this._ypoints, this._npoints, point);
    }

    @Override
    public List getGravityPoints() {
        return this.getPointsList();
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        if (this._filled && this._fillColor != null) {
            if (graphics instanceof Graphics2D) {
                object = (Graphics2D)graphics;
                Polygon polygon = new Polygon(this.getXs(), this.getYs(), this.getNumPoints());
                Rectangle rectangle = polygon.getBounds();
                Paint paint = ((Graphics2D)object).getPaint();
                ((Graphics2D)object).setPaint(this.getDefaultPaint(this._fillColor, this._lineColor, rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                ((Graphics2D)object).fill(polygon);
                ((Graphics2D)object).setPaint(paint);
            } else {
                graphics.setColor(this._fillColor);
                graphics.fillPolygon(this._xpoints, this._ypoints, this._npoints);
            }
        }
        if (this.getLineWidth() > 0 && this._lineColor != null) {
            graphics.setColor(this._lineColor);
            if (graphics instanceof Graphics2D) {
                object = null;
                if (this.getDashed()) {
                    object = this._dashes;
                }
                this.drawPolyLine((Graphics2D)graphics, this.getLineWidth(), this._npoints, this._xpoints, this._ypoints, (float[])object, 0.0f);
                return;
            }
            if (this.getDashed()) {
                this.drawDashedPerimeter(graphics, this.getLineWidth(), this._npoints, this._xpoints, this._ypoints, this._dashes, this._dashPeriod);
                return;
            }
            graphics.drawPolyline(this._xpoints, this._ypoints, this._npoints);
        }
    }

    private void drawDashedPerimeter(Graphics graphics, int n2, int n3, int[] nArray, int[] nArray2, float[] fArray, int n4) {
        if (graphics instanceof Graphics2D) {
            this.drawPolyLine((Graphics2D)graphics, n2, n3, nArray, nArray2, fArray, 0.0f);
            return;
        }
        int n5 = 0;
        for (int i2 = 1; i2 < n3; ++i2) {
            n5 = this.drawDashedLine(graphics, n2, nArray[i2 - 1], nArray2[i2 - 1], nArray[i2], nArray2[i2], n5, fArray, n4);
        }
    }

    private void drawPolyLine(Graphics2D graphics2D, float f2, int n2, int[] nArray, int[] nArray2, float[] fArray, float f3) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            generalPath.lineTo(nArray[i2], nArray2[i2]);
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.getDefaultStroke(f2, fArray, f3));
        graphics2D.draw(generalPath);
        graphics2D.setStroke(stroke);
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<path id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("' style='fill:none; stroke-width:").append(this.getLineWidth()).append("; stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(',').append(this.getLineColor().getBlue()).append(" ;' d='");
        for (int i2 = 0; i2 < this.getPoints().length; ++i2) {
            if (i2 == 0) {
                stringBuffer.append("M ");
            } else {
                stringBuffer.append("L ");
            }
            stringBuffer.append(this.getPoint((int)i2).x).append(',').append(this.getPoint((int)i2).y);
        }
        stringBuffer.append(" ' />");
    }

    protected int findHandle(int n2, int n3) {
        int[] nArray = this._xpoints;
        int[] nArray2 = this._ypoints;
        for (int i2 = 0; i2 < this._npoints; ++i2) {
            if (n2 < nArray[i2] - 3 || n3 < nArray2[i2] - 3 || n2 > nArray[i2] + 3 || n3 > nArray2[i2] + 3) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this.getPolygon().contains(n2, n3);
    }

    @Override
    public int[] getXs() {
        return this._xpoints;
    }

    @Override
    public int[] getYs() {
        return this._ypoints;
    }

    @Override
    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        if (n4 > 0 && n5 > 0) {
            for (int i2 = 0; i2 < this._npoints; ++i2) {
                this._xpoints[i2] = n2 + (this._xpoints[i2] - this._x) * n4 / this._w;
                this._ypoints[i2] = n3 + (this._ypoints[i2] - this._y) * n5 / this._h;
            }
            this._x = n2;
            this._y = n3;
            this._w = n4;
            this._h = n5;
            this.firePropChange("bounds", rectangle, this.getBounds());
        }
    }

    @Override
    public int getPerimeterLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this._npoints - 1; ++i2) {
            int n3 = this._xpoints[i2 + 1] - this._xpoints[i2];
            int n4 = this._ypoints[i2 + 1] - this._ypoints[i2];
            n2 += (int)Math.sqrt(n3 * n3 + n4 * n4);
        }
        return n2;
    }

    @Override
    public void stuffPointAlongPerimeter(int n2, Point point) {
        for (int i2 = 0; i2 < this._npoints - 1; ++i2) {
            int n3 = this._xpoints[i2 + 1] - this._xpoints[i2];
            int n4 = this._ypoints[i2 + 1] - this._ypoints[i2];
            int n5 = (int)Math.sqrt(n3 * n3 + n4 * n4);
            if (n2 < n5) {
                if (n5 != 0) {
                    point.x = this._xpoints[i2] + n3 * n2 / n5;
                    point.y = this._ypoints[i2] + n4 * n2 / n5;
                    return;
                }
                point.x = this._xpoints[i2];
                point.y = this._ypoints[i2];
                return;
            }
            n2 -= n5;
        }
        point.x = this._xpoints[0];
        point.y = this._ypoints[0];
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean isReshapable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    public boolean isPerimeterClosed() {
        if (this._xpoints.length <= 0 || this._npoints <= 0) {
            return false;
        }
        if (this._npoints <= this._xpoints.length) {
            return this._xpoints[0] == this._xpoints[this._npoints - 1] && this._ypoints[0] == this._ypoints[this._npoints - 1];
        }
        return this._xpoints[0] == this._xpoints[this._xpoints.length - 1] && this._ypoints[0] == this._ypoints[this._ypoints.length - 1];
    }

    public boolean isComplete() {
        return this._isComplete;
    }

    public void setComplete(boolean bl2) {
        this._isComplete = bl2;
    }

    @Override
    protected int countCornersContained(int n2, int n3, int n4, int n5) {
        if (!this.isPerimeterClosed()) {
            return 0;
        }
        Polygon polygon = this.getPolygon();
        int n6 = 0;
        if (polygon.contains(n2, n3)) {
            ++n6;
        }
        if (polygon.contains(n2 + n4, n3)) {
            ++n6;
        }
        if (polygon.contains(n2, n3 + n5)) {
            ++n6;
        }
        if (polygon.contains(n2 + n4, n3 + n5)) {
            ++n6;
        }
        return n6;
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        if (super.hit(rectangle)) {
            return true;
        }
        return this.intersectsPerimeter(rectangle);
    }

    @Override
    public boolean intersectsPerimeter(Rectangle rectangle) {
        for (int i2 = 1; i2 < this._npoints; ++i2) {
            if (!rectangle.intersectsLine(this._xpoints[i2 - 1], this._ypoints[i2 - 1], this._xpoints[i2], this._ypoints[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcBounds() {
        Rectangle rectangle = this.getPolygon().getBounds();
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height;
    }
}

