/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.persistence.export.FontUtility;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText$1;
import org.tigris.gef.presentation.FigTextEditor;
import org.tigris.gef.presentation.TextEditor;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.undo.UndoManager;

public class FigText
extends Fig
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 4659312817576456477L;
    public static final int IGNORE = 0;
    public static final int INSERT = 1;
    public static final int END_EDITING = 2;
    private int returnAction = 0;
    private int tabAction = 0;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int MIN_TEXT_WIDTH = 30;
    private static final char HARD_RETURN = '\n';
    private static final char SOFT_RETURN = '\r';
    private Font _font = new Font("TimesRoman", 0, 10);
    private transient FontMetrics _fm;
    private int _lineHeight;
    private Color _textColor = Color.black;
    private Color textFillColor = Color.white;
    private boolean _textFilled = false;
    private boolean editable = true;
    private Class _textEditorClass = FigTextEditor.class;
    private boolean _underline = false;
    private boolean wordWrap = false;
    private int _lineSpacing = 0;
    private int _topMargin = 0;
    private int _botMargin = 0;
    private int _leftMargin = 0;
    private int _rightMargin = 0;
    private boolean _expandOnly = false;
    private boolean _editMode = false;
    private int _justification = 0;
    private String _curText;
    private String lineSeparator;
    private TextEditor textEditor;
    private static TextEditor activeTextEditor;
    private static final Log LOG;

    public FigText(int n2, int n3, int n4, int n5, Color color, String string, int n6, boolean bl2) {
        super(n2, n3, n4, n5);
        this._x = n2;
        this._y = n3;
        this._w = n4;
        this._h = n5;
        this._textColor = color;
        this._font = new Font(string, 0, n6);
        this._justification = 2;
        this._curText = "";
        this._expandOnly = bl2;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public FigText(int n2, int n3, int n4, int n5, Color color, String string, int n6) {
        this(n2, n3, n4, n5, color, string, n6, false);
    }

    public FigText(int n2, int n3, int n4, int n5, Color color, Font font) {
        this(n2, n3, n4, n5, color, font.getName(), font.getSize());
    }

    public FigText(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this._x = n2;
        this._y = n3;
        this._w = n4;
        this._h = n5;
        this._justification = 2;
        this._curText = "";
        this._expandOnly = false;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public FigText(int n2, int n3, int n4, int n5, boolean bl2) {
        super(n2, n3, n4, n5);
        this._x = n2;
        this._y = n3;
        this._w = n4;
        this._h = n5;
        this._justification = 2;
        this._curText = "";
        this._expandOnly = bl2;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public String getJustificationByName() {
        if (this._justification == 0) {
            return "Left";
        }
        if (this._justification == 2) {
            return "Center";
        }
        if (this._justification == 1) {
            return "Right";
        }
        LOG.error((Object)"internal error, unknown text alignment");
        return "Unknown";
    }

    public void setJustificationByName(String string) {
        if (string.equals("Left")) {
            this._justification = 0;
        } else if (string.equals("Center")) {
            this._justification = 2;
        } else if (string.equals("Right")) {
            this._justification = 1;
        }
        this._fm = null;
    }

    protected FontMetrics getFontMetrics() {
        return this._fm;
    }

    public Color getTextColor() {
        return this._textColor;
    }

    public void setTextColor(Color color) {
        this.firePropChange("textColor", this._textColor, color);
        this._textColor = color;
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public void setTextFillColor(Color color) {
        this.firePropChange("textFillColor", this.textFillColor, color);
        this.textFillColor = color;
    }

    public boolean getTextFilled() {
        return this._textFilled;
    }

    public void setTextFilled(boolean bl2) {
        this.firePropChange("textFilled", this._textFilled, bl2);
        this._textFilled = bl2;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl2) {
        this.firePropChange("editable", this.editable, bl2);
        this.editable = bl2;
    }

    public boolean getUnderline() {
        return this._underline;
    }

    public void setUnderline(boolean bl2) {
        if (this.getUnderline() == bl2) {
            return;
        }
        this.firePropChange("underline", this._underline, bl2);
        this._underline = bl2;
    }

    public int getJustification() {
        return this._justification;
    }

    public void setJustification(int n2) {
        if (this._justification == n2) {
            return;
        }
        this.firePropChange("justification", this.getJustification(), n2);
        this._justification = n2;
    }

    public int getLineSpacing() {
        return this._lineSpacing;
    }

    public void setLineSpacing(int n2) {
        this.firePropChange("lineSpacing", this._lineSpacing, n2);
        this._lineSpacing = n2;
        this.calcBounds();
    }

    public int getTopMargin() {
        return this._topMargin;
    }

    public void setTopMargin(int n2) {
        this.firePropChange("topMargin", this._topMargin, n2);
        this._topMargin = n2;
        this.calcBounds();
    }

    public int getBotMargin() {
        return this._botMargin;
    }

    public void setBotMargin(int n2) {
        this.firePropChange("botMargin", this._botMargin, n2);
        this._botMargin = n2;
        this.calcBounds();
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(int n2) {
        this.firePropChange("leftMargin", this._leftMargin, n2);
        this._leftMargin = n2;
        this.calcBounds();
    }

    public int getRightMargin() {
        return this._rightMargin;
    }

    public void setRightMargin(int n2) {
        this.firePropChange("rightMargin", this._rightMargin, n2);
        this._rightMargin = n2;
        this.calcBounds();
    }

    public boolean getExpandOnly() {
        return this._expandOnly;
    }

    public void setExpandOnly(boolean bl2) {
        this.firePropChange("expandOnly", this._expandOnly, bl2);
        this._expandOnly = bl2;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this.firePropChange("font", this._font, font);
        this._font = font;
        this._fm = null;
        this.calcBounds();
    }

    public String getFontFamily() {
        return this._font.getFamily();
    }

    public void setFontFamily(String object) {
        object = new Font((String)object, this._font.getStyle(), this._font.getSize());
        this.setFont((Font)object);
    }

    public int getFontSize() {
        return this._font.getSize();
    }

    public void setFontSize(int n2) {
        Font font = new Font(this._font.getFamily(), this._font.getStyle(), n2);
        this.setFont(font);
    }

    public boolean getItalic() {
        return this._font.isItalic();
    }

    public void setItalic(boolean bl2) {
        if (this.getItalic() == bl2) {
            return;
        }
        int font = (this.getBold() ? 1 : 0) + (bl2 ? 2 : 0);
        Font font2 = new Font(this._font.getFamily(), font, this._font.getSize());
        this.setFont(font2);
    }

    public boolean getBold() {
        return this._font.isBold();
    }

    public void setBold(boolean bl2) {
        if (this.getBold() == bl2) {
            return;
        }
        int n2 = (bl2 ? 1 : 0) + (this.getItalic() ? 2 : 0);
        this.setFont(new Font(this._font.getFamily(), n2, this._font.getSize()));
    }

    public void setMultiLine(boolean bl2) {
        if (bl2) {
            this.returnAction = 1;
            return;
        }
        this.returnAction = 2;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public boolean getMultiLine() {
        return this.returnAction == 1;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setReturnAction(int n2) {
        this.returnAction = n2;
    }

    public void setTabAction(int n2) {
        this.tabAction = n2;
    }

    public int getTabAction() {
        return this.tabAction;
    }

    public int getReturnAction() {
        return this.returnAction;
    }

    public void setAllowsTab(boolean bl2) {
        if (bl2) {
            this.tabAction = 1;
            return;
        }
        this.tabAction = 2;
    }

    public void setWordWrap(boolean bl2) {
        this.wordWrap = bl2;
    }

    public boolean getAllowsTab() {
        return this.tabAction == 1;
    }

    public String deleteLastCharFromString(String object) {
        int n2 = Math.max(((String)object).length() - 1, 0);
        object = ((String)object).toCharArray();
        return new String((char[])object, 0, n2);
    }

    public void deleteLastChar() {
        this._curText = this.deleteLastCharFromString(this._curText);
        this.calcBounds();
    }

    public void append(char c2) {
        this.setText(this._curText + c2);
    }

    public void append(String string) {
        this.setText(this._curText + string);
    }

    public void setText(String string, Graphics graphics) {
        if (graphics != null) {
            this._fm = graphics.getFontMetrics(this._font);
        }
        this.setText(string);
    }

    public void setText(String string) {
        string = this.encode(string, this.lineSeparator);
        if (this.textEditor != null && !this._curText.equals(string)) {
            this.textEditor.cancelEditing();
        }
        this._curText = string;
        this.calcBounds();
        this._editMode = false;
    }

    void setTextFriend(String string, Graphics graphics) {
        if (graphics != null) {
            this._fm = graphics.getFontMetrics(this._font);
        }
        this.setTextFriend(string);
    }

    void setTextFriend(String string) {
        if (UndoManager.getInstance().isGenerateMementos() && this.getOwner(this) == null) {
            FigText$1 figText$1 = new FigText$1(this);
            UndoManager.getInstance().addMemento(figText$1);
        }
        this._curText = this.encode(string, System.getProperty("line.separator"));
        this.calcBounds();
        this._editMode = false;
    }

    private Object getOwner(Fig fig) {
        do {
            Object object;
            if ((object = fig.getOwner()) == null) continue;
            return object;
        } while ((fig = fig.getGroup()) != null);
        return null;
    }

    public String getText() {
        return this.decode(this._curText, this.lineSeparator);
    }

    public String getTextFriend() {
        return this.decode(this._curText, System.getProperty("line.separator"));
    }

    public Class getTextEditorClass() {
        return this._textEditorClass;
    }

    public void setTextEditorClass(Class clazz) {
        this._textEditorClass = clazz;
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        int n2 = this.getLineWidth();
        if (this.isFilled()) {
            graphics.setColor(this.getFillColor());
            graphics.fillRect(this._x, this._y, this._w, this._h);
        }
        if (n2 > 0) {
            graphics.setColor(this.getLineColor());
            if (n2 == 1) {
                graphics.drawRect(this._x, this._y, this._w - n2, this._h - n2);
            } else {
                graphics.fillRect(this._x, this._y, this._w - n2, n2);
                graphics.fillRect(this._x + this._w - n2, this._y, n2, this._h - n2);
                graphics.fillRect(this._x + n2, this._y + this._h - n2, this._w - n2, n2);
                graphics.fillRect(this._x, this._y + n2, n2, this._h - n2);
            }
        }
        if (this._textFilled) {
            graphics.setColor(this.textFillColor);
            graphics.fillRect(this._x + n2, this._y + n2, this._w - 2 * n2, this._h - 2 * n2);
        }
        if (this._font != null) {
            graphics.setFont(this._font);
        }
        this._fm = graphics.getFontMetrics(this._font);
        int n3 = this._fm.getHeight() + this._lineSpacing;
        graphics.setColor(this._textColor);
        int n4 = this._x + this._leftMargin + n2;
        int n5 = this._y + this._topMargin + n2 + this._fm.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens() && n5 <= this.getHeight() + this.getY() + this._topMargin - this._botMargin) {
            String string = stringTokenizer.nextToken();
            int n6 = this._fm.stringWidth(string);
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    n4 = this._x + this._leftMargin + (this._w - this._leftMargin - this._rightMargin - n6) / 2;
                    break;
                }
                case 1: {
                    n4 = this._x + this._w - n2 - this._rightMargin - n6;
                }
            }
            if (this.isHardReturn(string) || this.isSoftReturn(string)) {
                n5 += n3;
                continue;
            }
            if (this._underline) {
                graphics.drawLine(n4, n5 + 1, n4 + n6, n5 + 1);
            }
            this.drawString(graphics, string, n4, n5);
        }
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<text id ='").append(this.getId()).append("' x='").append(this.getX()).append("' y='").append(this.getY()).append("' transform='translate(").append(this.getFontSize()).append(',').append(this.getFontSize()).append(")'");
        this.appendSvgStyle(stringBuffer);
        stringBuffer.append(">").append(this.getText()).append("</text>");
    }

    @Override
    protected void appendSvgStyle(StringBuffer stringBuffer) {
        stringBuffer.append(" style='fill:rgb(").append(this.getFillColor().getRed()).append(",").append(this.getFillColor().getGreen()).append(",").append(this.getFillColor().getBlue()).append(");stroke-width:").append(this.getLineWidth()).append(";stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(",").append(this.getLineColor().getBlue()).append(");'font:").append(this.getFontFamily()).append("; font-size:").append(this.getFontSize()).append("'");
    }

    protected void drawString(Graphics graphics, String string, int n2, int n3) {
        graphics.drawString(string, n2, n3);
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        return this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height) > 0;
    }

    public int getMinimumHeight() {
        if (this._fm != null) {
            return this._fm.getHeight();
        }
        if (this._font != null) {
            return this._font.getSize();
        }
        return 0;
    }

    public int getTextBounds(Graphics graphics) {
        if (this._font != null) {
            return graphics.getFontMetrics().stringWidth(this.getText());
        }
        return 0;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        this.stuffMinimumSize(dimension);
        return dimension;
    }

    public void stuffMinimumSize(Dimension dimension) {
        if (this._font == null) {
            return;
        }
        int n2 = 0;
        int n3 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n4 = this._fm.stringWidth(string);
            if (string.charAt(0) == '\n' || string.charAt(0) == '\r') {
                ++n3;
                continue;
            }
            n2 = Math.max(n4, n2);
        }
        this._lineHeight = this._fm == null ? this._font.getSize() : this._fm.getHeight();
        int n5 = Math.max((this._lineHeight + this._lineSpacing) * n3, this.getMinimumHeight());
        n2 = Math.max(n2, 30);
        n5 = n5 + this._topMargin + this._botMargin + 2 * this.getLineWidth();
        dimension.width = n2 = n2 + this._leftMargin + this._rightMargin + 2 * this.getLineWidth();
        dimension.height = n5;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.isStartEditingKey(keyEvent) && this.editable) {
            keyEvent.consume();
            TextEditor textEditor = this.startTextEditor(keyEvent);
            if (!Character.isISOControl(keyEvent.getKeyChar())) {
                textEditor.setText(textEditor.getText() + keyEvent.getKeyChar());
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected boolean isStartEditingKey(KeyEvent keyEvent) {
        return !Character.isISOControl(keyEvent.getKeyChar());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getClickCount() >= 2 && this.editable) {
            this.startTextEditor(mouseEvent);
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public TextEditor startTextEditor(InputEvent inputEvent) {
        activeTextEditor = this.textEditor = new FigTextEditor(this, inputEvent);
        this._editMode = true;
        return this.textEditor;
    }

    public static TextEditor getActiveTextEditor() {
        return activeTextEditor;
    }

    public void endTextEditor() {
        this.textEditor.endEditing();
    }

    public void cancelTextEditor() {
        this.textEditor.cancelEditing();
    }

    @Override
    public void calcBounds() {
        if (this._font == null) {
            return;
        }
        if (this._fm == null) {
            this._fm = new JLabel().getFontMetrics(this._font);
        }
        this._lineHeight = this._fm.getHeight();
        int n2 = 0;
        int n3 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n4 = this._fm.stringWidth(string);
            if (string.charAt(0) == '\n' || string.charAt(0) == '\r') {
                ++n3;
                continue;
            }
            n2 = Math.max(n4, n2);
        }
        int n5 = Math.max((this._lineHeight + this._lineSpacing) * n3, this.getMinimumHeight());
        n2 = Math.max(n2, 30);
        n5 = n5 + this._topMargin + this._botMargin + 2 * this.getLineWidth();
        n2 = n2 + this._leftMargin + this._rightMargin + 2 * this.getLineWidth();
        if (this._editMode) {
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this._w >= n2) break;
                    this._x -= (n2 - this._w) / 2;
                    break;
                }
                case 1: {
                    if (this._w >= n2) break;
                    this._x -= n2 - this._w;
                }
            }
        }
        this._w = this._expandOnly ? Math.max(this._w, n2) : n2;
        this._h = this._expandOnly ? Math.max(this._h, n5) : n5;
    }

    private String encode(String string, String string2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n3)) >= 0) {
            stringBuffer.append(string.substring(n3, n2)).append('\n');
            n3 = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n3));
        if (this.wordWrap) {
            return this.wordWrap(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String wordWrap(String string) {
        if (!this.wordWrap) {
            throw new IllegalArgumentException("Attempted to wordwrap while wordwrap off");
        }
        FontMetrics fontMetrics = FontUtility.getFontMetrics(this._font);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = fontMetrics.stringWidth(string2);
            if (this.isSoftReturn(string2)) continue;
            if (this.isHardReturn(string2)) {
                stringBuffer.append('\n');
                n2 = 0;
                continue;
            }
            if (this.isSpace(string2)) {
                stringBuffer.append(string2);
                n2 += n3;
                continue;
            }
            if (n2 > 0 && n2 + n3 > this.getWidth()) {
                stringBuffer.append('\r');
                n2 = 0;
            }
            n2 = this.appendToken(stringBuffer, string2, n3, fontMetrics, n2);
        }
        return stringBuffer.toString();
    }

    private int appendToken(StringBuffer stringBuffer, String string, int n2, FontMetrics fontMetrics, int n3) {
        if (n3 + n2 <= this.getWidth()) {
            stringBuffer.append(string);
            n3 += n2;
        } else {
            String string2 = "";
            int n4 = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                n4 = fontMetrics.stringWidth(string2 = string2 + string.charAt(i2));
                if (n4 <= this.getWidth()) continue;
                String string3 = "";
                int n5 = 0;
                if (string2.length() > 1) {
                    string3 = string2.substring(string2.length() - 1);
                    n5 = fontMetrics.stringWidth(string3);
                    string2 = string2.substring(0, string2.length() - 1);
                }
                stringBuffer.append(string2);
                string2 = string3;
                n4 = n5;
                if (i2 < string.length() - 1) {
                    stringBuffer.append('\r');
                    n3 = 0;
                    continue;
                }
                n3 += n4;
            }
            if (n4 > 0) {
                stringBuffer.append(string2);
                n3 += n4;
            }
        }
        return n3;
    }

    private String decode(String object, String string) {
        StringBuffer stringBuffer = new StringBuffer(((String)object).length());
        object = new StringTokenizer((String)object, "\n\r", true);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (this.isSoftReturn(string2)) continue;
            if (this.isHardReturn(string2)) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean isSoftReturn(String string) {
        return string.length() == 1 && string.charAt(0) == '\r';
    }

    private boolean isHardReturn(String string) {
        return string.length() == 1 && string.charAt(0) == '\n';
    }

    private boolean isSpace(String string) {
        return string.length() == 1 && string.charAt(0) == ' ';
    }

    @Override
    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        if (this._w != n4 && this.wordWrap) {
            super.setBoundsImpl(n2, n3, n4, n5);
            this._curText = this.wordWrap(this._curText);
            return;
        }
        super.setBoundsImpl(n2, n3, n4, n5);
    }

    static /* synthetic */ String access$000(FigText figText) {
        return figText._curText;
    }

    static /* synthetic */ String access$002(FigText figText, String string) {
        figText._curText = string;
        return figText._curText;
    }

    static {
        LOG = LogFactory.getLog(FigText.class);
        PropCategoryManager.categorizeProperty("Text", "font");
        PropCategoryManager.categorizeProperty("Text", "underline");
        PropCategoryManager.categorizeProperty("Text", "expandOnly");
        PropCategoryManager.categorizeProperty("Text", "lineSpacing");
        PropCategoryManager.categorizeProperty("Text", "topMargin");
        PropCategoryManager.categorizeProperty("Text", "botMargin");
        PropCategoryManager.categorizeProperty("Text", "leftMargin");
        PropCategoryManager.categorizeProperty("Text", "rightMargin");
        PropCategoryManager.categorizeProperty("Text", "text");
        PropCategoryManager.categorizeProperty("Style", "justification");
        PropCategoryManager.categorizeProperty("Style", "textFilled");
        PropCategoryManager.categorizeProperty("Style", "textFillColor");
        PropCategoryManager.categorizeProperty("Style", "textColor");
    }
}

