/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.properties.ui.ColorEditor;
import org.tigris.gef.properties.ui.PropSheet;
import org.tigris.gef.properties.ui.PropertyCanvas;
import org.tigris.gef.properties.ui.PropertySelector;
import org.tigris.gef.properties.ui.PropertyText;
import org.tigris.gef.properties.ui.PropsGridLayout;
import org.tigris.gef.properties.ui.RectangleEditor;

public class PropSheetCategory
extends PropSheet {
    public static final String dots = "";
    protected Hashtable _keysComps;
    protected Hashtable _compsKeys;
    protected Hashtable _inUse;
    protected Hashtable _labels;
    protected Hashtable _shown;
    protected String _category = "Misc";
    protected PropertyDescriptor[] _properties;
    protected JFrame _jframe;
    protected boolean inRecursion = false;

    public PropSheetCategory(JFrame jFrame) {
        this._jframe = jFrame;
        this.setTabName("no key");
        this.setLayout(new PropsGridLayout(4, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 250, this.getInsets().top + this.getInsets().bottom + 300);
        this.setFont(this.getPropertiesFont());
        this._keysComps = new Hashtable(20);
        this._compsKeys = new Hashtable(20);
        this._labels = new Hashtable(20);
        this._inUse = new Hashtable(20);
        this._shown = new Hashtable(20);
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String string) {
        if (this._category.equals(string)) {
            return;
        }
        this._category = string;
        this.setTabName(string);
        if (this._sel != null) {
            this.updateComponents();
            this.repaint();
        }
    }

    public Component addKeyComp(PropertyDescriptor propertyDescriptor) {
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        if (component == null) {
            component = this.makeComp(propertyDescriptor);
            this._keysComps.put(propertyDescriptor, component);
            this._compsKeys.put(component, propertyDescriptor);
            JLabel jLabel = new JLabel(propertyDescriptor.getName());
            this._labels.put(propertyDescriptor, jLabel);
        }
        this._inUse.put(propertyDescriptor, propertyDescriptor);
        return component;
    }

    public void updateKeysComps() {
        this._inUse.clear();
        if (this._sel == null) {
            return;
        }
        Object object = this._sel.getClass();
        try {
            object = Introspector.getBeanInfo(object);
            this._properties = object.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            System.out.println("PropertySheet: Couldn't introspect\n" + introspectionException.toString());
            return;
        }
        for (int i2 = 0; i2 < this._properties.length; ++i2) {
            boolean bl2;
            if (!PropCategoryManager.inCategory(this._category, this._properties[i2])) continue;
            Component component = this.addKeyComp(this._properties[i2]);
            boolean bl3 = bl2 = this._properties[i2].getWriteMethod() != null;
            if (component instanceof TextComponent) {
                ((TextComponent)component).setEditable(bl2);
                continue;
            }
            component.setEnabled(bl2);
        }
    }

    public void show(PropertyDescriptor propertyDescriptor) {
        JLabel jLabel = (JLabel)this._labels.get(propertyDescriptor);
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        this.setComponentValue(propertyDescriptor, component);
        if (this._shown.containsKey(propertyDescriptor)) {
            return;
        }
        this.add(jLabel);
        this.add(component);
        jLabel.setVisible(true);
        component.setVisible(true);
        this._shown.put(propertyDescriptor, propertyDescriptor);
    }

    public void hide(PropertyDescriptor propertyDescriptor) {
        if (!this._shown.containsKey(propertyDescriptor)) {
            return;
        }
        JLabel jLabel = (JLabel)this._labels.get(propertyDescriptor);
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        jLabel.setVisible(false);
        component.setVisible(false);
        this.remove(jLabel);
        this.remove(component);
        this._shown.remove(propertyDescriptor);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(300, 400);
    }

    public Component makeComp(PropertyDescriptor propertyDescriptor) {
        Component component = null;
        try {
            Object object = propertyDescriptor.getReadMethod();
            propertyDescriptor.getWriteMethod();
            Object object2 = new Object[]{};
            object = ((Method)object).invoke(this._sel, object2);
            object2 = propertyDescriptor.getPropertyType();
            PropertyEditor propertyEditor = null;
            Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
            if (clazz != null) {
                try {
                    propertyEditor = (PropertyEditor)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.out.println("exception in makecomp");
                }
            }
            if (propertyEditor == null) {
                propertyEditor = PropertyEditorManager.findEditor(object2);
            }
            if (propertyEditor == null) {
                return new JLabel(object == null ? "(null)" : object.toString());
            }
            propertyEditor.setValue(object);
            propertyEditor.addPropertyChangeListener(this);
            this._editorsPds.put(propertyEditor, propertyDescriptor);
            this._pdsEditors.put(propertyDescriptor, propertyEditor);
            if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
                component = new PropertyCanvas(this._jframe, propertyEditor);
            } else if (propertyEditor instanceof Component) {
                component = (Component)((Object)propertyEditor);
            } else if (propertyEditor.getTags() != null) {
                component = new PropertySelector(propertyEditor);
            } else if (propertyEditor.getAsText() != null) {
                propertyEditor.getAsText();
                component = new PropertyText(propertyEditor);
            } else {
                System.err.println("Warning: Property \"" + propertyDescriptor.toString() + "\" has non-displayabale editor. Skipping.");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Skipping property " + propertyDescriptor.toString() + " ; exception on target: " + invocationTargetException.getTargetException());
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Skipping property " + propertyDescriptor.toString() + " ; Illegal Access on target: " + illegalAccessException.toString());
            illegalAccessException.printStackTrace();
        }
        return component;
    }

    public void setComponentValue(PropertyDescriptor propertyDescriptor, Component component) {
        Object object;
        if (this.inRecursion) {
            return;
        }
        Object object2 = null;
        try {
            object = propertyDescriptor.getReadMethod();
            propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{};
            object2 = ((Method)object).invoke(this._sel, objectArray);
        }
        catch (Exception exception) {
            System.out.println("unexpected Exception!");
        }
        if (object2 == null) {
            System.out.println("null value");
            return;
        }
        if (component == null) {
            System.out.println("tag is null");
        }
        this.inRecursion = true;
        if (component instanceof PropertyEditor) {
            ((PropertyEditor)((Object)component)).setValue(object2);
        } else if (component instanceof PropertyText) {
            ((PropertyText)component).setText(object2.toString());
        } else if (component instanceof PropertySelector) {
            object = object2.toString();
            if (object2 instanceof Boolean) {
                object = (Boolean)object2 != false ? "True" : "False";
            }
            if (object == null) {
                System.out.println("tag is null");
            }
            ((PropertySelector)component).setSelectedItem(object);
        } else if (component instanceof Label) {
            ((Label)component).setText(object2.toString());
        } else {
            object = (PropertyEditor)this._pdsEditors.get(propertyDescriptor);
            if (object != null) {
                this._ignorePropChanges = true;
                object.setValue(object2);
                this._ignorePropChanges = false;
            }
        }
        this.inRecursion = false;
    }

    @Override
    public void addNotify() {
        if (this._keysComps != null) {
            super.addNotify();
        }
    }

    @Override
    public boolean canEdit(Object object) {
        return object != null && super.canEdit(object);
    }

    @Override
    public void updateComponents() {
        super.updateComponents();
        this.updateKeysComps();
        Enumeration enumeration = this._keysComps.keys();
        while (enumeration.hasMoreElements()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)enumeration.nextElement();
            if (this._inUse.containsKey(propertyDescriptor)) {
                this.show(propertyDescriptor);
                continue;
            }
            this.hide(propertyDescriptor);
        }
        this.validate();
    }

    @Override
    public void updateComponent(PropertyDescriptor propertyDescriptor) {
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        if (component != null) {
            this.setComponentValue(propertyDescriptor, component);
        }
    }

    static {
        PropertyEditorManager.setEditorSearchPath(new String[]{"org.tigris.gef.properties.ui", "sun.beans.editors"});
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        PropertyEditorManager.registerEditor(Rectangle.class, RectangleEditor.class);
    }
}

