/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PropsGridLayout
implements LayoutManager {
    int hgap;
    int vgap;
    int _labelWidth = 100;
    int _labelHeight = 22;
    int _minPropWidth = 150;

    public PropsGridLayout(int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = this._labelWidth + this._minPropWidth + this.hgap;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Dimension dimension = container.getComponent(i2).getPreferredSize();
            n4 += dimension.height + this.vgap;
        }
        return new Dimension(insets.left + insets.right + n3, insets.top + insets.bottom + n4);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = this._labelWidth + this._minPropWidth + this.hgap;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Dimension dimension = container.getComponent(i2).getMinimumSize();
            n4 += dimension.height + this.vgap;
        }
        return new Dimension(insets.left + insets.right + n3, insets.top + insets.bottom + n4);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = insets.left + insets.right + this.hgap + this._labelWidth;
        Math.max(container.getSize().width - n3, this._minPropWidth);
        container.getGraphics();
        n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            Dimension dimension = component.getPreferredSize();
            if (i2 % 2 == 0) {
                component.setBounds(0, n3, this._labelWidth, this._labelHeight);
                continue;
            }
            component.setLocation(this._labelWidth + this.hgap, n3);
            component.setSize(dimension);
            n3 += Math.max(dimension.height, this._labelHeight) + this.vgap;
        }
    }
}

