/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.tigris.gef.base.CmdCreateNode;
import org.tigris.gef.base.CmdSetMode;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.ui.ToolBar$ActionToggleChangedListener;
import org.tigris.gef.util.ResourceLoader;

public class ToolBar
extends JToolBar
implements MouseListener {
    protected Vector _lockable = new Vector();
    protected Vector _modeButtons = new Vector();
    private static final Color selectedBack = new Color(153, 153, 153);
    private static final Color buttonBack = new Color(204, 204, 204);

    public ToolBar() {
        this.setFloatable(false);
        this.setName("toolBar");
    }

    @Override
    public JButton add(Action action) {
        String string = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.add(action, string, icon);
    }

    public JButton add(Action action, String string, String object) {
        object = ResourceLoader.lookupIconResource((String)object, string);
        return this.add(action, string, (Icon)object);
    }

    public JButton add(Action action, String string, Icon icon) {
        JButton jButton = super.add(action);
        jButton.setName(null);
        jButton.setText(null);
        jButton.setIcon(icon);
        jButton.setToolTipText(string + " ");
        if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
            this._modeButtons.addElement(jButton);
        }
        if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
            this._lockable.addElement(jButton);
        }
        jButton.addMouseListener(this);
        return jButton;
    }

    @Override
    public Component add(Component component) {
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            Action action = jButton.getAction();
            if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
                this._modeButtons.addElement(jButton);
            }
            if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
                this._lockable.addElement(jButton);
            }
            jButton.addMouseListener(this);
        }
        return super.add(component);
    }

    public JToggleButton addToggle(Action action) {
        String string = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.addToggle(action, string, icon);
    }

    public JToggleButton addToggle(Action action, String string, String object) {
        object = ResourceLoader.lookupIconResource((String)object, string);
        return this.addToggle(action, string, (Icon)object);
    }

    public JToggleButton addToggle(Action action, String object, Icon object2) {
        object2 = new JToggleButton((Icon)object2);
        ((JComponent)object2).setToolTipText((String)object + " ");
        ((AbstractButton)object2).setEnabled(action.isEnabled());
        ((AbstractButton)object2).addActionListener(action);
        this.add((Component)object2);
        object = this.createActionToggleListener((JToggleButton)object2);
        action.addPropertyChangeListener((PropertyChangeListener)object);
        return object2;
    }

    public JToggleButton addToggle(Action action, String object, String object2, String string) {
        object2 = ResourceLoader.lookupIconResource((String)object2, (String)object);
        ResourceLoader.lookupIconResource(string, (String)object);
        object2 = new JToggleButton((Icon)object2);
        ((JComponent)object2).setToolTipText((String)object + " ");
        ((AbstractButton)object2).setEnabled(action.isEnabled());
        ((AbstractButton)object2).addActionListener(action);
        ((AbstractButton)object2).setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)object2);
        object = this.createActionToggleListener((JToggleButton)object2);
        action.addPropertyChangeListener((PropertyChangeListener)object);
        return object2;
    }

    public ButtonGroup addRadioGroup(String object, ImageIcon accessible, ImageIcon serializable, String string, ImageIcon imageIcon, ImageIcon imageIcon2) {
        accessible = new JRadioButton((Icon)((Object)accessible), true);
        ((AbstractButton)((Object)accessible)).setSelectedIcon((Icon)((Object)serializable));
        ((JComponent)((Object)accessible)).setToolTipText((String)object + " ");
        ((AbstractButton)((Object)accessible)).setMargin(new Insets(0, 0, 0, 0));
        ((JRadioButton)accessible).getAccessibleContext().setAccessibleName((String)object);
        object = new JRadioButton(imageIcon, false);
        ((AbstractButton)object).setSelectedIcon(imageIcon2);
        ((JComponent)object).setToolTipText(string + " ");
        ((AbstractButton)object).setMargin(new Insets(0, 0, 0, 0));
        ((JRadioButton)object).getAccessibleContext().setAccessibleName(string);
        this.add((Component)((Object)accessible));
        this.add((Component)object);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)((Object)accessible));
        ((ButtonGroup)serializable).add((AbstractButton)object);
        return serializable;
    }

    protected PropertyChangeListener createActionToggleListener(JToggleButton jToggleButton) {
        return new ToolBar$ActionToggleChangedListener(this, jToggleButton);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object = mouseEvent.getSource();
        if (this.isModeButton(object)) {
            this.unpressAllButtonsExcept(object);
            serializable = Globals.curEditor();
            if (serializable != null) {
                ((Editor)serializable).finishMode();
            }
            Globals.setSticky(false);
        }
        if (mouseEvent.getClickCount() >= 2) {
            if (!(object instanceof JButton)) {
                return;
            }
            serializable = (JButton)object;
            if (this.canLock(serializable)) {
                ((AbstractButton)serializable).getModel().setPressed(true);
                ((AbstractButton)serializable).getModel().setArmed(true);
                ((JComponent)serializable).setBackground(selectedBack);
                Globals.setSticky(true);
            }
            return;
        }
        if (mouseEvent.getClickCount() == 1 && object instanceof JButton && this.isModeButton(object)) {
            serializable = (JButton)object;
            ((AbstractButton)serializable).setFocusPainted(false);
            ((AbstractButton)serializable).getModel().setPressed(true);
            ((JComponent)serializable).setBackground(selectedBack);
        }
    }

    protected boolean canLock(Object object) {
        return this._lockable.contains(object);
    }

    protected boolean isModeButton(Object object) {
        return this._modeButtons.contains(object);
    }

    protected void unpressAllButtonsExcept(Object object) {
        int n2 = this.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JButton) || component == object) continue;
            ((JButton)component).getModel().setArmed(false);
            ((JButton)component).getModel().setPressed(false);
            ((JButton)component).setBackground(buttonBack);
        }
    }

    public void unpressAllButtons() {
        Component component;
        int n2;
        int n3 = this.getComponentCount();
        for (n2 = 0; n2 < n3; ++n2) {
            component = this.getComponent(n2);
            if (!(component instanceof JButton)) continue;
            ((JButton)component).getModel().setArmed(false);
            ((JButton)component).getModel().setPressed(false);
            ((JButton)component).setBackground(buttonBack);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            component = this.getComponent(n2);
            if (!(component instanceof JButton)) continue;
            JButton jButton = (JButton)component;
            jButton.getModel().setArmed(true);
            jButton.getModel().setPressed(true);
            jButton.setBackground(selectedBack);
            return;
        }
    }
}

