/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.awt.AWTKeyStroke;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Localizer {
    private static Map resourcesByLocale = new HashMap();
    private static Map resourceNames = new HashMap();
    private static Locale defaultLocale = Locale.getDefault();
    private static Map defaultResources = new HashMap();
    private static Log log;
    protected static final String SHORTCUT_MODIFIER = "shortcut";

    public static boolean containsResource(String string) {
        return resourceNames.containsValue(string);
    }

    public static boolean containsLocale(Locale locale) {
        return resourcesByLocale.containsKey(locale);
    }

    public static void addLocale(Locale locale) {
        HashMap<String, ResourceBundle> hashMap = new HashMap<String, ResourceBundle>();
        Iterator iterator = resourceNames.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                ResourceBundle resourceBundle = ResourceBundle.getBundle((String)resourceNames.get(string), locale);
                if (resourceBundle == null || !(resourceBundle instanceof ResourceBundle)) continue;
                hashMap.put(string, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        resourcesByLocale.put(locale, hashMap);
    }

    public static void switchCurrentLocale(Locale locale) {
        if (!resourcesByLocale.containsKey(locale)) {
            Localizer.addLocale(locale);
        }
        if (!defaultLocale.equals(locale)) {
            defaultLocale = locale;
            defaultResources = (Map)resourcesByLocale.get(locale);
        }
    }

    public static Locale getCurrentLocale() {
        return defaultLocale;
    }

    public static Map getResourcesFor(Locale locale) {
        if (!Localizer.containsLocale(locale)) {
            return null;
        }
        return (Map)resourcesByLocale.get(locale);
    }

    public static synchronized void addResource(String string, String string2) {
        Localizer.addResource(string, string2, Localizer.class.getClassLoader());
    }

    public static synchronized void addResource(String string, String string2, ClassLoader classLoader) {
        if (Localizer.containsResource(string2)) {
            return;
        }
        Iterator iterator = resourcesByLocale.keySet().iterator();
        while (iterator.hasNext()) {
            Localizer.addResource(string, string2, (Locale)iterator.next(), classLoader);
        }
    }

    public static synchronized void addResource(String string, String string2, Locale locale) {
        Localizer.addResource(string, string2, locale, Localizer.class.getClassLoader());
    }

    public static synchronized void addResource(String string, String string2, Locale object, ClassLoader classLoader) {
        if (Localizer.containsLocale((Locale)object)) {
            Map map = (Map)resourcesByLocale.get(object);
            object = ResourceBundle.getBundle(string2, (Locale)object, classLoader);
            map.put(string, object);
            if (!resourceNames.containsValue(string2)) {
                resourceNames.put(string, string2);
            }
            return;
        }
        throw new MissingResourceException("Locale not found!", ((Locale)object).toString(), string2);
    }

    public static void removeLocale(Locale locale) {
        if (defaultLocale.equals(locale)) {
            Localizer.switchCurrentLocale(Locale.getDefault());
        }
        resourcesByLocale.remove(locale);
    }

    public static void removeResource(String string) {
        for (Locale locale : resourcesByLocale.keySet()) {
            ((Map)resourcesByLocale.get(locale)).remove(string);
        }
        resourceNames.remove(string);
    }

    public static String localize(String string, String string2) {
        return Localizer.localize(string, string2, defaultLocale, defaultResources);
    }

    public static String localize(String string, String string2, boolean bl2) {
        return Localizer.localize(string, string2, defaultLocale, defaultResources, bl2);
    }

    public static String localize(String string, String string2, Locale locale, Map map, boolean bl2) {
        if (bl2) {
            return Localizer.localize(string, string2, locale, map);
        }
        return string2;
    }

    public static String localize(String object, String string, Locale object2, Map map) {
        if (object2 == null || map == null || !Localizer.containsLocale((Locale)object2)) {
            return string;
        }
        object2 = null;
        if ((object = (ResourceBundle)map.get(object)) == null) {
            return string;
        }
        try {
            object2 = ((ResourceBundle)object).getString(string);
        }
        catch (MissingResourceException missingResourceException) {}
        if (object2 == null) {
            object2 = string;
        }
        return object2;
    }

    public static boolean containsKey(String string, String string2) {
        return Localizer.containsKey(string, string2, defaultLocale, defaultResources);
    }

    public static boolean containsKey(String object, String string, Locale locale, Map map) {
        if (locale == null || map == null || !Localizer.containsLocale(locale)) {
            return false;
        }
        if ((object = (ResourceBundle)map.get(object)) == null) {
            return false;
        }
        try {
            ((ResourceBundle)object).getObject(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public static Set getKeys(String string) {
        return Localizer.getkeys(string, defaultLocale, defaultResources);
    }

    private static Set getkeys(String enumeration, Locale cloneable, Map object) {
        if (cloneable == null || object == null || !Localizer.containsLocale((Locale)cloneable)) {
            return Collections.EMPTY_SET;
        }
        if ((enumeration = (ResourceBundle)object.get(enumeration)) == null) {
            return Collections.EMPTY_SET;
        }
        cloneable = new HashSet();
        enumeration = ((ResourceBundle)((Object)enumeration)).getKeys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cloneable.add(object);
        }
        return cloneable;
    }

    public static KeyStroke getShortcut(String string, String string2) {
        return Localizer.getShortcut(string, string2, defaultLocale, defaultResources);
    }

    public static KeyStroke getShortcut(String object, String string, Locale serializable, Map object2) {
        if (serializable == null || object2 == null || !Localizer.containsLocale((Locale)serializable)) {
            return null;
        }
        serializable = null;
        object = (ResourceBundle)object2.get(object);
        try {
            object = ((ResourceBundle)object).getObject(string);
            if (object instanceof KeyStroke) {
                serializable = (KeyStroke)object;
            } else if (object instanceof String) {
                boolean bl2 = false;
                object2 = new StringBuffer();
                object = new StringTokenizer((String)object);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if (string2.equals(SHORTCUT_MODIFIER)) {
                        bl2 = true;
                        continue;
                    }
                    ((StringBuffer)object2).append(string2);
                    ((StringBuffer)object2).append(" ");
                }
                serializable = KeyStroke.getKeyStroke(((StringBuffer)object2).toString());
                int n2 = ((AWTKeyStroke)serializable).getModifiers() | (bl2 ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 0);
                serializable = KeyStroke.getKeyStroke(((AWTKeyStroke)serializable).getKeyCode(), n2);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {}
        return serializable;
    }

    static {
        resourcesByLocale.put(defaultLocale, defaultResources);
        log = LogFactory.getLog(Localizer.class);
    }
}

