/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.acces.devicegateway;

import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import ro.deversoft.utils.noarch.ProguardKeepMethods;
import ro.deversoft.utils.noarch.ProguardKeepNames;

public class AccessLogicV1Configs
implements Serializable,
ProguardKeepMethods,
ProguardKeepNames {
    private Integer idUser;
    private boolean scadeValoareContInwards;
    private List<String> locations;
    private int secondsForUniquePay = 10;
    private double refuseAccesInBelowThreshold = 0.0;
    private String gateName;
    private Map<String, Integer> productIdsForPromotions = new Hashtable<String, Integer>();
    private String inReaderDevice;
    private String outReaderDevice;
    private String relayDevice;
    private List<Integer> openRelayInwardsCodes;
    private List<Integer> openRelayOutwardsCodes;
    private Map<String, Map<String, String>> clientsAccessSchedule;
    private Map<String, Map<String, String>> employeesAccessSchedule;

    public static final void main(String[] object) {
        object = new AccessLogicV1Configs();
        object.inReaderDevice = "turnichet1.reader_IN_dummy";
        object.outReaderDevice = "turnichet1.reader_OUT_dummy";
        object.relayDevice = "turnichet1.relay_dummy";
        object.openRelayInwardsCodes = Arrays.asList(1);
        object.openRelayOutwardsCodes = Arrays.asList(2);
        object.scadeValoareContInwards = true;
        object.locations = Arrays.asList("Piscina");
        object.idUser = 1;
        object.productIdsForPromotions.put("ADULT", 1);
        object.productIdsForPromotions.put("COPIL", 2);
        object.productIdsForPromotions.put("BEBE", 3);
        System.out.println(new GsonBuilder().setPrettyPrinting().create().toJson(object));
    }

    public static AccessLogicV1Configs readFromFile(String string) {
        return new GsonBuilder().create().fromJson((Reader)new FileReader(string), AccessLogicV1Configs.class);
    }

    public Integer getIdUser() {
        return this.idUser;
    }

    public boolean isScadeValoareContInwards() {
        return this.scadeValoareContInwards;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public Map<String, Integer> getProductIdsForPromotions() {
        return this.productIdsForPromotions;
    }

    public String getInReaderDevice() {
        return this.inReaderDevice;
    }

    public String getOutReaderDevice() {
        return this.outReaderDevice;
    }

    public String getRelayDevice() {
        return this.relayDevice;
    }

    public List<Integer> getOpenRelayInwardsCodes() {
        return this.openRelayInwardsCodes;
    }

    public List<Integer> getOpenRelayOutwardsCodes() {
        return this.openRelayOutwardsCodes;
    }

    public int getSecondsForUniquePay() {
        return this.secondsForUniquePay;
    }

    public void setSecondsForUniquePay(int n2) {
        this.secondsForUniquePay = n2;
    }

    public double getRefuseAccesInBelowThreshold() {
        return this.refuseAccesInBelowThreshold;
    }

    public void setRefuseAccesInBelowThreshold(double d2) {
        this.refuseAccesInBelowThreshold = d2;
    }

    public Map<String, Map<String, String>> getClientsAccessSchedule() {
        return this.clientsAccessSchedule;
    }

    public void setClientsAccessSchedule(Map<String, Map<String, String>> map) {
        this.clientsAccessSchedule = map;
    }

    public Map<String, Map<String, String>> getEmployeesAccessSchedule() {
        return this.employeesAccessSchedule;
    }

    public void setEmployeesAccessSchedule(Map<String, Map<String, String>> map) {
        this.employeesAccessSchedule = map;
    }

    public String getGateName() {
        return this.gateName;
    }

    public void setGateName(String string) {
        this.gateName = string;
    }
}

