/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import mseries.Calendar.MDateSelectorPanel;
import mseries.Calendar.MMonthEvent;
import mseries.Calendar.MMonthListener;
import mseries.ui.ArrowButton;
import mseries.ui.MDateEntryField;
import mseries.ui.MDateField;
import mseries.ui.MPopup;
import mseries.ui.MPopupDialog;
import mseries.ui.MPopupPanel;
import mseries.ui.MPopupWindow;
import mseries.ui.ScreenUtilities;
import mseries.utils.MComboBoxLayout;

public class BasicDateEntryUI
extends ComponentUI
implements PropertyChangeListener {
    protected JButton arrowButton;
    boolean isShowing = false;
    boolean mustClose = false;
    Action activator;
    Action openAction = new OpenAction();
    Action closeAction = new CloseAction();
    Action cancelAction = new CancelAction();
    MDateField display;
    MDateSelectorPanel panel;
    MPopup popup;
    Border border = null;
    MMonthListener mMonthListener;
    AncestorListener ancListener;
    MouseListener mouseListener;
    protected MDateEntryField dateEntry;
    private final Object classLock = new Object();
    private static final int MAX_CACHE_SIZE = 1;
    private final Vector lightPopupCache = new Vector(1);
    private static final Vector heavyPopupCache = new Vector(1);
    Dimension d;
    Runnable testFocus = new Runnable(){

        public void run() {
            if (!BasicDateEntryUI.this.display.hasFocus()) {
                BasicDateEntryUI.this.dateEntry.notifyListeners(new FocusEvent(BasicDateEntryUI.this.dateEntry, 1005));
            }
        }
    };
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JDialog;
    static /* synthetic */ Class class$java$awt$Window;

    public static ComponentUI createUI(JComponent x) {
        return new BasicDateEntryUI();
    }

    public void installUI(JComponent c) {
        this.dateEntry = (MDateEntryField)c;
        this.installComponents();
        this.configureDisplay(this.dateEntry.getDisplay());
        this.configureBorder(this.dateEntry);
        this.dateEntry.setLayout(this.createLayoutManager());
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.dateEntry.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected void installListeners() {
        this.activator = this.createActionListener();
        if (this.activator != null) {
            this.arrowButton.addActionListener(this.activator);
        }
        if ((this.ancListener = this.createAncestorListener()) != null) {
            this.dateEntry.addAncestorListener(this.ancListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.arrowButton.addMouseListener(this.mouseListener);
        }
        this.registerKeyboardActions();
        this.mMonthListener = this.createMMonthListener();
        this.dateEntry.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.arrowButton.removeActionListener(this.activator);
        this.arrowButton.removeMouseListener(this.mouseListener);
        this.dateEntry.addPropertyChangeListener(this);
        this.unRegisterKeyboardActions();
        this.dateEntry.removeAncestorListener(this.ancListener);
    }

    protected LayoutManager createLayoutManager() {
        return new MComboBoxLayout();
    }

    protected void installComponents() {
        this.display = this.dateEntry.getDisplay();
        this.dateEntry.add(this.display);
        this.arrowButton = this.createArrowButton();
        this.dateEntry.add(this.arrowButton);
    }

    protected void uninstallComponents() {
        this.arrowButton = null;
        this.dateEntry.removeAll();
    }

    protected JButton createArrowButton() {
        ArrowButton x = new ArrowButton(5);
        x.setBackground(this.dateEntry.getBackground());
        x.setForeground(this.dateEntry.getBackground());
        return x;
    }

    protected Insets getInsets() {
        return this.dateEntry.getInsets();
    }

    protected void configureBorder(JComponent c) {
        c.setBorder(BorderFactory.createEtchedBorder(MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow()));
    }

    public void configureDisplay(JComponent display) {
    }

    protected Action createActionListener() {
        return new OpenCloseAction();
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BasicDateEntryUI.this.display.requestFocus();
            }

            public void mouseReleased(MouseEvent e) {
                BasicDateEntryUI.this.mustClose = BasicDateEntryUI.this.isShowing;
            }

            public void mouseEntered(MouseEvent e) {
                BasicDateEntryUI.this.mustClose = BasicDateEntryUI.this.isShowing;
            }

            public void mouseExited(MouseEvent e) {
                BasicDateEntryUI.this.mustClose = BasicDateEntryUI.this.isShowing;
            }
        };
    }

    protected void registerKeyboardActions() {
        this.display.getInputMap().put(KeyStroke.getKeyStroke(40, 2), "OPEN");
        this.display.getActionMap().put("OPEN", this.openAction);
    }

    protected void unRegisterKeyboardActions() {
    }

    private void showPopup() {
        if (this.panel == null) {
            this.panel = this.createMDateSelectorPanel();
        }
        if (this.popup == null) {
            this.dateEntry.notifyListeners(new FocusEvent(this.dateEntry, 1004));
            this.dateEntry.opened();
            Point p = this.dateEntry.getLocationOnScreen();
            this.panel.setShowTodayButton(this.dateEntry.getShowTodayButton());
            this.panel.setCloseOnToday(this.dateEntry.getCloseOnToday());
            this.panel.setPullDownConstraints(this.dateEntry.getConstraints());
            this.panel.setBorder(this.createBorder());
            this.d = this.panel.getPreferredSize();
            if (this.checkLightPosition(this.dateEntry, p)) {
                this.popup = this.createLightWeightPopup();
            } else {
                this.checkHeavyPosition(this.dateEntry, p);
                this.popup = this.createHeavyWeightPopup();
            }
            if (this.display.getMinimum() != null) {
                this.panel.setMinimum(this.display.getMinimum());
            }
            if (this.display.getMaximum() != null) {
                this.panel.setMaximum(this.display.getMaximum());
            }
            this.panel.setDate(this.display.getValue(new Date()));
            this.panel.addMMonthListener(this.mMonthListener);
            this.popup.setShadow(this.dateEntry.getConstraints().hasShadow());
            this.popup.addComponent(this.panel, "Center");
            this.popup.pack();
            this.popup.setLocationOnScreen(p.x, p.y);
            this.popup.setParent(this.display);
            this.popup.setVisible(true);
            this.popup.requestFocus();
            this.dateEntry.notifyListeners(2);
        }
    }

    private void destroyPopup() {
        if (this.popup != null) {
            this.panel.removeMMonthListener(this.mMonthListener);
            this.popup.setVisible(false);
            this.dateEntry.notifyListeners(3);
            this.isShowing = false;
            this.popup.removeComponent(this.panel);
            switch (this.popup.getWeight()) {
                case 0: {
                    this.recycleLightPopup(this.popup);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        this.popup = null;
    }

    protected MDateSelectorPanel createMDateSelectorPanel() {
        MDateSelectorPanel panel = new MDateSelectorPanel();
        panel.setFocusCycleRoot(true);
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(38, 2), "CLOSE");
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "CLOSE");
        panel.getActionMap().put("CLOSE", this.closeAction);
        panel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        panel.getActionMap().put("CANCEL", this.cancelAction);
        return panel;
    }

    private boolean checkLightPosition(Component field, Point p) {
        if (SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = BasicDateEntryUI.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, field) == null && SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = BasicDateEntryUI.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, field) == null) {
            return false;
        }
        Container parent = SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = BasicDateEntryUI.class$("java.awt.Window")) : class$java$awt$Window, field);
        Point pr = parent.getLocationOnScreen();
        pr.x = p.x - pr.x;
        pr.y = p.y - pr.y;
        return this.getPositionRelative(this.d, field.getSize(), parent.getSize(), pr, p);
    }

    private boolean getPositionRelative(Dimension popupSize, Dimension fieldSize, Dimension parent, Point pr, Point p) {
        Point pos = new Point(p.x, p.y);
        if (pr.y + fieldSize.height + popupSize.height <= parent.height) {
            pos.y = p.y + fieldSize.height;
        } else if (pr.y - this.d.height >= 0) {
            pos.y = p.y - this.d.height;
        } else {
            return false;
        }
        if (pr.x + popupSize.width > parent.width) {
            if (pr.x + fieldSize.width - popupSize.width >= 0) {
                pos.x -= popupSize.width - fieldSize.width;
            } else {
                return false;
            }
        }
        p.x = pos.x;
        p.y = pos.y;
        return true;
    }

    private boolean checkHeavyPosition(Component field, Point p) {
        Point pr = field.getLocation();
        SwingUtilities.convertPointToScreen(pr, field);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return this.getPositionRelative(this.d, field.getSize(), screenSize, p, p);
    }

    private MPopup createLightWeightPopup() {
        MPopup p = this.getRecycledLightPopup();
        if (p == null) {
            p = new MPopupPanel();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPopup getRecycledLightPopup() {
        Object object = this.classLock;
        synchronized (object) {
            if (this.lightPopupCache.size() > 0) {
                MPopup r = (MPopup)this.lightPopupCache.elementAt(0);
                this.lightPopupCache.removeElementAt(0);
                return r;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleLightPopup(MPopup aPopup) {
        Object object = this.classLock;
        synchronized (object) {
            if (this.lightPopupCache.size() < 1) {
                this.lightPopupCache.addElement(aPopup);
            }
        }
    }

    private MPopup createHeavyWeightPopup() {
        MPopup p = this.getRecycledHeavyPopup();
        if (p == null) {
            Dialog d = ScreenUtilities.getParentDialog(this.display);
            if (d != null) {
                p = new MPopupDialog(d);
                return p;
            }
            Frame f = ScreenUtilities.getParentFrame(this.display);
            if (f != null) {
                p = new MPopupDialog(f);
                return p;
            }
        }
        return new MPopupWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPopup getRecycledHeavyPopup() {
        Object object = this.classLock;
        synchronized (object) {
            if (heavyPopupCache.size() > 0) {
                MPopup r = (MPopup)heavyPopupCache.elementAt(0);
                heavyPopupCache.removeElementAt(0);
                return r;
            }
            return null;
        }
    }

    private Border createBorder() {
        if (this.border == null) {
            Border innerBorder = BorderFactory.createEmptyBorder(2, 3, 0, 3);
            Border outerBorder = BorderFactory.createLineBorder(Color.black);
            return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        }
        return this.border;
    }

    protected MMonthListener createMMonthListener() {
        return new MMonthListener(){
            boolean echoSelection = true;

            public void dataChanged(MMonthEvent e) {
                int type = e.getType();
                if (type == 7) {
                    BasicDateEntryUI.this.destroyPopup();
                    BasicDateEntryUI.this.dateEntry.closed();
                    SwingUtilities.invokeLater(BasicDateEntryUI.this.testFocus);
                }
                if (type == 4) {
                    BasicDateEntryUI.this.display.setValue(e.getNewDate().getTime());
                    BasicDateEntryUI.this.destroyPopup();
                    BasicDateEntryUI.this.display.requestFocus();
                    BasicDateEntryUI.this.dateEntry.closed();
                }
                this.echoSelection = BasicDateEntryUI.this.dateEntry.getConstraints().isSelectionEventsEnabled();
                if ((type == 1 || type == 0 || type == 4) && this.echoSelection) {
                    BasicDateEntryUI.this.display.setValue(e.getNewDate().getTime());
                    BasicDateEntryUI.this.dateEntry.notifyListeners(0);
                }
            }
        };
    }

    protected AncestorListener createAncestorListener() {
        return new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                if (BasicDateEntryUI.this.isShowing) {
                    BasicDateEntryUI.this.destroyPopup();
                }
            }

            public void ancestorMoved(AncestorEvent event) {
                if (BasicDateEntryUI.this.isShowing) {
                    BasicDateEntryUI.this.destroyPopup();
                    BasicDateEntryUI.this.display.requestFocus();
                }
            }
        };
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String event = evt.getPropertyName();
        if (event.equals("enabled")) {
            Object o = evt.getNewValue();
            boolean enabled = (Boolean)o;
            this.display.setEnabled(enabled);
            this.arrowButton.setEnabled(enabled);
            if (enabled) {
                this.registerKeyboardActions();
            } else {
                this.unRegisterKeyboardActions();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CancelAction
    extends OpenCloseAction {
        protected CancelAction() {
        }

        protected String getActionCommand(ActionEvent e) {
            return "CANCEL";
        }
    }

    protected class CloseAction
    extends OpenCloseAction {
        protected CloseAction() {
        }

        protected String getActionCommand(ActionEvent e) {
            return "CLOSE";
        }
    }

    protected class OpenAction
    extends OpenCloseAction {
        protected OpenAction() {
        }

        protected String getActionCommand(ActionEvent e) {
            return "OPEN";
        }
    }

    protected class OpenCloseAction
    extends AbstractAction {
        protected OpenCloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = this.getActionCommand(e);
            if (command.equals("OPEN")) {
                BasicDateEntryUI.this.mustClose = false;
            }
            if (!BasicDateEntryUI.this.isShowing) {
                if (BasicDateEntryUI.this.mustClose) {
                    BasicDateEntryUI.this.display.requestFocus();
                    return;
                }
                BasicDateEntryUI.this.isShowing = true;
                BasicDateEntryUI.this.showPopup();
            } else {
                BasicDateEntryUI.this.isShowing = false;
                BasicDateEntryUI.this.panel.close(command);
            }
        }

        protected String getActionCommand(ActionEvent e) {
            return e.getActionCommand();
        }
    }
}

