/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import mseries.ui.DefaultSpinnerModel;

public class MDateSpinnerModel
extends DefaultSpinnerModel {
    private int step;
    private Calendar m_calendar = Calendar.getInstance();
    private Date maxDate;
    private Date minDate;
    private DateFormat df;
    private static final int UP = 1;
    private static final int DOWN = -1;

    public MDateSpinnerModel(Date start, Comparable max, Comparable min) {
        this.setMaximum(max);
        this.setMinimum(min);
        this.setValue(start);
    }

    public MDateSpinnerModel(Date start) {
        try {
            this.df = DateFormat.getDateInstance(3, new Locale("en", "GB"));
            this.maxDate = this.df.parse("31/12/2037");
            this.minDate = this.df.parse("1/1/1970");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setValue(start);
    }

    public MDateSpinnerModel() {
        this(new Date());
    }

    public void setStep(int step) {
        this.step = step;
    }

    private int getStep() {
        return this.step;
    }

    public Object getValue() {
        return this.m_calendar.getTime();
    }

    public void setValue(Object newValue) {
        Date x = (Date)newValue;
        if (!x.before(this.minDate) && !x.after(this.maxDate)) {
            this.m_calendar.setTime(x);
            this.notifyListeners();
        }
    }

    public void setMaximum(Comparable max) {
        Date d;
        if (max instanceof Date) {
            this.maxDate = (Date)max;
        }
        if ((d = (Date)this.getValue()).after(this.maxDate)) {
            this.setValue(this.maxDate);
        }
    }

    public Comparable getMaximum() {
        return this.maxDate;
    }

    public void setMinimum(Comparable min) {
        Date d;
        if (min instanceof Date) {
            this.minDate = (Date)min;
        }
        if ((d = (Date)this.getValue()).before(this.minDate)) {
            this.setValue(this.minDate);
        }
    }

    public Comparable getMinimum() {
        return this.minDate;
    }

    public Object getNextValue() {
        Date d = (Date)this.changeValue(this.getStep(), 1);
        if (!d.after(this.maxDate)) {
            this.setValue(d);
        }
        return this.getValue();
    }

    public Object getPreviousValue() {
        Date d = (Date)this.changeValue(this.getStep(), -1);
        if (!d.before(this.minDate)) {
            this.setValue(d);
        }
        return this.getValue();
    }

    private Object changeValue(int step, int dir) {
        Calendar cal = (Calendar)this.m_calendar.clone();
        Date m_lastDate = cal.getTime();
        int d = cal.get(5);
        cal.set(5, 1);
        boolean dateSet = true;
        switch (step) {
            case 14: {
                int ampm = cal.get(9);
                int mult = ampm == 0 ? 12 : -12;
                cal.set(10, cal.get(10) + mult);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                cal.set(6, cal.get(6) + dir);
                break;
            }
            case 0: {
                dateSet = false;
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 16: {
                cal.set(10, cal.get(10) + dir);
                break;
            }
            case 8: {
                cal.set(14, cal.get(14) + dir);
                break;
            }
            case 6: {
                cal.set(12, cal.get(12) + dir);
                break;
            }
            case 2: {
                cal.set(2, cal.get(2) + dir);
                int max = cal.getActualMaximum(5);
                cal.set(5, d > max ? max : d);
                m_lastDate = cal.getTime();
                break;
            }
            case 7: {
                cal.set(13, cal.get(13) + dir);
                break;
            }
            case 13: {
                cal.set(4, cal.get(4) + dir);
                break;
            }
            case 12: {
                cal.set(4, cal.get(4) + dir);
                break;
            }
            case 1: {
                cal.set(1, cal.get(1) + dir);
                break;
            }
            default: {
                dateSet = false;
            }
        }
        if (dateSet) {
            m_lastDate = cal.getTime();
        }
        return m_lastDate;
    }
}

