/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.util.HashSet;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ScreenUtilities {
    public static Container getParentWindow(Component c) {
        Container parent = null;
        if (c != null) {
            parent = c.getParent();
        }
        Container p = parent;
        while (p != null) {
            if (p instanceof JRootPane) {
                if (!(p.getParent() instanceof JInternalFrame)) {
                    parent = ((JRootPane)p).getLayeredPane();
                    p = parent.getParent();
                    while (p != null && !(p instanceof Window)) {
                        p = p.getParent();
                    }
                    break;
                }
            } else if (p instanceof Window) {
                parent = p;
                break;
            }
            p = p.getParent();
        }
        return parent;
    }

    public static Point convertScreenLocationToParent(Container parent, int x, int y) {
        Window parentWindow = null;
        Container p = parent;
        while (p != null) {
            if (p instanceof Window) {
                parentWindow = (Window)p;
                break;
            }
            p = p.getParent();
        }
        if (parentWindow != null) {
            Point p2 = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p2, parent);
            return p2;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor found");
    }

    public static Dialog getParentDialog(Component child) {
        Dialog parentWindow = null;
        Container p = child.getParent();
        while (p != null) {
            if (p instanceof Dialog) {
                parentWindow = (Dialog)p;
                break;
            }
            p = p.getParent();
        }
        return parentWindow;
    }

    public static Frame getParentFrame(Component child) {
        Frame parentWindow = null;
        Container p = child.getParent();
        while (p != null) {
            if (p instanceof Frame) {
                parentWindow = (Frame)p;
                break;
            }
            p = p.getParent();
        }
        return parentWindow;
    }

    public static HashSet getDefaultFocusTraversalKeys(int id) {
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>();
        switch (id) {
            case 0: {
                keys.add(KeyStroke.getKeyStroke(9, 2));
                break;
            }
            case 1: {
                keys.add(KeyStroke.getKeyStroke(9, 3));
            }
        }
        return keys;
    }
}

