/*
 * Decompiled with CFR 0.152.
 */
package mseries.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Arrays;
import mseries.utils.FormConstraints;
import mseries.utils.FormLayout;

class FormLayoutInfo
implements Serializable {
    public static final String REVISION_ID = "$Id: FormLayout.java,v 1.3 2003/03/26 23:29:51 martin Exp $";
    public static final String REVISION_TAG = "$Name:  $";
    int colsNotAtMin;
    boolean[] atMin;
    int width;
    int height;
    int[] colWidth;
    int[] rowHeight;
    int[] minWidth;
    int[] minHeight;
    int[] actualWidth;
    int[] actualHeight;
    boolean doneStatic = false;
    FormLayout master;

    FormLayoutInfo(FormLayout master) {
        this.master = master;
        this.colWidth = new int[20];
        this.rowHeight = new int[20];
        this.actualWidth = new int[20];
        this.actualHeight = new int[20];
        this.minWidth = new int[20];
        this.minHeight = new int[20];
        this.height = 0;
        this.width = 0;
        this.atMin = new boolean[20];
        Arrays.fill(this.atMin, false);
        this.colsNotAtMin = this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateLayoutInfo(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Arrays.fill(this.atMin, false);
            this.setStaticLayoutInfo(parent.getComponents());
        }
    }

    void setStaticLayoutInfo(Component[] components) {
        int curY = -1;
        int curX = -1;
        int compindex = 0;
        while (compindex < components.length) {
            Component comp = components[compindex];
            if (comp.isVisible()) {
                Dimension dp;
                FormConstraints constraints = this.master.lookupConstraints(comp);
                curX = constraints.gridx == -1 ? curX + 1 : constraints.gridx;
                curY = constraints.gridy == -1 ? curY + 1 : constraints.gridy;
                constraints.tempX = curX;
                constraints.tempY = curY;
                Insets compInsets = constraints.insets;
                this.width = Math.max(curX + 1, this.width);
                this.height = Math.max(curY + 1, this.height);
                if (!constraints.spansColumns) {
                    dp = comp.getPreferredSize();
                } else {
                    int h = comp.getPreferredSize().height;
                    dp = new Dimension(35, h);
                }
                this.colWidth[curX] = Math.max(this.colWidth[curX], dp.width + compInsets.left + compInsets.right);
                this.rowHeight[curY] = Math.max(this.rowHeight[curY], dp.height + compInsets.top + compInsets.bottom);
                Dimension dm = comp.getMinimumSize();
                this.minWidth[curX] = Math.max(this.minWidth[curX], dm.width + compInsets.left + compInsets.right);
                this.minHeight[curY] = Math.max(this.minHeight[curY], dm.height + compInsets.top + compInsets.bottom);
                this.actualWidth[curX] = this.colWidth[curX];
                this.actualHeight[curX] = this.rowHeight[curX];
                this.colsNotAtMin = this.width;
            }
            ++compindex;
        }
    }

    public String toString() {
        String ret = "[" + this.getClass().getName() + ": \n" + "  width=" + this.width + ", height=" + this.height + ", \n";
        ret = ret + "  Preferred Widths \n";
        int i = 0;
        while (i < this.width) {
            ret = ret + "    [" + i + "] = " + this.colWidth[i] + "\n";
            ++i;
        }
        ret = ret + "  Preferred Heights \n";
        int i2 = 0;
        while (i2 < this.height) {
            ret = ret + "    [" + i2 + "] = " + this.rowHeight[i2] + "\n";
            ++i2;
        }
        ret = ret + "  Minimum Widths \n";
        int i3 = 0;
        while (i3 < this.width) {
            ret = ret + "    [" + i3 + "] = " + this.minWidth[i3] + "\n";
            ++i3;
        }
        ret = ret + "  Minimum Heights \n";
        int i4 = 0;
        while (i4 < this.height) {
            ret = ret + "    [" + i4 + "] = " + this.minHeight[i4] + "\n";
            ++i4;
        }
        return ret;
    }

    Dimension getMinimumSize() {
        int t = 0;
        Dimension d = new Dimension(1, 1);
        int i = 0;
        while (i < this.width) {
            t += this.minWidth[i];
            ++i;
        }
        d.width = t;
        t = 0;
        i = 0;
        while (i < this.height) {
            t += this.minHeight[i];
            ++i;
        }
        d.height = t;
        return d;
    }

    Dimension getPreferredSize() {
        int t = 0;
        Dimension d = new Dimension(1, 1);
        int i = 0;
        while (i < this.width) {
            t += this.colWidth[i];
            ++i;
        }
        d.width = t;
        t = 0;
        i = 0;
        while (i < this.height) {
            t += this.rowHeight[i];
            ++i;
        }
        d.height = t;
        return d;
    }

    int getColsNotAtMin() {
        int t = 0;
        int i = 0;
        while (i < this.width) {
            t += this.atMin[i] ? 0 : 1;
            ++i;
        }
        return t;
    }

    int getActualWidth() {
        int t = 0;
        int i = 0;
        while (i < this.width) {
            t += this.actualWidth[i];
            ++i;
        }
        return t;
    }
}

