/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComObjectListener;
import com4j.ComThread;
import com4j.GUID;
import com4j.IID;
import com4j.Native;
import com4j.ROT;
import com4j.Task;
import com4j.Wrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class COM4J {
    public static final GUID IID_IUnknown = new GUID("{00000000-0000-0000-C000-000000000046}");
    public static final GUID IID_IDispatch = new GUID("{00020400-0000-0000-C000-000000000046}");
    public static final GUID IID_IPicture = new GUID("{7BF80980-BF32-101A-8BBB-00AA00300CAB}");
    public static final GUID IID_IPictureDisp = new GUID("{7BF80981-BF32-101A-8BBB-00AA00300CAB}");
    public static final GUID IID_IFont = new GUID("{BEF6E002-A874-101A-8BBA-00AA00300CAB}");
    public static final GUID IID_IFontDisp = new GUID("{BEF6E003-A874-101A-8BBA-00AA00300CAB}");
    protected static ArrayList<Runnable> applicationShutdownTasks = new ArrayList();
    protected static ArrayList<Runnable> com4JShutdownTasks = new ArrayList();
    private static final Logger LOGGER;

    private COM4J() {
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, GUID clsid) throws ComException {
        return COM4J.createInstance(primaryInterface, clsid.toString());
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, String clsid) throws ComException {
        return COM4J.createInstance(primaryInterface, clsid, 23);
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, String clsid, int clsctx) throws ComException {
        return (T)((Com4jObject)new CreateInstanceTask<T>(clsid, clsctx, primaryInterface).execute());
    }

    public static <T extends Com4jObject> T wrap(final Class<T> primaryInterface, final long ptr) throws ComException {
        return (T)((Com4jObject)new Task<T>(){

            @Override
            public T call() {
                return Wrapper.create(primaryInterface, ptr);
            }
        }.execute());
    }

    public static <T extends Com4jObject> T getActiveObject(Class<T> primaryInterface, GUID clsid) {
        return (T)((Com4jObject)new GetActiveObjectTask<T>(clsid, primaryInterface).execute());
    }

    public static <T extends Com4jObject> T getActiveObject(Class<T> primaryInterface, String clsid) {
        return COM4J.getActiveObject(primaryInterface, new GUID(clsid));
    }

    public static <T extends Com4jObject> T getObject(Class<T> primaryInterface, String fileName, String progId) {
        return (T)((Com4jObject)new GetObjectTask(fileName, progId, primaryInterface).execute());
    }

    public static ROT getROT() {
        return ROT.getInstance();
    }

    public static GUID getIID(Class<?> _interface) {
        IID iid = _interface.getAnnotation(IID.class);
        if (iid == null) {
            throw new IllegalArgumentException(_interface.getName() + " doesn't have @IID annotation");
        }
        return new GUID(iid.value());
    }

    public static Com4jObject loadTypeLibrary(final File typeLibraryFile) {
        return (Com4jObject)new Task<Com4jObject>(){

            @Override
            public Com4jObject call() {
                return Wrapper.create(Native.loadTypeLibrary(typeLibraryFile.getAbsolutePath()));
            }
        }.execute();
    }

    public static ByteBuffer createBuffer(long ptr, int size) {
        return Native.createBuffer(ptr, size);
    }

    public static void addListener(ComObjectListener listener) {
        ComThread.get().addListener(listener);
    }

    public static void removeListener(ComObjectListener listener) {
        ComThread.get().removeListener(listener);
    }

    public static void cleanUp() {
        ComThread.detach();
    }

    public static void addShutdownTask(Runnable task) {
        applicationShutdownTasks.add(task);
    }

    public static boolean removeShutdownTask(Runnable task) {
        return applicationShutdownTasks.remove(task);
    }

    static void addCom4JShutdownTask(Runnable task) {
        com4JShutdownTasks.add(task);
    }

    static long queryInterface(long ptr, GUID iid) {
        return Native.queryInterface(ptr, iid.v[0], iid.v[1]);
    }

    static Wrapper unwrap(Com4jObject obj) {
        if (obj instanceof Wrapper) {
            return (Wrapper)obj;
        }
        return (Wrapper)Proxy.getInvocationHandler(obj);
    }

    @Deprecated
    static long getPtr(Com4jObject obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getPointer();
    }

    private static void loadNativeLibrary() {
        try {
            System.loadLibrary("com4j-" + System.getProperty("os.arch"));
            return;
        }
        catch (Throwable t) {
            Throwable cause = t;
            URL res = COM4J.class.getClassLoader().getResource("com4j/COM4J.class");
            String url = res.toExternalForm();
            if (url.startsWith("jar:")) {
                int idx = url.lastIndexOf(33);
                String filePortion = url.substring(4, idx);
                while (filePortion.startsWith("/")) {
                    filePortion = filePortion.substring(1);
                }
                if (filePortion.startsWith("file:/")) {
                    if ((filePortion = filePortion.substring(6)).startsWith("//")) {
                        filePortion = filePortion.substring(2);
                    }
                    try {
                        filePortion = URLDecoder.decode(filePortion, System.getProperty("file.encoding"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    File jarFile = new File(filePortion);
                    String fileName = "com4j-" + System.getProperty("os.arch") + ".dll";
                    File dllFile = new File(jarFile.getParentFile(), fileName);
                    if (!dllFile.exists()) {
                        try {
                            InputStream in = COM4J.class.getResourceAsStream(fileName);
                            if (in == null) {
                                throw new IOException(fileName + " not bundled in the resource. Packaging problem?");
                            }
                            COM4J.copyStream(in, new FileOutputStream(dllFile));
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to write com4j.dll", e);
                        }
                    }
                    System.load(dllFile.getPath());
                    return;
                }
            }
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Unable to load com4j.dll");
            error.initCause(cause);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("Com4J shutdown hook"){

            @Override
            public void run() {
                int i;
                for (i = applicationShutdownTasks.size() - 1; i >= 0; --i) {
                    applicationShutdownTasks.get(i).run();
                }
                for (i = com4JShutdownTasks.size() - 1; i >= 0; --i) {
                    com4JShutdownTasks.get(i).run();
                }
            }
        });
        COM4J.loadNativeLibrary();
        LOGGER = Logger.getLogger(COM4J.class.getName());
    }

    private static class GetObjectTask<T extends Com4jObject>
    extends Task<T> {
        private final String fileName;
        private final String progId;
        private final Class<T> intf;

        private GetObjectTask(String fileName, String progId, Class<T> intf) {
            this.fileName = fileName;
            this.progId = progId;
            this.intf = intf;
        }

        @Override
        public T call() {
            GUID iid = COM4J.getIID(this.intf);
            long o1 = Native.getObject(this.fileName, this.progId);
            long o2 = Native.queryInterface(o1, iid.v[0], iid.v[1]);
            Native.release(o1);
            return Wrapper.create(this.intf, o2);
        }
    }

    private static class GetActiveObjectTask<T extends Com4jObject>
    extends Task<T> {
        private final GUID clsid;
        private final Class<T> intf;

        public GetActiveObjectTask(GUID clsid, Class<T> intf) {
            this.clsid = clsid;
            this.intf = intf;
        }

        @Override
        public T call() {
            GUID iid = COM4J.getIID(this.intf);
            long o1 = Native.getActiveObject(this.clsid.v[0], this.clsid.v[1]);
            long o2 = Native.queryInterface(o1, iid.v[0], iid.v[1]);
            Native.release(o1);
            return Wrapper.create(this.intf, o2);
        }
    }

    private static class CreateInstanceTask<T extends Com4jObject>
    extends Task<T> {
        private final String clsid;
        private final int clsctx;
        private final Class<T> intf;

        public CreateInstanceTask(String clsid, int clsctx, Class<T> intf) {
            this.clsid = clsid;
            this.clsctx = clsctx;
            this.intf = intf;
        }

        @Override
        public T call() {
            GUID iid = COM4J.getIID(this.intf);
            return Wrapper.create(this.intf, Native.createInstance(this.clsid, this.clsctx, iid.v[0], iid.v[1]));
        }
    }
}

