/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComEnum;
import com4j.ComThread;
import com4j.EnumDictionary;
import com4j.Task;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.GregorianCalendar;

public final class Variant
extends Number {
    final ByteBuffer image = ByteBuffer.allocateDirect(16);
    ComThread thread = null;
    private static final int ARRAY = 8192;
    private static final int MISSING_ERROR_CODE = -2147352572;
    public static final Variant MISSING = new Variant();
    private static final long MSPD = 86400000L;

    public Variant() {
        this.image.order(ByteOrder.LITTLE_ENDIAN);
        byte[] b = new byte[16];
        this.image.put(b);
        this.image.position(0);
    }

    public Variant(Type type) {
        this();
        this.setType(type);
    }

    public void clear() {
        Variant.clear0(this.image);
    }

    public void finalize() {
        this.clear();
    }

    private static native void clear0(ByteBuffer var0);

    public void setType(Type t) {
        this.image.putLong(0, t.comEnumValue());
    }

    public Type getType() {
        int varType = this.image.getInt(0) & 0xFFFF;
        return EnumDictionary.get(Type.class).constant(varType);
    }

    private static native void changeType0(int var0, ByteBuffer var1);

    private void changeType(Type t) {
        if (this.getType() != t) {
            Variant.changeType0(t.comEnumValue(), this.image);
        }
    }

    @Override
    public byte byteValue() {
        this.changeType(Type.VT_I1);
        byte[] b = new byte[1];
        this.image.get(b);
        return b[0];
    }

    public void set(byte i) {
        this.changeType(Type.VT_I1);
        this.image.putInt(8, i);
    }

    @Override
    public short shortValue() {
        this.changeType(Type.VT_I2);
        return this.image.getShort(8);
    }

    public void set(short i) {
        this.changeType(Type.VT_I2);
        this.image.putInt(8, i);
    }

    @Override
    public int intValue() {
        this.changeType(Type.VT_I4);
        return this.image.getInt(8);
    }

    public void set(int i) {
        this.changeType(Type.VT_I4);
        this.image.putInt(8, i);
    }

    @Override
    public long longValue() {
        this.changeType(Type.VT_I8);
        return this.image.getLong(8);
    }

    public void set(long i) {
        this.changeType(Type.VT_I8);
        this.image.putLong(8, i);
    }

    void makeError(int hresult) {
        this.clear();
        this.image.putShort(0, (short)Type.VT_ERROR.comEnumValue());
        this.image.putInt(8, hresult);
    }

    public int getError() {
        return this.image.getInt(8);
    }

    @Override
    public float floatValue() {
        this.changeType(Type.VT_R4);
        return this.image.getFloat(8);
    }

    public void set(float f) {
        this.changeType(Type.VT_R4);
        this.image.putFloat(8, f);
    }

    @Override
    public double doubleValue() {
        this.changeType(Type.VT_R8);
        return this.image.getDouble(8);
    }

    public void set(double d) {
        this.changeType(Type.VT_R8);
        this.image.putDouble(8, d);
    }

    public void set(boolean b) {
        this.changeType(Type.VT_BOOL);
        this.image.putShort(8, (short)(b ? 65535 : 0));
    }

    public boolean booleanValue() {
        this.changeType(Type.VT_BOOL);
        return this.image.getShort(8) == 65535;
    }

    public String stringValue() {
        return this.convertTo(String.class);
    }

    public void set(String value) {
        this.set0(value, this.image);
    }

    public Object get() {
        return this.get0(this.image);
    }

    private native void set0(Object var1, ByteBuffer var2);

    private native Object get0(ByteBuffer var1);

    public String getParseableString() {
        switch (this.getType()) {
            case VT_I1: 
            case VT_I2: 
            case VT_I4: 
            case VT_INT: {
                return Integer.toString(this.intValue());
            }
            case VT_I8: {
                return Long.toString(this.longValue());
            }
            case VT_R4: {
                return Float.toString(this.floatValue());
            }
            case VT_R8: {
                return Double.toString(this.doubleValue());
            }
            case VT_BSTR: {
                return this.stringValue();
            }
            case VT_NULL: {
                return "null";
            }
            case VT_BOOL: {
                return Boolean.toString(this.booleanValue());
            }
            case VT_ERROR: {
                return Integer.toHexString(this.getError());
            }
        }
        System.err.println("Don't know how to print " + this.getType().name() + " as an Java literal");
        return null;
    }

    public String getJavaCode() {
        switch (this.getType()) {
            case VT_I1: {
                return "(byte) " + Integer.toString(this.intValue());
            }
            case VT_I2: {
                return "(short) " + Integer.toString(this.intValue());
            }
            case VT_I4: 
            case VT_INT: {
                return Integer.toString(this.intValue());
            }
            case VT_I8: {
                return Long.toString(this.longValue()) + "L";
            }
            case VT_R4: {
                return Float.toString(this.floatValue()) + "f";
            }
            case VT_R8: {
                return Double.toString(this.doubleValue());
            }
            case VT_BSTR: {
                return "\"" + this.stringValue() + "\"";
            }
            case VT_NULL: {
                return "null";
            }
            case VT_BOOL: {
                return Boolean.toString(this.booleanValue());
            }
            case VT_ERROR: {
                if (!this.isMissing()) break;
                return "com4j.Variant.getMissing()";
            }
        }
        System.err.println("Don't know how to print " + this.getType().name() + " as Java program code");
        return null;
    }

    public <T extends Com4jObject> T object(final Class<T> type) {
        ComThread t = this.thread != null ? this.thread : ComThread.get();
        return (T)((Com4jObject)t.execute(new Task<T>(){

            @Override
            public T call() {
                Com4jObject wrapper = Variant.this.convertTo(Com4jObject.class);
                if (null == wrapper) {
                    return null;
                }
                Object ret = wrapper.queryInterface(type);
                wrapper.dispose();
                return ret;
            }
        }));
    }

    public native <T> T convertTo(Class<T> var1);

    public static Variant getMissing() {
        Variant v = new Variant();
        v.makeError(-2147352572);
        return v;
    }

    public boolean isMissing() {
        if (this.getType() != Type.VT_ERROR) {
            return false;
        }
        return this.getError() == -2147352572;
    }

    static Date toDate(double d) {
        GregorianCalendar ret = new GregorianCalendar(1899, 11, 30);
        int days = (int)d;
        d -= (double)days;
        ret.add(5, days);
        int hours = (int)(d *= 24.0);
        ret.add(10, hours);
        d -= (double)hours;
        int min = (int)(d *= 60.0);
        ret.add(12, min);
        d -= (double)min;
        int secs = (int)(d *= 60.0);
        ret.add(13, secs);
        return ret.getTime();
    }

    static double fromDate(Date dt) {
        long t = dt.getTime();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(dt);
        t += (long)(c.get(15) + c.get(16));
        if ((t += 2209161600000L) < 0L) {
            long offset = -(t % 86400000L);
            t = t - 86400000L + offset;
        }
        double d = (double)t / 8.64E7;
        return d;
    }

    public String toString() {
        byte[] b = new byte[16];
        this.image.position(0);
        this.image.get(b, 0, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toHexString(b[i]));
        }
        return sb.toString();
    }

    public static enum Type implements ComEnum
    {
        NO_TYPE(0),
        VT_EMPTY(0),
        VT_NULL(1),
        VT_I2(2),
        VT_I4(3),
        VT_R4(4),
        VT_R8(5),
        VT_CY(6),
        VT_DATE(7),
        VT_BSTR(8),
        VT_DISPATCH(9),
        VT_ERROR(10),
        VT_BOOL(11),
        VT_VARIANT(12),
        VT_UNKNOWN(13),
        VT_DECIMAL(14),
        VT_I1(16),
        VT_UI1(17),
        VT_UI2(18),
        VT_UI4(19),
        VT_I8(20),
        VT_INT(22),
        VT_UINT(23),
        VT_RECORD(36),
        VT_ARRAY_I2(0x2000 | Type.VT_I2.value),
        VT_ARRAY_I4(0x2000 | Type.VT_I4.value),
        VT_ARRAY_R4(0x2000 | Type.VT_R4.value),
        VT_ARRAY_R8(0x2000 | Type.VT_R8.value),
        VT_ARRAY_CY(0x2000 | Type.VT_CY.value),
        VT_ARRAY_DATE(0x2000 | Type.VT_DATE.value),
        VT_ARRAY_BSTR(0x2000 | Type.VT_BSTR.value),
        VT_ARRAY_BOOL(0x2000 | Type.VT_BOOL.value),
        VT_ARRAY_VARIANT(0x2000 | Type.VT_VARIANT.value),
        VT_ARRAY_DECIMAL(0x2000 | Type.VT_DECIMAL.value),
        VT_ARRAY_I1(0x2000 | Type.VT_I1.value),
        VT_ARRAY_UI1(0x2000 | Type.VT_UI1.value),
        VT_ARRAY_UI2(0x2000 | Type.VT_UI2.value),
        VT_ARRAY_UI4(0x2000 | Type.VT_UI4.value),
        VT_ARRAY_INT(0x2000 | Type.VT_INT.value),
        VT_ARRAY_UINT(0x2000 | Type.VT_UINT.value);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        @Override
        public int comEnumValue() {
            return this.value;
        }
    }
}

