/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr;

import com.ice.jni.registry.RegBinaryValue;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegMultiStringValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import com.shfarr.BasicUtils;
import java.util.Enumeration;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RegistryUtils {
    private static RegistryUtils regUtils;
    public final int ACCESS_READ = 1;
    public final int ACCESS_WRITE = 2;
    public final int ACCESS_DEFAULT = 0;
    public final int ACCESS_ALL = 4;
    public final int ACCESS_EXECUTE = 3;

    private RegistryUtils() {
    }

    public static RegistryUtils getInstance() {
        if (regUtils == null) {
            regUtils = new RegistryUtils();
        }
        return regUtils;
    }

    public String getRegistryValue(RegistryKey regkey, String valueName) {
        try {
            return new String(regkey.getValue(valueName).getByteData()).trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public HashMap getRegistryKeys(Object[] keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < keys.length) {
            block16: {
                RegistryKey root;
                String current;
                block15: {
                    block14: {
                        current = (String)keys[i];
                        root = null;
                        if (!current.startsWith("${")) break block14;
                        if (!current.equalsIgnoreCase("${ip}")) break block15;
                        StringBuffer buffer = new StringBuffer();
                        try {
                            RegistryKey clientIP = Registry.HKEY_LOCAL_MACHINE.createSubKey("SYSTEM\\CurrentControlSet\\Services", "", 1);
                            Enumeration e = clientIP.keyElements();
                            while (e.hasMoreElements()) {
                                String ip;
                                RegistryKey tcpKey = this.searchForTCPKey(clientIP.openSubKey((String)e.nextElement()), "Parameters");
                                if (tcpKey == null || (ip = new String(tcpKey.getValue("IPAddress").getByteData()).trim()).equals("0.0.0.0")) continue;
                                if (buffer.length() != 0) {
                                    buffer.append(";" + ip);
                                    continue;
                                }
                                buffer.append(ip);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("An error occured: " + ex.getMessage());
                        }
                        result.put(current, this.encode(buffer.toString()));
                        break block16;
                    }
                    root = this.getRootKey(current);
                }
                if (root == null) {
                    System.out.println("Error parsing the key: " + current);
                } else {
                    try {
                        RegistryKey key = this.getRegistryKey(current, 1);
                        if (key != null) {
                            String name = current.substring(current.lastIndexOf("\\") + 1);
                            if (name.equals("*")) {
                                HashMap<String, Object> values = new HashMap<String, Object>();
                                Enumeration e = key.valueElements();
                                while (e.hasMoreElements()) {
                                    String crt = (String)e.nextElement();
                                    if (key.getStringValue(crt).trim().length() != 0) {
                                        values.put(crt, this.encode(key.getStringValue(crt).trim()));
                                        continue;
                                    }
                                    RegistryValue value = key.getValue(crt);
                                    if (value.getName().equals("")) continue;
                                    values.put(value.getName(), this.encode(this.getRegistryValue(value)));
                                }
                                result.put(current, values);
                            } else {
                                result.put(current, this.encode(this.getRegistryValue(key.getValue(name.trim()))));
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        result.put(current, null);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public RegistryKey getRegistryKey(String keyPath, int access) {
        try {
            return this.getRootKey(keyPath).openSubKey(keyPath.substring(keyPath.indexOf("\\") + 1, keyPath.lastIndexOf("\\")), access);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public RegistryKey getRootKey(String keyName) {
        RegistryKey root = null;
        if (keyName.startsWith("HKEY_CLASSES_ROOT")) {
            root = Registry.HKEY_CLASSES_ROOT;
        } else if (keyName.startsWith("HKEY_CURRENT_CONFIG")) {
            root = Registry.HKEY_CURRENT_CONFIG;
        } else if (keyName.startsWith("HKEY_CURRENT_USER")) {
            root = Registry.HKEY_CURRENT_USER;
        } else if (keyName.startsWith("HKEY_DYN_DATA")) {
            root = Registry.HKEY_DYN_DATA;
        } else if (keyName.startsWith("HKEY_LOCAL_MACHINE")) {
            root = Registry.HKEY_LOCAL_MACHINE;
        } else if (keyName.startsWith("HKEY_PERFORMANCE_DATA")) {
            root = Registry.HKEY_PERFORMANCE_DATA;
        } else if (keyName.startsWith("HKEY_USERS")) {
            root = Registry.HKEY_USERS;
        }
        return root;
    }

    private RegistryKey searchForTCPKey(RegistryKey parent, String searchFor) {
        try {
            Enumeration e = parent.keyElements();
            while (e.hasMoreElements()) {
                RegistryKey current = parent.openSubKey((String)e.nextElement());
                if (!current.getName().equals(searchFor)) continue;
                if (searchFor.equals("Parameters")) {
                    return this.searchForTCPKey(current, "Tcpip");
                }
                return current;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public HashMap getLocalNetworkSetting() {
        HashMap<String, String> result = new HashMap<String, String>();
        String pKey = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\*";
        HashMap inetSet = this.getRegistryKeys(new String[]{pKey});
        HashMap proxy = (HashMap)inetSet.get(pKey);
        result.put("ProxyEnabled", (String)proxy.get("ProxyEnable"));
        if (this.decode((String)proxy.get("ProxyEnable")).equals("1")) {
            String proxyServer = (String)this.decode(proxy.get("ProxyServer"));
            result.put("ProxyIP", proxyServer.substring(0, proxyServer.indexOf(":")));
            result.put("ProxyPort", proxyServer.substring(proxyServer.indexOf(":") + 1));
        }
        return result;
    }

    public String getRegistryValue(RegistryValue value) {
        switch (value.getType()) {
            case 4: {
                return String.valueOf(((RegDWordValue)value).getData());
            }
            case 3: {
                return new String(((RegBinaryValue)value).getData()).trim();
            }
            case 1: 
            case 2: {
                return ((RegStringValue)value).getData().trim();
            }
            case 7: {
                return BasicUtils.pack(((RegMultiStringValue)value).getData(), "|");
            }
        }
        return null;
    }

    public void setRegistryValue(String keyPath, String newValue) {
        RegistryKey key = this.getRegistryKey(keyPath, 4);
        this.setRegistryValue(key, keyPath.substring(keyPath.lastIndexOf("\\") + 1), newValue);
    }

    public void setRegistryValue(RegistryKey key, String attributeName, String newValue) {
        try {
            int attributeType = 0;
            try {
                RegistryValue attr = key.getValue(attributeName);
                attributeType = attr.getType();
            }
            catch (Exception ex) {
                attributeType = 2;
            }
            switch (attributeType) {
                case 1: 
                case 2: {
                    key.setValue((RegistryValue)new RegStringValue(key, attributeName, newValue));
                    break;
                }
                case 4: {
                    key.setValue((RegistryValue)new RegDWordValue(key, attributeName, 4, Integer.parseInt(newValue)));
                    break;
                }
                case 3: {
                    key.setValue((RegistryValue)new RegBinaryValue(key, attributeName, newValue.getBytes()));
                    break;
                }
                case 7: {
                    key.setValue((RegistryValue)new RegMultiStringValue(key, attributeName, BasicUtils.unpack(newValue, '|')));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setProxySettings() {
        HashMap network = RegistryUtils.getInstance().getLocalNetworkSetting();
        if (network.get("ProxyEnabled") != null && RegistryUtils.getInstance().decode(network.get("ProxyEnabled")).equals("1") && System.getProperty("http.proxyHost") == null && System.getProperty("http.proxyPort") == null) {
            if (network.get("ProxyIP") != null) {
                System.setProperty("http.proxyHost", (String)network.get("ProxyIP"));
            }
            if (network.get("ProxyPort") != null) {
                System.setProperty("http.proxyPort", (String)network.get("ProxyPort"));
            }
        }
    }

    public Object encode(Object obj) {
        return new BASE64Encoder().encodeBuffer(((String)obj).getBytes());
    }

    public Object decode(Object obj) {
        try {
            if (obj instanceof String) {
                return new String(new BASE64Decoder().decodeBuffer((String)obj));
            }
        }
        catch (Exception ex) {
            System.out.println("An error occured: " + ex.getMessage());
        }
        return obj;
    }
}

