/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private String openedFromURL;
    private Document doc;

    public XMLUtils(String pathToXML) {
        this.openedFromURL = pathToXML;
        this.doc = this.getDocument(pathToXML);
    }

    public void save() {
        this.saveAs(this.openedFromURL);
    }

    public void saveAs(String newLocation) {
        try {
            String url = this.getClass().getResource(newLocation).toString();
            url = url.substring(5);
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(URLDecoder.decode(url))));
            OutputFormat outForm = new OutputFormat(this.doc);
            XMLSerializer serializer = new XMLSerializer((Writer)out, outForm);
            outForm.setIndenting(true);
            serializer.serialize(this.doc.getDocumentElement());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getChildCount(String pathToElement, String childsNameToCount, String attrName, String attrValue) {
        int childCount = 0;
        try {
            Element parent = this.getElement(pathToElement);
            NodeList nl = parent.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeName().startsWith(childsNameToCount)) {
                    if (attrName == null || attrName.equals("") || attrValue == null) {
                        ++childCount;
                    } else if (this.getElement(String.valueOf(pathToElement) + "/" + nl.item(i).getNodeName()).getAttribute(attrName).equals(attrValue)) {
                        ++childCount;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return childCount;
    }

    public int getChildCount(String pathToElement, String childsNameToCount) {
        return this.getChildCount(pathToElement, childsNameToCount, null, null);
    }

    public Node getChildNamed(String pathToElement, String childName, boolean caseSensitive) {
        NodeList childs = this.getElement(pathToElement).getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            if (caseSensitive ? childs.item(i).getNodeName().equals(childName) : childs.item(i).getNodeName().equalsIgnoreCase(childName)) {
                return childs.item(i);
            }
            ++i;
        }
        return null;
    }

    public Element getElement(String pathToElement) {
        StringTokenizer st = new StringTokenizer(pathToElement, "/");
        Node node = null;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            node = node == null ? this.getNode(current, null) : this.getNode(current, node);
        }
        if (node != null) {
            return (Element)node;
        }
        return null;
    }

    public Element getElement(String pathToElement, String key, String value) {
        StringTokenizer st = new StringTokenizer(pathToElement, "/");
        Node node = null;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if ((node = node == null ? this.getNode(current, null, key, value, !st.hasMoreTokens()) : this.getNode(current, node, key, value, !st.hasMoreTokens())) != null) continue;
            return null;
        }
        if (node != null) {
            return (Element)node;
        }
        return null;
    }

    public Node getNode(String name, Node parent) {
        Node ret = null;
        Node node = parent == null ? this.doc.getDocumentElement().getFirstChild() : parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(name)) {
                ret = node;
            }
            node = node.getNextSibling();
        }
        return ret;
    }

    public Node getNode(String name, Node parent, String key, String value, boolean isLast) {
        Node node = parent == null ? this.doc.getDocumentElement().getFirstChild() : parent.getFirstChild();
        while (node != null) {
            Element el;
            if (node.getNodeType() == 1 && (el = (Element)node).getTagName().equals(name)) {
                if (!isLast) {
                    return node;
                }
                if (el.getAttribute(key).equals(value)) {
                    return node;
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public void setNodeValue(String name, String v) {
        Element e = this.getElement(name);
        NodeList nl = e.getChildNodes();
        if (nl.getLength() > 0) {
            nl.item(0).setNodeValue(v);
        } else {
            e.appendChild(this.doc.createTextNode(v));
        }
    }

    public String getNodeValue(String name) {
        String ret = "";
        NodeList nl = this.getElement(name).getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            ret = String.valueOf(ret) + nl.item(i).getNodeValue();
            ++i;
        }
        return ret;
    }

    public String getAbsolutePath(Element elem) {
        StringBuffer path = new StringBuffer(elem.getNodeName());
        try {
            Element parent = elem;
            while ((parent = (Element)parent.getParentNode()) != null) {
                path.insert(0, String.valueOf(parent.getNodeName()) + "/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path.toString();
    }

    private Document getDocument(String path) {
        Document document = null;
        try {
            URL url = new URL("file:/" + path);
            DocumentBuilderFactory doomFactory = DocumentBuilderFactory.newInstance();
            doomFactory.setValidating(false);
            DocumentBuilder doomBuilder = doomFactory.newDocumentBuilder();
            if (url == null) {
                System.out.println("The specified url to the xml is not correct!");
                throw new RuntimeException();
            }
            document = doomBuilder.parse(URLDecoder.decode(url.toString()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return document;
    }
}

