/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.beans;

import com.shfarr.BasicUtils;
import com.shfarr.beans.HeavyweightProperty;
import com.shfarr.beans.Introspector;
import com.shfarr.beans.PropertyHandler;
import java.util.List;

public class BeanUtils {
    public static String getPropertyNameFor(Class c) {
        String name = c.getName();
        if (name.indexOf(".") != -1) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return BasicUtils.changeCase(name, 1);
    }

    public static String packPropertyName(String propertyName) {
        String result = "";
        int i = 0;
        while (i < propertyName.length()) {
            if (propertyName.charAt(i) == ' ' || i == 0) {
                if (i != 0) {
                    ++i;
                }
                char c = propertyName.charAt(i);
                result = String.valueOf(result) + (c >= 'a' && c <= 'z' ? (char)(c - 32) : c);
            } else {
                result = propertyName.charAt(i) == '-' ? String.valueOf(result) + '_' : String.valueOf(result) + propertyName.charAt(i);
            }
            ++i;
        }
        return result;
    }

    public static String unpackPropertyName(String propertyName) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < propertyName.length()) {
            char c = propertyName.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (i != 0) {
                    result.append(' ');
                }
                result.append(c < 'a' ? (char)(c + 32) : c);
            } else if (c == '_') {
                result.append('-');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static PropertyHandler getHandler(Object object, String property) {
        PropertyHandler[] handlers = BeanUtils.getHandlers(object.getClass());
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i].getProperty().getName().equals(property)) {
                handlers[i].setObject(object);
                return handlers[i];
            }
            ++i;
        }
        return null;
    }

    public static PropertyHandler[] getHandlers(Object object) {
        PropertyHandler[] handlers = BeanUtils.getHandlers(object.getClass());
        int i = 0;
        while (i < handlers.length) {
            handlers[i].setObject(object);
            ++i;
        }
        return handlers;
    }

    public static PropertyHandler[] getHandlers(Class type) {
        List pd = Introspector.instance().getProperties(type);
        PropertyHandler[] handlers = new PropertyHandler[pd.size()];
        int i = 0;
        while (i < handlers.length) {
            handlers[i] = new PropertyHandler((HeavyweightProperty)pd.get(i), null);
            ++i;
        }
        return handlers;
    }

    public static String getPackage(Class cls) {
        String name = cls.getName();
        return name.lastIndexOf(46) != -1 ? name.substring(0, name.lastIndexOf(46)) : "";
    }

    public static String getName(Class cls) {
        String name = cls.getName();
        return name.lastIndexOf(46) != -1 ? name.substring(name.lastIndexOf(46) + 1) : name;
    }

    public static String capitalize(String str) {
        char[] chars = str.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return String.copyValueOf(chars);
    }

    public static String decapitalize(String str) {
        char[] chars = str.toCharArray();
        if (chars[0] >= 'A' && chars[0] <= 'Z') {
            chars[0] = (char)(chars[0] + 32);
        }
        return String.copyValueOf(chars);
    }

    public static String toString(Class type) {
        String name = "";
        while (type.isArray()) {
            name = String.valueOf(name) + "[]";
            type = type.getComponentType();
        }
        return String.valueOf(type.getName()) + name;
    }
}

