/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.beans;

import com.shfarr.beans.BeanUtils;
import com.shfarr.beans.HeavyweightProperty;
import com.shfarr.beans.Property;
import com.shfarr.patterns.Cache;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Introspector
extends Cache {
    public static final Object[] EMPTY_ARGS = new Object[0];
    public static final Class[] EMPTY_PARAMS = new Class[0];
    protected static Introspector instance = null;
    static /* synthetic */ Class class$0;

    protected Introspector() {
        super(50);
    }

    public HeavyweightProperty getProperty(Class type, String property) {
        List pds = this.getProperties(type);
        int i = 0;
        while (i < pds.size()) {
            if (((Property)pds.get(i)).getName().equals(property)) {
                return (HeavyweightProperty)pds.get(i);
            }
            ++i;
        }
        return null;
    }

    public List getProperties(Class type) {
        List descriptors = (List)this.locate(type.getName());
        if (descriptors == null) {
            descriptors = this.introspect(type);
            this.cache(descriptors, type.getName());
        }
        return descriptors;
    }

    public List introspect(Class type) {
        ArrayList properties = new ArrayList();
        int level = 0;
        do {
            Introspector.introspect(type, level, properties);
            ++level;
        } while ((type = type.getSuperclass()) != null);
        Collections.sort(properties);
        return properties;
    }

    protected static void introspect(Class c, int level, Collection propertyDescriptors) {
        Method[] methods = c.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                HeavyweightProperty descriptor;
                String propertyName;
                String name = methods[i].getName();
                if (name.startsWith("set") && methods[i].getParameterTypes().length == 1 && methods[i].getReturnType().equals(Void.TYPE)) {
                    propertyName = BeanUtils.unpackPropertyName(methods[i].getName().substring(3));
                    descriptor = Introspector.findDescriptorFor(propertyName, propertyDescriptors);
                    if (descriptor == null) {
                        descriptor = new HeavyweightProperty(propertyName, level, null, methods[i]);
                        propertyDescriptors.add(descriptor);
                    } else {
                        descriptor.setWriteMethod(methods[i]);
                    }
                } else if (name.startsWith("is") && methods[i].getParameterTypes().length == 0) {
                    propertyName = BeanUtils.unpackPropertyName(methods[i].getName().substring(2));
                    descriptor = Introspector.findDescriptorFor(propertyName, propertyDescriptors);
                    if (descriptor == null) {
                        descriptor = new HeavyweightProperty(propertyName, level, methods[i], null);
                        propertyDescriptors.add(descriptor);
                    } else {
                        descriptor.setReadMethod(methods[i]);
                    }
                } else if (name.startsWith("get") && methods[i].getParameterTypes().length == 0) {
                    propertyName = BeanUtils.unpackPropertyName(methods[i].getName().substring(3));
                    descriptor = Introspector.findDescriptorFor(propertyName, propertyDescriptors);
                    if (descriptor == null) {
                        descriptor = new HeavyweightProperty(propertyName, level, methods[i], null);
                        propertyDescriptors.add(descriptor);
                    } else {
                        descriptor.setReadMethod(methods[i]);
                    }
                }
            }
            ++i;
        }
    }

    protected static HeavyweightProperty findDescriptorFor(String propertyName, Collection propertyDescriptors) {
        Iterator iter = propertyDescriptors.iterator();
        while (iter.hasNext()) {
            HeavyweightProperty element = (HeavyweightProperty)iter.next();
            if (!element.getName().equals(propertyName)) continue;
            return element;
        }
        return null;
    }

    public static Introspector instance() {
        if (instance == null) {
            instance = new Introspector();
        }
        return instance;
    }
}

