/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.beans;

import com.shfarr.beans.BeanUtils;
import com.shfarr.beans.ObjectEncoder;
import com.shfarr.beans.PropertyHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import sun.misc.BASE64Encoder;

public class XMLEncoder
implements ObjectEncoder {
    protected static String encoding = "UTF-8";
    protected PrintWriter output = null;
    protected int currentIndent;
    protected int depth = -1;
    protected ObjectEncoder encoder = null;
    protected int indentIncrement = 6;
    protected boolean breakingLines = true;

    public XMLEncoder(OutputStream os) throws IOException {
        this(os, null);
    }

    public XMLEncoder(OutputStream os, ObjectEncoder encoder) throws IOException {
        this.output = new PrintWriter(os);
        this.encoder = encoder;
    }

    public void close() {
        this.output.close();
    }

    protected String indent(String s) {
        byte[] ind = new byte[this.currentIndent];
        int i = 0;
        while (i < ind.length) {
            ind[i] = 32;
            ++i;
        }
        return String.valueOf(new String(ind)) + s + (this.isBreakingLines() ? "\r\n" : "");
    }

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    public String toString(Object o) {
        if (o instanceof Number || o instanceof Character || o instanceof String || o instanceof Boolean) {
            return o.toString();
        }
        if (o instanceof byte[]) {
            return "\r\n" + new BASE64Encoder().encode((byte[])o);
        }
        return null;
    }

    protected Class clearType(Class type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    protected String getExtentAttribute(Object o) {
        String extent = null;
        while (o != null && o.getClass().isArray()) {
            int len = Array.getLength(o);
            extent = extent == null ? "" + len : String.valueOf(extent) + "x" + len;
            if (len <= 0) break;
            o = Array.get(o, 0);
        }
        return extent;
    }

    public void writeObject(Object obj) throws IOException {
        String objectValue;
        String qName;
        ++this.depth;
        this.currentIndent += this.indentIncrement;
        Class type = obj instanceof PropertyHandler ? ((PropertyHandler)obj).getProperty().getType() : obj.getClass();
        int extent = !(obj instanceof PropertyHandler) && type.isArray() ? Array.getLength(obj) : -1;
        String typeValue = BeanUtils.getName(this.clearType(type));
        String packageAttribute = " package=" + this.quote(BeanUtils.getPackage(this.clearType(type)));
        String typeAttribute = " type=" + this.quote(String.valueOf(this.clearType(type).getName()) + (type.isArray() ? "[]" : ""));
        String extentAttribute = type.isArray() ? " extent=" + this.quote(this.getExtentAttribute(obj)) : "";
        String string = qName = obj instanceof PropertyHandler ? BeanUtils.packPropertyName(((PropertyHandler)obj).getProperty().getName()) : typeValue;
        if (this.depth == 0) {
            this.currentIndent -= this.indentIncrement;
            this.output.print(this.indent("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(encoding) + "?>"));
        }
        if ((objectValue = this.getEncoder().toString(obj)) != null) {
            this.write(this.indent("<" + qName + packageAttribute + extentAttribute + ">" + objectValue + "</" + qName + ">"));
        } else if (obj instanceof PropertyHandler) {
            String enclosedTypeAttribute;
            Object o = ((PropertyHandler)obj).getValue();
            String sv = this.getEncoder().toString(o);
            String string2 = o == null ? "" : (enclosedTypeAttribute = " enclosed=" + this.quote(String.valueOf((o.getClass().isArray() ? o.getClass().getComponentType() : o.getClass()).getName()) + (o.getClass().isArray() ? "[]" : "")));
            if (o == null) {
                this.write(this.indent("<" + qName + typeAttribute + enclosedTypeAttribute + ">null</" + qName + ">"));
            } else if (sv != null) {
                this.write(this.indent("<" + qName + typeAttribute + enclosedTypeAttribute + ">" + sv + "</" + qName + ">"));
            } else {
                this.write(this.indent("<" + qName + typeAttribute + ">"));
                this.writeObject(o);
                this.write(this.indent("</" + qName + ">"));
            }
        } else {
            String comparatorAttribute = "";
            if (obj instanceof SortedMap && ((SortedMap)obj).comparator() != null) {
                comparatorAttribute = " comparator=" + this.quote(((SortedMap)obj).comparator().getClass().getName());
            }
            if (obj instanceof SortedSet && ((SortedSet)obj).comparator() != null) {
                comparatorAttribute = " comparator=" + this.quote(((SortedSet)obj).comparator().getClass().getName());
            }
            this.write(this.indent("<" + qName + packageAttribute + extentAttribute + comparatorAttribute + ">"));
            if (extent != -1) {
                int i = 0;
                while (i < extent) {
                    if (Array.get(obj, i) == null) {
                        this.currentIndent += this.indentIncrement;
                        this.write(this.indent("<Void package=\"java.lang\">null</Void>"));
                        this.currentIndent -= this.indentIncrement;
                    } else {
                        this.writeObject(Array.get(obj, i));
                    }
                    ++i;
                }
            } else if (obj instanceof Collection) {
                Iterator iter = ((Collection)obj).iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (o == null) {
                        this.currentIndent += this.indentIncrement;
                        this.write(this.indent("<Void package=\"java.lang\">null</Void>"));
                        this.currentIndent -= this.indentIncrement;
                        continue;
                    }
                    this.writeObject(o);
                }
            } else if (obj instanceof Map) {
                Iterator iter = ((Map)obj).keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    this.writeObject(key);
                    if (((Map)obj).get(key) == null) {
                        this.currentIndent += this.indentIncrement;
                        this.write(this.indent("<Void package=\"java.lang\" >null</Void>"));
                        this.currentIndent -= this.indentIncrement;
                        continue;
                    }
                    this.writeObject(((Map)obj).get(key));
                }
            } else {
                PropertyHandler[] handlers = BeanUtils.getHandlers(obj);
                int i = 0;
                while (i < handlers.length) {
                    if (handlers[i].getProperty().isReadWrite()) {
                        this.writeObject(handlers[i]);
                    }
                    ++i;
                }
            }
            this.write(this.indent("</" + qName + ">"));
        }
        if (this.depth == 0) {
            this.output.flush();
            this.output.close();
        }
        this.currentIndent -= this.indentIncrement;
        --this.depth;
    }

    protected void write(String s) {
        this.output.write(s);
    }

    public ObjectEncoder getEncoder() {
        return this.encoder != null ? this.encoder : this;
    }

    public void setEncoder(ObjectEncoder encoder) {
        this.encoder = encoder;
    }

    public int getIndentIncrement() {
        return this.indentIncrement;
    }

    public void setIndentIncrement(int indentIncrement) {
        this.indentIncrement = indentIncrement;
    }

    public boolean isBreakingLines() {
        return this.breakingLines;
    }

    public void setBreakingLines(boolean breakingLines) {
        this.breakingLines = breakingLines;
    }
}

