/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.jsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class JSPTable {
    private String name = null;
    private Collection columnNames = null;
    private Collection selection = null;
    private TreeMap data = null;
    private HashMap userData = null;

    public JSPTable(String name, Collection columnNames) {
        this.name = name;
        this.data = new TreeMap();
        this.columnNames = columnNames;
        this.userData = new HashMap();
    }

    public void add(Object[] rowData) {
        int k = 0;
        Iterator i = this.columnNames.iterator();
        while (i.hasNext()) {
            String column = (String)i.next();
            ArrayList<Object> columnData = (ArrayList<Object>)this.data.get(column);
            if (columnData == null) {
                columnData = new ArrayList<Object>();
                this.data.put(column, columnData);
            }
            columnData.add(rowData[k]);
            ++k;
        }
    }

    public void set(String column, int row, Object cellData) {
        ArrayList<Object> columnData = (ArrayList<Object>)this.data.get(column);
        if (columnData == null) {
            columnData = new ArrayList<Object>();
            this.data.put(column, columnData);
        }
        columnData.set(row, cellData);
    }

    public void setUserData(Object key, Object userData) {
        this.userData.put(key, userData);
    }

    public Object get(String column, int row) {
        return ((ArrayList)this.data.get(column)).get(row);
    }

    public Object getUserData(Object key) {
        return this.userData.get(key);
    }

    public String toString() {
        int rowCount = -1;
        StringBuffer buffer = new StringBuffer("<!-- " + this.name + "-->\r\n");
        buffer.append("<table width=100% name=\"" + this.name + "\" class=default_table >\r\n");
        buffer.append("    <tr>\r\n");
        Iterator i = this.columnNames.iterator();
        while (i.hasNext()) {
            String column = (String)i.next();
            if (rowCount == -1) {
                rowCount = this.data.isEmpty() ? 0 : ((List)this.data.get(column)).size();
            }
            String cls = "default_table_header" + (i.hasNext() ? "" : "_right");
            buffer.append("        <td class=" + cls + ">" + column + "</td>\r\n");
        }
        buffer.append("    </tr>");
        int k = 0;
        while (k < rowCount) {
            buffer.append("    <tr>\r\n");
            Iterator i2 = this.columnNames.iterator();
            while (i2.hasNext()) {
                String column = (String)i2.next();
                String cls = String.valueOf(this.selection != null && this.selection.contains(new Integer(k)) ? "default_table_selected_cell" : "default_table_cell") + (k == rowCount - 1 ? "_bottom" : "") + (i2.hasNext() ? "" : "_right");
                buffer.append("        <td class=" + cls + ">" + ((List)this.data.get(column)).get(k) + "</td>\r\n");
            }
            buffer.append("    </tr>");
            ++k;
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    public Collection getSelection() {
        return this.selection;
    }

    public void setSelection(Collection selection) {
        this.selection = selection;
    }
}

